/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.IntegratedServerUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap<String, RandomEntityProperties>();
    private static boolean active = false;
    private static boh renderGlobal;
    private static RandomEntity randomEntity;
    private static bqf tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_MCPATCHER_MOB = "mcpatcher/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(rw entity, aid world) {
        if (world == null) {
            return;
        }
        kk edm = entity.R();
        edm.spawnPosition = entity.c();
        edm.spawnBiome = world.b(edm.spawnPosition);
        UUID uuid = entity.be();
        if (entity instanceof zn) {
            RandomEntities.updateEntityVillager(uuid, (zn)entity);
        }
    }

    public static void entityUnloaded(rw entity, aid world) {
    }

    private static void updateEntityVillager(UUID uuid, zn ev) {
        rw se = IntegratedServerUtils.getEntity(uuid);
        if (!(se instanceof zn)) {
            return;
        }
        zn sev = (zn)se;
        int profSev = sev.de();
        ev.g(profSev);
        int careerId = Reflector.getFieldValueInt(sev, Reflector.EntityVillager_careerId, 0);
        Reflector.setFieldValueInt(ev, Reflector.EntityVillager_careerId, careerId);
        int careerLevel = Reflector.getFieldValueInt(sev, Reflector.EntityVillager_careerLevel, 0);
        Reflector.setFieldValueInt(ev, Reflector.EntityVillager_careerLevel, careerLevel);
    }

    public static void worldChanged(aid oldWorld, aid newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.J();
            for (int e = 0; e < entityList.size(); ++e) {
                rw entity = (rw)entityList.get(e);
                RandomEntities.entityLoaded(entity, newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static kn getTextureLocation(kn loc) {
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity re = RandomEntities.getRandomEntityRendered();
            if (re == null) {
                kn kn2 = loc;
                return kn2;
            }
            String name = loc.a();
            if (name.startsWith(PREFIX_DYNAMIC_TEXTURE_HORSE)) {
                name = RandomEntities.getHorseTexturePath(name, PREFIX_DYNAMIC_TEXTURE_HORSE.length());
            }
            if (!name.startsWith(PREFIX_TEXTURES_ENTITY) && !name.startsWith(PREFIX_TEXTURES_PAINTING)) {
                kn kn3 = loc;
                return kn3;
            }
            RandomEntityProperties props = mapProperties.get(name);
            if (props == null) {
                kn kn4 = loc;
                return kn4;
            }
            kn kn5 = props.getTextureLocation(loc, re);
            return kn5;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i = 0; i < HORSE_TEXTURES_ABBR.length; ++i) {
            String abbr = HORSE_TEXTURES_ABBR[i];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i];
        }
        return path;
    }

    private static IRandomEntity getRandomEntityRendered() {
        aqk te;
        if (RandomEntities.renderGlobal.renderedEntity != null) {
            randomEntity.setEntity(RandomEntities.renderGlobal.renderedEntity);
            return randomEntity;
        }
        if (RandomEntities.tileEntityRendererDispatcher.tileEntityRendered != null && (te = RandomEntities.tileEntityRendererDispatcher.tileEntityRendered).D() != null) {
            randomTileEntity.setTileEntity(te);
            return randomTileEntity;
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(kn loc, boolean mcpatcher) {
        RandomEntityProperties props;
        String path = loc.a();
        kn locProps = RandomEntities.getLocationProperties(loc, mcpatcher);
        if (locProps != null && (props = RandomEntities.parseProperties(locProps, loc)) != null) {
            return props;
        }
        kn[] variants = RandomEntities.getLocationsVariants(loc, mcpatcher);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, variants);
    }

    private static RandomEntityProperties parseProperties(kn propLoc, kn resLoc) {
        try {
            String path = propLoc.a();
            RandomEntities.dbg(resLoc.a() + ", properties: " + path);
            InputStream in = Config.getResourceStream(propLoc);
            if (in == null) {
                RandomEntities.warn("Properties not found: " + path);
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            RandomEntityProperties rmp = new RandomEntityProperties(props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e) {
            RandomEntities.warn("File not found: " + resLoc.a());
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static kn getLocationProperties(kn loc, boolean mcpatcher) {
        String path;
        String pathBase;
        String pathProps;
        kn locMcp = RandomEntities.getLocationRandom(loc, mcpatcher);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        kn locProps = new kn(domain, pathProps = (pathBase = StrUtils.removeSuffix(path = locMcp.a(), SUFFIX_PNG)) + SUFFIX_PROPERTIES);
        if (Config.hasResource(locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath(pathBase);
        if (pathParent == null) {
            return null;
        }
        kn locParentProps = new kn(domain, pathParent + SUFFIX_PROPERTIES);
        if (Config.hasResource(locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static kn getLocationRandom(kn loc, boolean mcpatcher) {
        String domain = loc.b();
        String path = loc.a();
        String prefixTextures = PREFIX_TEXTURES;
        String prefixRandom = PREFIX_OPTIFINE_RANDOM;
        if (mcpatcher) {
            prefixTextures = PREFIX_TEXTURES_ENTITY;
            prefixRandom = PREFIX_MCPATCHER_MOB;
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix(path, prefixTextures, prefixRandom);
        return new kn(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith(PREFIX_OPTIFINE_RANDOM)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_RANDOM, PREFIX_TEXTURES);
        }
        if (pathRandom.startsWith(PREFIX_MCPATCHER_MOB)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_MCPATCHER_MOB, PREFIX_TEXTURES_ENTITY);
        }
        return null;
    }

    protected static kn getLocationIndexed(kn loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        kn locNew = new kn(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i = 0; i < DEPENDANT_SUFFIXES.length; ++i) {
            String suffix = DEPENDANT_SUFFIXES[i];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix(path, suffix);
            return pathParent;
        }
        return null;
    }

    private static kn[] getLocationsVariants(kn loc, boolean mcpatcher) {
        ArrayList<kn> list = new ArrayList<kn>();
        list.add(loc);
        kn locRandom = RandomEntities.getLocationRandom(loc, mcpatcher);
        if (locRandom == null) {
            return null;
        }
        for (int i = 1; i < list.size() + 10; ++i) {
            int index = i + 1;
            kn locIndex = RandomEntities.getLocationIndexed(locRandom, index);
            if (!Config.hasResource(locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        kn[] locs = list.toArray(new kn[list.size()]);
        RandomEntities.dbg(loc.a() + ", variants: " + locs.length);
        return locs;
    }

    public static void update() {
        mapProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        tileEntityRendererDispatcher = bqf.a;
        String[] prefixes = new String[]{PREFIX_OPTIFINE_RANDOM, PREFIX_MCPATCHER_MOB};
        String[] suffixes = new String[]{SUFFIX_PNG, SUFFIX_PROPERTIES};
        String[] pathsRandom = ResUtils.collectFiles(prefixes, suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i = 0; i < pathsRandom.length; ++i) {
            RandomEntityProperties props;
            String path = pathsRandom[i];
            path = StrUtils.removeSuffix(path, suffixes);
            path = StrUtils.trimTrailing(path, "0123456789");
            String pathBase = RandomEntities.getPathBase(path = path + SUFFIX_PNG);
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            kn locBase = new kn(pathBase);
            if (!Config.hasResource(locBase) || (props = mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties(locBase, false);
            if (props == null) {
                props = RandomEntities.makeProperties(locBase, true);
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg("RandomEntities: " + str);
    }

    public static void warn(String str) {
        Config.warn("RandomEntities: " + str);
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, wr.class, String[].class, 0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, wr.class, String[].class, 1);
    }
}

