/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static byz spriteGrass = null;
    private static byz spriteGrassSide = null;
    private static byz spriteGrassPath = null;
    private static byz spriteGrassPathSide = null;
    private static byz spriteMycelium = null;
    private static byz spritePodzol = null;
    private static byz spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static cbh modelCubeGrass = null;
    private static cbh modelGrassPath = null;
    private static cbh modelCubeGrassPath = null;
    private static cbh modelCubeMycelium = null;
    private static cbh modelCubePodzol = null;
    private static cbh modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "blocks/grass_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "blocks/grass_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "blocks/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "blocks/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "blocks/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "blocks/dirt_podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "blocks/snow";

    public static void updateIcons(byy textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            cbh modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(byy textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.a(new kq(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.a(new kq(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.a(new kq(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.a(new kq(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.a(new kq(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.a(new kq(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.a(new kq(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            kq locFile = new kq(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e) {
            Config.warn("Error reading: " + name + ", " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static byz registerSprite(Properties props, String key, String textureDefault, byy textureMap) {
        kq locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new kq("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        kq locSprite = new kq(texture);
        byz sprite = textureMap.a(locSprite);
        return sprite;
    }

    public static List getFaceQuads(ajw blockAccess, atl blockState, co blockPos, cv facing, List quads) {
        if (facing == cv.b || facing == cv.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        alu block = blockState.v();
        if (block instanceof aoy) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof any) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof amv) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof anx) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(ajw blockAccess, atl blockState, co blockPos, cv facing, List quads) {
        boolean snowy;
        alu blockUp = blockAccess.o(blockPos.a()).v();
        boolean bl = snowy = blockUp == alv.aJ || blockUp == alv.aH;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == alv.aH) {
                    return modelCubeSnow.a(blockState, facing, 0L);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == alv.bw) {
                return modelCubeMycelium.a(blockState, facing, 0L);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, 0L);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, 0L);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(ajw blockAccess, atl blockState, co blockPos, cv facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == alv.da) {
                return modelGrassPath.a(blockState, facing, 0L);
            }
        } else {
            return modelGrassPath.a(blockState, facing, 0L);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(ajw blockAccess, atl blockState, co blockPos, cv facing, List quads) {
        alu blockTop = BetterGrass.getBlockAt(blockPos, cv.b, blockAccess);
        if (blockState.c((aub)amv.a) == amv.a.c) {
            boolean snowy;
            boolean bl = snowy = blockTop == alv.aJ || blockTop == alv.aH;
            if (Config.isBetterGrassFancy()) {
                co posSide;
                atl stateSide;
                if (snowy) {
                    if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == alv.aH) {
                        return modelCubeSnow.a(blockState, facing, 0L);
                    }
                } else if (betterPodzol && (stateSide = blockAccess.o(posSide = blockPos.b().a(facing))).v() == alv.d && stateSide.c((aub)amv.a) == amv.a.c) {
                    return modelCubePodzol.a(blockState, facing, 0L);
                }
            } else if (snowy) {
                if (betterPodzolSnow) {
                    return modelCubeSnow.a(blockState, facing, 0L);
                }
            } else if (betterPodzol) {
                return modelCubePodzol.a(blockState, facing, 0L);
            }
            return quads;
        }
        if (blockTop == alv.da) {
            if (betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == alv.da) {
                return modelCubeGrassPath.a(blockState, facing, 0L);
            }
            return quads;
        }
        return quads;
    }

    private static List getFaceQuadsGrass(ajw blockAccess, atl blockState, co blockPos, cv facing, List quads) {
        boolean snowy;
        alu blockUp = blockAccess.o(blockPos.a()).v();
        boolean bl = snowy = blockUp == alv.aJ || blockUp == alv.aH;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == alv.aH) {
                    return modelCubeSnow.a(blockState, facing, 0L);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == alv.c) {
                return modelCubeGrass.a(blockState, facing, 0L);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, 0L);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, 0L);
        }
        return quads;
    }

    private static alu getBlockAt(co blockPos, cv facing, ajw blockAccess) {
        co pos = blockPos.a(facing);
        alu block = blockAccess.o(pos).v();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

