/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;

public abstract class ModelAdapter {
    private Class entityClass;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(Class entityClass, String name, float shadowSize) {
        this.entityClass = entityClass;
        this.name = name;
        this.shadowSize = shadowSize;
    }

    public ModelAdapter(Class entityClass, String name, float shadowSize, String[] aliases) {
        this.entityClass = entityClass;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract blv makeModel();

    public abstract bni getModelRenderer(blv var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(blv var1, float var2);

    public bni[] getModelRenderers(blv model) {
        String[] names = this.getModelRendererNames();
        ArrayList<bni> list = new ArrayList<bni>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            bni mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        bni[] mrs = list.toArray(new bni[list.size()]);
        return mrs;
    }
}

