/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.IDataHolder;
import net.optifine.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.ARBCopyBuffer;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;
import oshi.SystemInfo;
import oshi.hardware.Processor;

/*
 * Exception performing whole class analysis ignored.
 */
public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean isNvidia;
    public static boolean isAmd;
    public static int GL_FRAMEBUFFER;
    public static int GL_RENDERBUFFER;
    public static int GL_COLOR_ATTACHMENT0;
    public static int GL_DEPTH_ATTACHMENT;
    public static int GL_FRAMEBUFFER_COMPLETE;
    public static int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
    public static int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
    public static int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER;
    public static int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER;
    private static FboMode fboMode;
    public static final boolean useFbo = true;
    private static boolean hasShaders;
    private static boolean useShaderArb;
    public static int GL_LINK_STATUS;
    public static int GL_COMPILE_STATUS;
    public static int GL_VERTEX_SHADER;
    public static int GL_FRAGMENT_SHADER;
    private static boolean useMultitextureArb;
    public static int GL_TEXTURE0;
    public static int GL_TEXTURE1;
    public static int GL_TEXTURE2;
    private static boolean useTexEnvCombineArb;
    public static int GL_COMBINE;
    public static int GL_INTERPOLATE;
    public static int GL_PRIMARY_COLOR;
    public static int GL_CONSTANT;
    public static int GL_PREVIOUS;
    public static int GL_COMBINE_RGB;
    public static int GL_SOURCE0_RGB;
    public static int GL_SOURCE1_RGB;
    public static int GL_SOURCE2_RGB;
    public static int GL_OPERAND0_RGB;
    public static int GL_OPERAND1_RGB;
    public static int GL_OPERAND2_RGB;
    public static int GL_COMBINE_ALPHA;
    public static int GL_SOURCE0_ALPHA;
    public static int GL_SOURCE1_ALPHA;
    public static int GL_SOURCE2_ALPHA;
    public static int GL_OPERAND0_ALPHA;
    public static int GL_OPERAND1_ALPHA;
    public static int GL_OPERAND2_ALPHA;
    private static boolean separateBlend;
    public static boolean useSeparateBlendExt;
    public static boolean isOpenGl21;
    public static boolean usePostProcess;
    private static String capsString;
    private static String cpuInfo;
    public static boolean useVbo;
    public static boolean needVbo;
    private static boolean useVboArb;
    public static int GL_ARRAY_BUFFER;
    public static int GL_STATIC_DRAW;
    private static final Map<Integer, String> LOOKUP_MAP;
    public static float lastBrightnessX;
    public static float lastBrightnessY;
    public static boolean openGL31;
    public static boolean vboRegions;
    public static int GL_COPY_READ_BUFFER;
    public static int GL_COPY_WRITE_BUFFER;
    public static final int GL_QUADS = 7;

    public static void populateSnooperWithOpenGL(IDataHolder p_populateSnooperWithOpenGL_0_) {
        p_populateSnooperWithOpenGL_0_.setFixedData("opengl_version", (Object)GlStateManager.getString((int)7938));
        p_populateSnooperWithOpenGL_0_.setFixedData("opengl_vendor", (Object)GlStateManager.getString((int)7936));
        GLCapabilities glcapabilities = GL.getCapabilities();
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_arrays_of_arrays]", (Object)glcapabilities.GL_ARB_arrays_of_arrays);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_base_instance]", (Object)glcapabilities.GL_ARB_base_instance);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_blend_func_extended]", (Object)glcapabilities.GL_ARB_blend_func_extended);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_clear_buffer_object]", (Object)glcapabilities.GL_ARB_clear_buffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_color_buffer_float]", (Object)glcapabilities.GL_ARB_color_buffer_float);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_compatibility]", (Object)glcapabilities.GL_ARB_compatibility);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_compressed_texture_pixel_storage]", (Object)glcapabilities.GL_ARB_compressed_texture_pixel_storage);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_compute_shader]", (Object)glcapabilities.GL_ARB_compute_shader);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_copy_buffer]", (Object)glcapabilities.GL_ARB_copy_buffer);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_copy_image]", (Object)glcapabilities.GL_ARB_copy_image);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_depth_buffer_float]", (Object)glcapabilities.GL_ARB_depth_buffer_float);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_compute_shader]", (Object)glcapabilities.GL_ARB_compute_shader);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_copy_buffer]", (Object)glcapabilities.GL_ARB_copy_buffer);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_copy_image]", (Object)glcapabilities.GL_ARB_copy_image);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_depth_buffer_float]", (Object)glcapabilities.GL_ARB_depth_buffer_float);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_depth_clamp]", (Object)glcapabilities.GL_ARB_depth_clamp);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_depth_texture]", (Object)glcapabilities.GL_ARB_depth_texture);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_draw_buffers]", (Object)glcapabilities.GL_ARB_draw_buffers);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_draw_buffers_blend]", (Object)glcapabilities.GL_ARB_draw_buffers_blend);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_draw_elements_base_vertex]", (Object)glcapabilities.GL_ARB_draw_elements_base_vertex);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_draw_indirect]", (Object)glcapabilities.GL_ARB_draw_indirect);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_draw_instanced]", (Object)glcapabilities.GL_ARB_draw_instanced);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_explicit_attrib_location]", (Object)glcapabilities.GL_ARB_explicit_attrib_location);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_explicit_uniform_location]", (Object)glcapabilities.GL_ARB_explicit_uniform_location);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_fragment_layer_viewport]", (Object)glcapabilities.GL_ARB_fragment_layer_viewport);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_fragment_program]", (Object)glcapabilities.GL_ARB_fragment_program);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_fragment_shader]", (Object)glcapabilities.GL_ARB_fragment_shader);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_fragment_program_shadow]", (Object)glcapabilities.GL_ARB_fragment_program_shadow);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_framebuffer_object]", (Object)glcapabilities.GL_ARB_framebuffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_framebuffer_sRGB]", (Object)glcapabilities.GL_ARB_framebuffer_sRGB);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_geometry_shader4]", (Object)glcapabilities.GL_ARB_geometry_shader4);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_gpu_shader5]", (Object)glcapabilities.GL_ARB_gpu_shader5);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_half_float_pixel]", (Object)glcapabilities.GL_ARB_half_float_pixel);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_half_float_vertex]", (Object)glcapabilities.GL_ARB_half_float_vertex);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_instanced_arrays]", (Object)glcapabilities.GL_ARB_instanced_arrays);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_map_buffer_alignment]", (Object)glcapabilities.GL_ARB_map_buffer_alignment);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_map_buffer_range]", (Object)glcapabilities.GL_ARB_map_buffer_range);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_multisample]", (Object)glcapabilities.GL_ARB_multisample);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_multitexture]", (Object)glcapabilities.GL_ARB_multitexture);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_occlusion_query2]", (Object)glcapabilities.GL_ARB_occlusion_query2);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_pixel_buffer_object]", (Object)glcapabilities.GL_ARB_pixel_buffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_seamless_cube_map]", (Object)glcapabilities.GL_ARB_seamless_cube_map);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_shader_objects]", (Object)glcapabilities.GL_ARB_shader_objects);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_shader_stencil_export]", (Object)glcapabilities.GL_ARB_shader_stencil_export);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_shader_texture_lod]", (Object)glcapabilities.GL_ARB_shader_texture_lod);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_shadow]", (Object)glcapabilities.GL_ARB_shadow);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_shadow_ambient]", (Object)glcapabilities.GL_ARB_shadow_ambient);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_stencil_texturing]", (Object)glcapabilities.GL_ARB_stencil_texturing);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_sync]", (Object)glcapabilities.GL_ARB_sync);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_tessellation_shader]", (Object)glcapabilities.GL_ARB_tessellation_shader);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_texture_border_clamp]", (Object)glcapabilities.GL_ARB_texture_border_clamp);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_texture_buffer_object]", (Object)glcapabilities.GL_ARB_texture_buffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_texture_cube_map]", (Object)glcapabilities.GL_ARB_texture_cube_map);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_texture_cube_map_array]", (Object)glcapabilities.GL_ARB_texture_cube_map_array);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_texture_non_power_of_two]", (Object)glcapabilities.GL_ARB_texture_non_power_of_two);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_uniform_buffer_object]", (Object)glcapabilities.GL_ARB_uniform_buffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_vertex_blend]", (Object)glcapabilities.GL_ARB_vertex_blend);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_vertex_buffer_object]", (Object)glcapabilities.GL_ARB_vertex_buffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_vertex_program]", (Object)glcapabilities.GL_ARB_vertex_program);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_vertex_shader]", (Object)glcapabilities.GL_ARB_vertex_shader);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_bindable_uniform]", (Object)glcapabilities.GL_EXT_bindable_uniform);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_blend_equation_separate]", (Object)glcapabilities.GL_EXT_blend_equation_separate);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_blend_func_separate]", (Object)glcapabilities.GL_EXT_blend_func_separate);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_blend_minmax]", (Object)glcapabilities.GL_EXT_blend_minmax);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_blend_subtract]", (Object)glcapabilities.GL_EXT_blend_subtract);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_draw_instanced]", (Object)glcapabilities.GL_EXT_draw_instanced);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_framebuffer_multisample]", (Object)glcapabilities.GL_EXT_framebuffer_multisample);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_framebuffer_object]", (Object)glcapabilities.GL_EXT_framebuffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_framebuffer_sRGB]", (Object)glcapabilities.GL_EXT_framebuffer_sRGB);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_geometry_shader4]", (Object)glcapabilities.GL_EXT_geometry_shader4);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_gpu_program_parameters]", (Object)glcapabilities.GL_EXT_gpu_program_parameters);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_gpu_shader4]", (Object)glcapabilities.GL_EXT_gpu_shader4);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_packed_depth_stencil]", (Object)glcapabilities.GL_EXT_packed_depth_stencil);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_separate_shader_objects]", (Object)glcapabilities.GL_EXT_separate_shader_objects);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_shader_image_load_store]", (Object)glcapabilities.GL_EXT_shader_image_load_store);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_shadow_funcs]", (Object)glcapabilities.GL_EXT_shadow_funcs);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_shared_texture_palette]", (Object)glcapabilities.GL_EXT_shared_texture_palette);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_stencil_clear_tag]", (Object)glcapabilities.GL_EXT_stencil_clear_tag);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_stencil_two_side]", (Object)glcapabilities.GL_EXT_stencil_two_side);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_stencil_wrap]", (Object)glcapabilities.GL_EXT_stencil_wrap);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_texture_array]", (Object)glcapabilities.GL_EXT_texture_array);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_texture_buffer_object]", (Object)glcapabilities.GL_EXT_texture_buffer_object);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_texture_integer]", (Object)glcapabilities.GL_EXT_texture_integer);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[EXT_texture_sRGB]", (Object)glcapabilities.GL_EXT_texture_sRGB);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[ARB_vertex_shader]", (Object)glcapabilities.GL_ARB_vertex_shader);
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[gl_max_vertex_uniforms]", (Object)GlStateManager.getInteger((int)35658));
        GlStateManager.getError();
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[gl_max_fragment_uniforms]", (Object)GlStateManager.getInteger((int)35657));
        GlStateManager.getError();
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[gl_max_vertex_attribs]", (Object)GlStateManager.getInteger((int)34921));
        GlStateManager.getError();
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[gl_max_vertex_texture_image_units]", (Object)GlStateManager.getInteger((int)35660));
        GlStateManager.getError();
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[gl_max_texture_image_units]", (Object)GlStateManager.getInteger((int)34930));
        GlStateManager.getError();
        p_populateSnooperWithOpenGL_0_.setFixedData("gl_caps[gl_max_array_texture_layers]", (Object)GlStateManager.getInteger((int)35071));
        GlStateManager.getError();
    }

    public static String getOpenGLVersionString() {
        return GLFW.glfwGetCurrentContext() == 0L ? "NO CONTEXT" : GlStateManager.getString((int)7937) + " GL version " + GlStateManager.getString((int)7938) + ", " + GlStateManager.getString((int)7936);
    }

    public static int getRefreshRate(MainWindow p_getRefreshRate_0_) {
        long i = GLFW.glfwGetWindowMonitor((long)p_getRefreshRate_0_.func_198092_i());
        if (i == 0L) {
            i = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode glfwvidmode = i == 0L ? null : GLFW.glfwGetVideoMode((long)i);
        return glfwvidmode == null ? 0 : glfwvidmode.refreshRate();
    }

    public static String getLWJGLVersion() {
        return Version.getVersion();
    }

    public static LongSupplier initGlfw() {
        MainWindow.func_211162_a((p_212905_0_, p_212905_1_) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", p_212905_0_, p_212905_1_));
        });
        ArrayList list = Lists.newArrayList();
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((p_212908_1_, p_212908_2_) -> list.add(String.format("GLFW error during init: [0x%X]%s", p_212908_1_, p_212908_2_)));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)list));
        }
        LongSupplier longsupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
        for (String s : list) {
            LOGGER.error("GLFW error collected during initialization: {}", (Object)s);
        }
        GLX.setGlfwErrorCallback((GLFWErrorCallbackI)glfwerrorcallback);
        return longsupplier;
    }

    public static void setGlfwErrorCallback(GLFWErrorCallbackI p_setGlfwErrorCallback_0_) {
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)p_setGlfwErrorCallback_0_).free();
    }

    public static boolean shouldClose(MainWindow p_shouldClose_0_) {
        return GLFW.glfwWindowShouldClose((long)p_shouldClose_0_.func_198092_i());
    }

    public static void pollEvents() {
        GLFW.glfwPollEvents();
    }

    public static String getOpenGLVersion() {
        return GlStateManager.getString((int)7938);
    }

    public static String getRenderer() {
        return GlStateManager.getString((int)7937);
    }

    public static String getVendor() {
        return GlStateManager.getString((int)7936);
    }

    public static void setupNvFogDistance() {
        if (GL.getCapabilities().GL_NV_fog_distance) {
            if (Config.isFogFancy()) {
                GlStateManager.fogi((int)34138, (int)34139);
            }
            if (Config.isFogFast()) {
                GlStateManager.fogi((int)34138, (int)34140);
            }
        }
    }

    public static boolean supportsOpenGL2() {
        return GL.getCapabilities().OpenGL20;
    }

    public static void withTextureRestore(Runnable p_withTextureRestore_0_) {
        GL11.glPushAttrib((int)270336);
        try {
            p_withTextureRestore_0_.run();
        }
        finally {
            GL11.glPopAttrib();
        }
    }

    public static ByteBuffer allocateMemory(int p_allocateMemory_0_) {
        return MemoryUtil.memAlloc((int)p_allocateMemory_0_);
    }

    public static void freeMemory(Buffer p_freeMemory_0_) {
        MemoryUtil.memFree((Buffer)p_freeMemory_0_);
    }

    public static void init() {
        Config.initDisplay();
        GLCapabilities glcapabilities = GL.getCapabilities();
        useMultitextureArb = glcapabilities.GL_ARB_multitexture && !glcapabilities.OpenGL13;
        useTexEnvCombineArb = glcapabilities.GL_ARB_texture_env_combine && !glcapabilities.OpenGL13;
        openGL31 = glcapabilities.OpenGL31;
        if (openGL31) {
            GL_COPY_READ_BUFFER = 36662;
            GL_COPY_WRITE_BUFFER = 36663;
        } else {
            GL_COPY_READ_BUFFER = 36662;
            GL_COPY_WRITE_BUFFER = 36663;
        }
        boolean copyBuffer = openGL31 || glcapabilities.GL_ARB_copy_buffer;
        boolean multiDrawArrays = glcapabilities.OpenGL14;
        boolean bl = vboRegions = copyBuffer && multiDrawArrays;
        if (!vboRegions) {
            ArrayList<String> list = new ArrayList<String>();
            if (!copyBuffer) {
                list.add("OpenGL 1.3, ARB_copy_buffer");
            }
            if (!multiDrawArrays) {
                list.add("OpenGL 1.4");
            }
            String vboRegionWarn = "VboRegions not supported, missing: " + Config.listToString(list);
            Config.dbg(vboRegionWarn);
            list.add(vboRegionWarn);
        }
        if (useMultitextureArb) {
            capsString = capsString + "Using ARB_multitexture.\n";
            GL_TEXTURE0 = 33984;
            GL_TEXTURE1 = 33985;
            GL_TEXTURE2 = 33986;
        } else {
            capsString = capsString + "Using GL 1.3 multitexturing.\n";
            GL_TEXTURE0 = 33984;
            GL_TEXTURE1 = 33985;
            GL_TEXTURE2 = 33986;
        }
        if (useTexEnvCombineArb) {
            capsString = capsString + "Using ARB_texture_env_combine.\n";
            GL_COMBINE = 34160;
            GL_INTERPOLATE = 34165;
            GL_PRIMARY_COLOR = 34167;
            GL_CONSTANT = 34166;
            GL_PREVIOUS = 34168;
            GL_COMBINE_RGB = 34161;
            GL_SOURCE0_RGB = 34176;
            GL_SOURCE1_RGB = 34177;
            GL_SOURCE2_RGB = 34178;
            GL_OPERAND0_RGB = 34192;
            GL_OPERAND1_RGB = 34193;
            GL_OPERAND2_RGB = 34194;
            GL_COMBINE_ALPHA = 34162;
            GL_SOURCE0_ALPHA = 34184;
            GL_SOURCE1_ALPHA = 34185;
            GL_SOURCE2_ALPHA = 34186;
            GL_OPERAND0_ALPHA = 34200;
            GL_OPERAND1_ALPHA = 34201;
            GL_OPERAND2_ALPHA = 34202;
        } else {
            capsString = capsString + "Using GL 1.3 texture combiners.\n";
            GL_COMBINE = 34160;
            GL_INTERPOLATE = 34165;
            GL_PRIMARY_COLOR = 34167;
            GL_CONSTANT = 34166;
            GL_PREVIOUS = 34168;
            GL_COMBINE_RGB = 34161;
            GL_SOURCE0_RGB = 34176;
            GL_SOURCE1_RGB = 34177;
            GL_SOURCE2_RGB = 34178;
            GL_OPERAND0_RGB = 34192;
            GL_OPERAND1_RGB = 34193;
            GL_OPERAND2_RGB = 34194;
            GL_COMBINE_ALPHA = 34162;
            GL_SOURCE0_ALPHA = 34184;
            GL_SOURCE1_ALPHA = 34185;
            GL_SOURCE2_ALPHA = 34186;
            GL_OPERAND0_ALPHA = 34200;
            GL_OPERAND1_ALPHA = 34201;
            GL_OPERAND2_ALPHA = 34202;
        }
        useSeparateBlendExt = glcapabilities.GL_EXT_blend_func_separate && !glcapabilities.OpenGL14;
        separateBlend = glcapabilities.OpenGL14 || glcapabilities.GL_EXT_blend_func_separate;
        capsString = capsString + "Using framebuffer objects because ";
        if (glcapabilities.OpenGL30) {
            capsString = capsString + "OpenGL 3.0 is supported and separate blending is supported.\n";
            fboMode = FboMode.BASE;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_FRAMEBUFFER_COMPLETE = 36053;
            GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
            GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
            GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
            GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        } else if (glcapabilities.GL_ARB_framebuffer_object) {
            capsString = capsString + "ARB_framebuffer_object is supported and separate blending is supported.\n";
            fboMode = FboMode.ARB;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_FRAMEBUFFER_COMPLETE = 36053;
            GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
            GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
            GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
            GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        } else if (glcapabilities.GL_EXT_framebuffer_object) {
            capsString = capsString + "EXT_framebuffer_object is supported.\n";
            fboMode = FboMode.EXT;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_FRAMEBUFFER_COMPLETE = 36053;
            GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
            GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
            GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
            GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        }
        isOpenGl21 = glcapabilities.OpenGL21;
        hasShaders = isOpenGl21 || glcapabilities.GL_ARB_vertex_shader && glcapabilities.GL_ARB_fragment_shader && glcapabilities.GL_ARB_shader_objects;
        capsString = capsString + "Shaders are " + (hasShaders ? "" : "not ") + "available because ";
        if (hasShaders) {
            if (glcapabilities.OpenGL21) {
                capsString = capsString + "OpenGL 2.1 is supported.\n";
                useShaderArb = false;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            } else {
                capsString = capsString + "ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are supported.\n";
                useShaderArb = true;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            }
        } else {
            capsString = capsString + "OpenGL 2.1 is " + (glcapabilities.OpenGL21 ? "" : "not ") + "supported, ";
            capsString = capsString + "ARB_shader_objects is " + (glcapabilities.GL_ARB_shader_objects ? "" : "not ") + "supported, ";
            capsString = capsString + "ARB_vertex_shader is " + (glcapabilities.GL_ARB_vertex_shader ? "" : "not ") + "supported, and ";
            capsString = capsString + "ARB_fragment_shader is " + (glcapabilities.GL_ARB_fragment_shader ? "" : "not ") + "supported.\n";
        }
        usePostProcess = hasShaders;
        String s = GL11.glGetString((int)7936).toLowerCase(Locale.ROOT);
        isNvidia = s.contains("nvidia");
        useVboArb = !glcapabilities.OpenGL15 && glcapabilities.GL_ARB_vertex_buffer_object;
        useVbo = glcapabilities.OpenGL15 || useVboArb;
        capsString = capsString + "VBOs are available because ";
        if (useVboArb) {
            capsString = capsString + "ARB_vertex_buffer_object is supported.\n";
            GL_STATIC_DRAW = 35044;
            GL_ARRAY_BUFFER = 34962;
        } else {
            capsString = capsString + "OpenGL 1.5 is supported.\n";
            GL_STATIC_DRAW = 35044;
            GL_ARRAY_BUFFER = 34962;
        }
        isAmd = s.contains("ati");
        if (isAmd) {
            needVbo = true;
        }
        try {
            Processor[] aprocessor = new SystemInfo().getHardware().getProcessors();
            cpuInfo = String.format("%dx %s", aprocessor.length, aprocessor[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isNextGen() {
        return usePostProcess;
    }

    public static String getCapsString() {
        return capsString;
    }

    public static int glGetProgrami(int program, int pname) {
        return useShaderArb ? ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)pname) : GL20.glGetProgrami((int)program, (int)pname);
    }

    public static void glAttachShader(int program, int shaderIn) {
        if (useShaderArb) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)shaderIn);
        } else {
            GL20.glAttachShader((int)program, (int)shaderIn);
        }
    }

    public static void glDeleteShader(int shaderIn) {
        if (useShaderArb) {
            ARBShaderObjects.glDeleteObjectARB((int)shaderIn);
        } else {
            GL20.glDeleteShader((int)shaderIn);
        }
    }

    public static int glCreateShader(int type) {
        return useShaderArb ? ARBShaderObjects.glCreateShaderObjectARB((int)type) : GL20.glCreateShader((int)type);
    }

    public static void glShaderSource(int shaderIn, CharSequence string) {
        if (useShaderArb) {
            ARBShaderObjects.glShaderSourceARB((int)shaderIn, (CharSequence)string);
        } else {
            GL20.glShaderSource((int)shaderIn, (CharSequence)string);
        }
    }

    public static void glCompileShader(int shaderIn) {
        if (useShaderArb) {
            ARBShaderObjects.glCompileShaderARB((int)shaderIn);
        } else {
            GL20.glCompileShader((int)shaderIn);
        }
    }

    public static int glGetShaderi(int shaderIn, int pname) {
        return useShaderArb ? ARBShaderObjects.glGetObjectParameteriARB((int)shaderIn, (int)pname) : GL20.glGetShaderi((int)shaderIn, (int)pname);
    }

    public static String glGetShaderInfoLog(int shaderIn, int maxLength) {
        return useShaderArb ? ARBShaderObjects.glGetInfoLogARB((int)shaderIn, (int)maxLength) : GL20.glGetShaderInfoLog((int)shaderIn, (int)maxLength);
    }

    public static String glGetProgramInfoLog(int program, int maxLength) {
        return useShaderArb ? ARBShaderObjects.glGetInfoLogARB((int)program, (int)maxLength) : GL20.glGetProgramInfoLog((int)program, (int)maxLength);
    }

    public static void glUseProgram(int program) {
        if (useShaderArb) {
            ARBShaderObjects.glUseProgramObjectARB((int)program);
        } else {
            GL20.glUseProgram((int)program);
        }
    }

    public static int glCreateProgram() {
        return useShaderArb ? ARBShaderObjects.glCreateProgramObjectARB() : GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int program) {
        if (useShaderArb) {
            ARBShaderObjects.glDeleteObjectARB((int)program);
        } else {
            GL20.glDeleteProgram((int)program);
        }
    }

    public static void glLinkProgram(int program) {
        if (useShaderArb) {
            ARBShaderObjects.glLinkProgramARB((int)program);
        } else {
            GL20.glLinkProgram((int)program);
        }
    }

    public static int glGetUniformLocation(int program, CharSequence name) {
        return useShaderArb ? ARBShaderObjects.glGetUniformLocationARB((int)program, (CharSequence)name) : GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public static void glUniform1(int p_glUniform1_0_, IntBuffer p_glUniform1_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform1ivARB((int)p_glUniform1_0_, (IntBuffer)p_glUniform1_1_);
        } else {
            GL20.glUniform1iv((int)p_glUniform1_0_, (IntBuffer)p_glUniform1_1_);
        }
    }

    public static void glUniform1i(int location, int value) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform1iARB((int)location, (int)value);
        } else {
            GL20.glUniform1i((int)location, (int)value);
        }
    }

    public static void glUniform1(int p_glUniform1_0_, FloatBuffer p_glUniform1_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform1fvARB((int)p_glUniform1_0_, (FloatBuffer)p_glUniform1_1_);
        } else {
            GL20.glUniform1fv((int)p_glUniform1_0_, (FloatBuffer)p_glUniform1_1_);
        }
    }

    public static void glUniform2(int p_glUniform2_0_, IntBuffer p_glUniform2_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform2ivARB((int)p_glUniform2_0_, (IntBuffer)p_glUniform2_1_);
        } else {
            GL20.glUniform2iv((int)p_glUniform2_0_, (IntBuffer)p_glUniform2_1_);
        }
    }

    public static void glUniform2(int p_glUniform2_0_, FloatBuffer p_glUniform2_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform2fvARB((int)p_glUniform2_0_, (FloatBuffer)p_glUniform2_1_);
        } else {
            GL20.glUniform2fv((int)p_glUniform2_0_, (FloatBuffer)p_glUniform2_1_);
        }
    }

    public static void glUniform3(int p_glUniform3_0_, IntBuffer p_glUniform3_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform3ivARB((int)p_glUniform3_0_, (IntBuffer)p_glUniform3_1_);
        } else {
            GL20.glUniform3iv((int)p_glUniform3_0_, (IntBuffer)p_glUniform3_1_);
        }
    }

    public static void glUniform3(int p_glUniform3_0_, FloatBuffer p_glUniform3_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform3fvARB((int)p_glUniform3_0_, (FloatBuffer)p_glUniform3_1_);
        } else {
            GL20.glUniform3fv((int)p_glUniform3_0_, (FloatBuffer)p_glUniform3_1_);
        }
    }

    public static void glUniform4(int p_glUniform4_0_, IntBuffer p_glUniform4_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform4ivARB((int)p_glUniform4_0_, (IntBuffer)p_glUniform4_1_);
        } else {
            GL20.glUniform4iv((int)p_glUniform4_0_, (IntBuffer)p_glUniform4_1_);
        }
    }

    public static void glUniform4(int p_glUniform4_0_, FloatBuffer p_glUniform4_1_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform4fvARB((int)p_glUniform4_0_, (FloatBuffer)p_glUniform4_1_);
        } else {
            GL20.glUniform4fv((int)p_glUniform4_0_, (FloatBuffer)p_glUniform4_1_);
        }
    }

    public static void glUniformMatrix2(int p_glUniformMatrix2_0_, boolean p_glUniformMatrix2_1_, FloatBuffer p_glUniformMatrix2_2_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniformMatrix2fvARB((int)p_glUniformMatrix2_0_, (boolean)p_glUniformMatrix2_1_, (FloatBuffer)p_glUniformMatrix2_2_);
        } else {
            GL20.glUniformMatrix2fv((int)p_glUniformMatrix2_0_, (boolean)p_glUniformMatrix2_1_, (FloatBuffer)p_glUniformMatrix2_2_);
        }
    }

    public static void glUniformMatrix3(int p_glUniformMatrix3_0_, boolean p_glUniformMatrix3_1_, FloatBuffer p_glUniformMatrix3_2_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniformMatrix3fvARB((int)p_glUniformMatrix3_0_, (boolean)p_glUniformMatrix3_1_, (FloatBuffer)p_glUniformMatrix3_2_);
        } else {
            GL20.glUniformMatrix3fv((int)p_glUniformMatrix3_0_, (boolean)p_glUniformMatrix3_1_, (FloatBuffer)p_glUniformMatrix3_2_);
        }
    }

    public static void glUniformMatrix4(int p_glUniformMatrix4_0_, boolean p_glUniformMatrix4_1_, FloatBuffer p_glUniformMatrix4_2_) {
        if (useShaderArb) {
            ARBShaderObjects.glUniformMatrix4fvARB((int)p_glUniformMatrix4_0_, (boolean)p_glUniformMatrix4_1_, (FloatBuffer)p_glUniformMatrix4_2_);
        } else {
            GL20.glUniformMatrix4fv((int)p_glUniformMatrix4_0_, (boolean)p_glUniformMatrix4_1_, (FloatBuffer)p_glUniformMatrix4_2_);
        }
    }

    public static int glGetAttribLocation(int p_glGetAttribLocation_0_, CharSequence p_glGetAttribLocation_1_) {
        return useShaderArb ? ARBVertexShader.glGetAttribLocationARB((int)p_glGetAttribLocation_0_, (CharSequence)p_glGetAttribLocation_1_) : GL20.glGetAttribLocation((int)p_glGetAttribLocation_0_, (CharSequence)p_glGetAttribLocation_1_);
    }

    public static int glGenBuffers() {
        return useVboArb ? ARBVertexBufferObject.glGenBuffersARB() : GL15.glGenBuffers();
    }

    public static void glGenBuffers(IntBuffer p_glGenBuffers_0_) {
        if (useVboArb) {
            ARBVertexBufferObject.glGenBuffersARB((IntBuffer)p_glGenBuffers_0_);
        } else {
            GL15.glGenBuffers((IntBuffer)p_glGenBuffers_0_);
        }
    }

    public static void glBindBuffer(int p_glBindBuffer_0_, int p_glBindBuffer_1_) {
        if (useVboArb) {
            ARBVertexBufferObject.glBindBufferARB((int)p_glBindBuffer_0_, (int)p_glBindBuffer_1_);
        } else {
            GL15.glBindBuffer((int)p_glBindBuffer_0_, (int)p_glBindBuffer_1_);
        }
    }

    public static void glBufferData(int p_glBufferData_0_, ByteBuffer p_glBufferData_1_, int p_glBufferData_2_) {
        if (useVboArb) {
            ARBVertexBufferObject.glBufferDataARB((int)p_glBufferData_0_, (ByteBuffer)p_glBufferData_1_, (int)p_glBufferData_2_);
        } else {
            GL15.glBufferData((int)p_glBufferData_0_, (ByteBuffer)p_glBufferData_1_, (int)p_glBufferData_2_);
        }
    }

    public static void glDeleteBuffers(int p_glDeleteBuffers_0_) {
        if (useVboArb) {
            ARBVertexBufferObject.glDeleteBuffersARB((int)p_glDeleteBuffers_0_);
        } else {
            GL15.glDeleteBuffers((int)p_glDeleteBuffers_0_);
        }
    }

    public static void glDeleteBuffers(IntBuffer p_glDeleteBuffers_0_) {
        if (useVboArb) {
            ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)p_glDeleteBuffers_0_);
        } else {
            GL15.glDeleteBuffers((IntBuffer)p_glDeleteBuffers_0_);
        }
    }

    public static boolean useVbo() {
        if (Config.isMultiTexture()) {
            return false;
        }
        if (Config.isRenderRegions() && !vboRegions) {
            return false;
        }
        return useVbo && Minecraft.func_71410_x().field_71474_y.ofUseVbo;
    }

    public static void glBindFramebuffer(int p_glBindFramebuffer_0_, int p_glBindFramebuffer_1_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                GL30.glBindFramebuffer((int)p_glBindFramebuffer_0_, (int)p_glBindFramebuffer_1_);
                break;
            }
            case 2: {
                ARBFramebufferObject.glBindFramebuffer((int)p_glBindFramebuffer_0_, (int)p_glBindFramebuffer_1_);
                break;
            }
            case 3: {
                EXTFramebufferObject.glBindFramebufferEXT((int)p_glBindFramebuffer_0_, (int)p_glBindFramebuffer_1_);
            }
        }
    }

    public static void glBindRenderbuffer(int p_glBindRenderbuffer_0_, int p_glBindRenderbuffer_1_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                GL30.glBindRenderbuffer((int)p_glBindRenderbuffer_0_, (int)p_glBindRenderbuffer_1_);
                break;
            }
            case 2: {
                ARBFramebufferObject.glBindRenderbuffer((int)p_glBindRenderbuffer_0_, (int)p_glBindRenderbuffer_1_);
                break;
            }
            case 3: {
                EXTFramebufferObject.glBindRenderbufferEXT((int)p_glBindRenderbuffer_0_, (int)p_glBindRenderbuffer_1_);
            }
        }
    }

    public static void glDeleteRenderbuffers(int p_glDeleteRenderbuffers_0_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                GL30.glDeleteRenderbuffers((int)p_glDeleteRenderbuffers_0_);
                break;
            }
            case 2: {
                ARBFramebufferObject.glDeleteRenderbuffers((int)p_glDeleteRenderbuffers_0_);
                break;
            }
            case 3: {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)p_glDeleteRenderbuffers_0_);
            }
        }
    }

    public static void glDeleteFramebuffers(int p_glDeleteFramebuffers_0_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                GL30.glDeleteFramebuffers((int)p_glDeleteFramebuffers_0_);
                break;
            }
            case 2: {
                ARBFramebufferObject.glDeleteFramebuffers((int)p_glDeleteFramebuffers_0_);
                break;
            }
            case 3: {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)p_glDeleteFramebuffers_0_);
            }
        }
    }

    public static int glGenFramebuffers() {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                return GL30.glGenFramebuffers();
            }
            case 2: {
                return ARBFramebufferObject.glGenFramebuffers();
            }
            case 3: {
                return EXTFramebufferObject.glGenFramebuffersEXT();
            }
        }
        return -1;
    }

    public static int glGenRenderbuffers() {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                return GL30.glGenRenderbuffers();
            }
            case 2: {
                return ARBFramebufferObject.glGenRenderbuffers();
            }
            case 3: {
                return EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return -1;
    }

    public static void glRenderbufferStorage(int p_glRenderbufferStorage_0_, int p_glRenderbufferStorage_1_, int p_glRenderbufferStorage_2_, int p_glRenderbufferStorage_3_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                GL30.glRenderbufferStorage((int)p_glRenderbufferStorage_0_, (int)p_glRenderbufferStorage_1_, (int)p_glRenderbufferStorage_2_, (int)p_glRenderbufferStorage_3_);
                break;
            }
            case 2: {
                ARBFramebufferObject.glRenderbufferStorage((int)p_glRenderbufferStorage_0_, (int)p_glRenderbufferStorage_1_, (int)p_glRenderbufferStorage_2_, (int)p_glRenderbufferStorage_3_);
                break;
            }
            case 3: {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)p_glRenderbufferStorage_0_, (int)p_glRenderbufferStorage_1_, (int)p_glRenderbufferStorage_2_, (int)p_glRenderbufferStorage_3_);
            }
        }
    }

    public static void glFramebufferRenderbuffer(int p_glFramebufferRenderbuffer_0_, int p_glFramebufferRenderbuffer_1_, int p_glFramebufferRenderbuffer_2_, int p_glFramebufferRenderbuffer_3_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                GL30.glFramebufferRenderbuffer((int)p_glFramebufferRenderbuffer_0_, (int)p_glFramebufferRenderbuffer_1_, (int)p_glFramebufferRenderbuffer_2_, (int)p_glFramebufferRenderbuffer_3_);
                break;
            }
            case 2: {
                ARBFramebufferObject.glFramebufferRenderbuffer((int)p_glFramebufferRenderbuffer_0_, (int)p_glFramebufferRenderbuffer_1_, (int)p_glFramebufferRenderbuffer_2_, (int)p_glFramebufferRenderbuffer_3_);
                break;
            }
            case 3: {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)p_glFramebufferRenderbuffer_0_, (int)p_glFramebufferRenderbuffer_1_, (int)p_glFramebufferRenderbuffer_2_, (int)p_glFramebufferRenderbuffer_3_);
            }
        }
    }

    public static int glCheckFramebufferStatus(int p_glCheckFramebufferStatus_0_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                return GL30.glCheckFramebufferStatus((int)p_glCheckFramebufferStatus_0_);
            }
            case 2: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)p_glCheckFramebufferStatus_0_);
            }
            case 3: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)p_glCheckFramebufferStatus_0_);
            }
        }
        return -1;
    }

    public static void glFramebufferTexture2D(int p_glFramebufferTexture2D_0_, int p_glFramebufferTexture2D_1_, int p_glFramebufferTexture2D_2_, int p_glFramebufferTexture2D_3_, int p_glFramebufferTexture2D_4_) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                GL30.glFramebufferTexture2D((int)p_glFramebufferTexture2D_0_, (int)p_glFramebufferTexture2D_1_, (int)p_glFramebufferTexture2D_2_, (int)p_glFramebufferTexture2D_3_, (int)p_glFramebufferTexture2D_4_);
                break;
            }
            case 2: {
                ARBFramebufferObject.glFramebufferTexture2D((int)p_glFramebufferTexture2D_0_, (int)p_glFramebufferTexture2D_1_, (int)p_glFramebufferTexture2D_2_, (int)p_glFramebufferTexture2D_3_, (int)p_glFramebufferTexture2D_4_);
                break;
            }
            case 3: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)p_glFramebufferTexture2D_0_, (int)p_glFramebufferTexture2D_1_, (int)p_glFramebufferTexture2D_2_, (int)p_glFramebufferTexture2D_3_, (int)p_glFramebufferTexture2D_4_);
            }
        }
    }

    public static int getBoundFramebuffer() {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GLX$FboMode[fboMode.ordinal()]) {
            case 1: {
                return GlStateManager.getInteger((int)36006);
            }
            case 2: {
                return GlStateManager.getInteger((int)36006);
            }
            case 3: {
                return GlStateManager.getInteger((int)36006);
            }
        }
        return 0;
    }

    public static void glActiveTexture(int p_glActiveTexture_0_) {
        if (useMultitextureArb) {
            ARBMultitexture.glActiveTextureARB((int)p_glActiveTexture_0_);
        } else {
            GL13.glActiveTexture((int)p_glActiveTexture_0_);
        }
    }

    public static void glClientActiveTexture(int p_glClientActiveTexture_0_) {
        if (useMultitextureArb) {
            ARBMultitexture.glClientActiveTextureARB((int)p_glClientActiveTexture_0_);
        } else {
            GL13.glClientActiveTexture((int)p_glClientActiveTexture_0_);
        }
    }

    public static void glMultiTexCoord2f(int p_glMultiTexCoord2f_0_, float p_glMultiTexCoord2f_1_, float p_glMultiTexCoord2f_2_) {
        if (useMultitextureArb) {
            ARBMultitexture.glMultiTexCoord2fARB((int)p_glMultiTexCoord2f_0_, (float)p_glMultiTexCoord2f_1_, (float)p_glMultiTexCoord2f_2_);
        } else {
            GL13.glMultiTexCoord2f((int)p_glMultiTexCoord2f_0_, (float)p_glMultiTexCoord2f_1_, (float)p_glMultiTexCoord2f_2_);
        }
        if (p_glMultiTexCoord2f_0_ == GL_TEXTURE1) {
            lastBrightnessX = p_glMultiTexCoord2f_1_;
            lastBrightnessY = p_glMultiTexCoord2f_2_;
        }
    }

    public static void glBlendFuncSeparate(int p_glBlendFuncSeparate_0_, int p_glBlendFuncSeparate_1_, int p_glBlendFuncSeparate_2_, int p_glBlendFuncSeparate_3_) {
        if (separateBlend) {
            if (useSeparateBlendExt) {
                EXTBlendFuncSeparate.glBlendFuncSeparateEXT((int)p_glBlendFuncSeparate_0_, (int)p_glBlendFuncSeparate_1_, (int)p_glBlendFuncSeparate_2_, (int)p_glBlendFuncSeparate_3_);
            } else {
                GL14.glBlendFuncSeparate((int)p_glBlendFuncSeparate_0_, (int)p_glBlendFuncSeparate_1_, (int)p_glBlendFuncSeparate_2_, (int)p_glBlendFuncSeparate_3_);
            }
        } else {
            GL11.glBlendFunc((int)p_glBlendFuncSeparate_0_, (int)p_glBlendFuncSeparate_1_);
        }
    }

    public static boolean isUsingFBOs() {
        if (Config.isFastRender()) {
            return false;
        }
        if (Config.isAntialiasing()) {
            return false;
        }
        return fboMode != null && Minecraft.func_71410_x().field_71474_y.ofUseFbo;
    }

    public static void glBufferData(int target, long size, int usage) {
        if (useVboArb) {
            ARBVertexBufferObject.glBufferDataARB((int)target, (long)size, (int)usage);
        } else {
            GL15.glBufferData((int)target, (long)size, (int)usage);
        }
    }

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        if (useVboArb) {
            ARBVertexBufferObject.glBufferSubDataARB((int)target, (long)offset, (ByteBuffer)data);
        } else {
            GL15.glBufferSubData((int)target, (long)offset, (ByteBuffer)data);
        }
    }

    public static void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size) {
        if (openGL31) {
            GL31.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
        } else {
            ARBCopyBuffer.glCopyBufferSubData((int)readTarget, (int)writeTarget, (long)readOffset, (long)writeOffset, (long)size);
        }
    }

    public static String getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void renderCrosshair(int p_renderCrosshair_0_) {
        GLX.renderCrosshair((int)p_renderCrosshair_0_, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void renderCrosshair(int p_renderCrosshair_0_, boolean p_renderCrosshair_1_, boolean p_renderCrosshair_2_, boolean p_renderCrosshair_3_) {
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glLineWidth((float)4.0f);
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (p_renderCrosshair_1_) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)p_renderCrosshair_0_, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        if (p_renderCrosshair_2_) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)p_renderCrosshair_0_, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        if (p_renderCrosshair_3_) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, (double)p_renderCrosshair_0_).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)2.0f);
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (p_renderCrosshair_1_) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)p_renderCrosshair_0_, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        }
        if (p_renderCrosshair_2_) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)p_renderCrosshair_0_, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
        }
        if (p_renderCrosshair_3_) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(127, 127, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, (double)p_renderCrosshair_0_).func_181669_b(127, 127, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
    }

    public static String getErrorString(int p_getErrorString_0_) {
        return (String)LOOKUP_MAP.get(p_getErrorString_0_);
    }

    public static <T> T make(Supplier<T> p_make_0_) {
        return p_make_0_.get();
    }

    public static <T> T make(T p_make_0_, Consumer<T> p_make_1_) {
        p_make_1_.accept(p_make_0_);
        return p_make_0_;
    }

    static {
        capsString = "";
        LOOKUP_MAP = (Map)GLX.make((Object)Maps.newHashMap(), (T p_212906_0_) -> {
            p_212906_0_.put(0, "No error");
            p_212906_0_.put(1280, "Enum parameter is invalid for this function");
            p_212906_0_.put(1281, "Parameter is invalid for this function");
            p_212906_0_.put(1282, "Current state is invalid for this function");
            p_212906_0_.put(1283, "Stack overflow");
            p_212906_0_.put(1284, "Stack underflow");
            p_212906_0_.put(1285, "Out of memory");
            p_212906_0_.put(1286, "Operation on incomplete framebuffer");
            p_212906_0_.put(1286, "Operation on incomplete framebuffer");
        });
        lastBrightnessX = 0.0f;
        lastBrightnessY = 0.0f;
    }
}

