/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.render.GlAlphaState;
import net.optifine.render.GlBlendState;
import net.optifine.shaders.Shaders;
import net.optifine.util.LockCounter;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.system.MemoryUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GlStateManager {
    private static final int LIGHT_COUNT = 8;
    private static final int TEXTURE_COUNT = 8;
    private static final FloatBuffer MATRIX_BUFFER = (FloatBuffer)GLX.make((Object)MemoryUtil.memAllocFloat((int)16), p_209238_0_ -> LWJGLMemoryUntracker.func_197933_a((long)MemoryUtil.memAddress((FloatBuffer)p_209238_0_)));
    private static final FloatBuffer COLOR_BUFFER = (FloatBuffer)GLX.make((Object)MemoryUtil.memAllocFloat((int)4), p_209236_0_ -> LWJGLMemoryUntracker.func_197933_a((long)MemoryUtil.memAddress((FloatBuffer)p_209236_0_)));
    private static final AlphaState ALPHA_TEST = new AlphaState(null);
    private static final BooleanState LIGHTING = new BooleanState(2896);
    private static final BooleanState[] LIGHT_ENABLE = (BooleanState[])IntStream.range(0, 8).mapToObj(p_199933_0_ -> new BooleanState(16384 + p_199933_0_)).toArray(BooleanState[]::new);
    private static final ColorMaterialState COLOR_MATERIAL = new ColorMaterialState(null);
    private static final BlendState BLEND = new BlendState(null);
    private static final DepthState DEPTH = new DepthState(null);
    private static final FogState FOG = new FogState(null);
    private static final CullState CULL = new CullState(null);
    private static final PolygonOffsetState POLY_OFFSET = new PolygonOffsetState(null);
    private static final ColorLogicState COLOR_LOGIC = new ColorLogicState(null);
    private static final TexGenState TEX_GEN = new TexGenState(null);
    private static final ClearState CLEAR = new ClearState(null);
    private static final StencilState STENCIL = new StencilState(null);
    private static final BooleanState NORMALIZE = new BooleanState(2977);
    private static int activeTexture;
    private static final TextureState[] TEXTURES;
    private static int shadeModel;
    private static final BooleanState RESCALE_NORMAL;
    private static final ColorMask COLOR_MASK;
    private static final Color COLOR;
    private static final float DEFAULTALPHACUTOFF = 0.1f;
    public static boolean clearEnabled;
    private static LockCounter alphaLock;
    private static GlAlphaState alphaLockState;
    private static LockCounter blendLock;
    private static GlBlendState blendLockState;

    public static void pushLightingAttributes() {
        GL11.glPushAttrib((int)8256);
    }

    public static void pushTextureAttributes() {
        GL11.glPushAttrib((int)270336);
    }

    public static void popAttributes() {
        GL11.glPopAttrib();
    }

    public static void disableAlphaTest() {
        if (alphaLock.isLocked()) {
            alphaLockState.setDisabled();
            return;
        }
        GlStateManager.ALPHA_TEST.field_179208_a.func_179198_a();
    }

    public static void enableAlphaTest() {
        if (alphaLock.isLocked()) {
            alphaLockState.setEnabled();
            return;
        }
        GlStateManager.ALPHA_TEST.field_179208_a.func_179200_b();
    }

    public static void alphaFunc(int func, float ref) {
        if (alphaLock.isLocked()) {
            alphaLockState.setFuncRef(func, ref);
            return;
        }
        if (func != GlStateManager.ALPHA_TEST.field_179206_b || ref != GlStateManager.ALPHA_TEST.field_179207_c) {
            GlStateManager.ALPHA_TEST.field_179206_b = func;
            GlStateManager.ALPHA_TEST.field_179207_c = ref;
            GL11.glAlphaFunc((int)func, (float)ref);
        }
    }

    public static void enableLighting() {
        LIGHTING.func_179200_b();
    }

    public static void disableLighting() {
        LIGHTING.func_179198_a();
    }

    public static void enableLight(int light) {
        LIGHT_ENABLE[light].func_179200_b();
    }

    public static void disableLight(int light) {
        LIGHT_ENABLE[light].func_179198_a();
    }

    public static void enableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.field_179191_a.func_179200_b();
    }

    public static void disableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.field_179191_a.func_179198_a();
    }

    public static void colorMaterial(int face, int mode) {
        if (face != GlStateManager.COLOR_MATERIAL.field_179189_b || mode != GlStateManager.COLOR_MATERIAL.field_179190_c) {
            GlStateManager.COLOR_MATERIAL.field_179189_b = face;
            GlStateManager.COLOR_MATERIAL.field_179190_c = mode;
            GL11.glColorMaterial((int)face, (int)mode);
        }
    }

    public static void light(int light, int pname, FloatBuffer params) {
        GL11.glLightfv((int)light, (int)pname, (FloatBuffer)params);
    }

    public static void lightModel(int pname, FloatBuffer params) {
        GL11.glLightModelfv((int)pname, (FloatBuffer)params);
    }

    public static void normal3f(float nx, float ny, float nz) {
        GL11.glNormal3f((float)nx, (float)ny, (float)nz);
    }

    public static void disableDepthTest() {
        GlStateManager.DEPTH.field_179052_a.func_179198_a();
    }

    public static void enableDepthTest() {
        GlStateManager.DEPTH.field_179052_a.func_179200_b();
    }

    public static void depthFunc(int depthFunc) {
        if (depthFunc != GlStateManager.DEPTH.field_179051_c) {
            GlStateManager.DEPTH.field_179051_c = depthFunc;
            GL11.glDepthFunc((int)depthFunc);
        }
    }

    public static void depthMask(boolean flagIn) {
        if (flagIn != GlStateManager.DEPTH.field_179050_b) {
            GlStateManager.DEPTH.field_179050_b = flagIn;
            GL11.glDepthMask((boolean)flagIn);
        }
    }

    public static void disableBlend() {
        if (blendLock.isLocked()) {
            blendLockState.setDisabled();
            return;
        }
        GlStateManager.BLEND.field_179213_a.func_179198_a();
    }

    public static void enableBlend() {
        if (blendLock.isLocked()) {
            blendLockState.setEnabled();
            return;
        }
        GlStateManager.BLEND.field_179213_a.func_179200_b();
    }

    public static void blendFunc(SourceFactor srcFactor, DestFactor dstFactor) {
        GlStateManager.blendFunc((int)srcFactor.value, (int)dstFactor.value);
    }

    public static void blendFunc(int srcFactor, int dstFactor) {
        if (blendLock.isLocked()) {
            blendLockState.setFactors(srcFactor, dstFactor);
            return;
        }
        if (srcFactor != GlStateManager.BLEND.field_179211_b || dstFactor != GlStateManager.BLEND.field_179212_c || srcFactor != GlStateManager.BLEND.field_179209_d || dstFactor != GlStateManager.BLEND.field_179210_e) {
            GlStateManager.BLEND.field_179211_b = srcFactor;
            GlStateManager.BLEND.field_179212_c = dstFactor;
            GlStateManager.BLEND.field_179209_d = srcFactor;
            GlStateManager.BLEND.field_179210_e = dstFactor;
            if (Config.isShaders()) {
                Shaders.uniform_blendFunc.setValue(srcFactor, dstFactor, srcFactor, dstFactor);
            }
            GL11.glBlendFunc((int)srcFactor, (int)dstFactor);
        }
    }

    public static void blendFuncSeparate(SourceFactor srcFactor, DestFactor dstFactor, SourceFactor srcFactorAlpha, DestFactor dstFactorAlpha) {
        GlStateManager.blendFuncSeparate((int)srcFactor.value, (int)dstFactor.value, (int)srcFactorAlpha.value, (int)dstFactorAlpha.value);
    }

    public static void blendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        if (blendLock.isLocked()) {
            blendLockState.setFactors(srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha);
            return;
        }
        if (srcFactor != GlStateManager.BLEND.field_179211_b || dstFactor != GlStateManager.BLEND.field_179212_c || srcFactorAlpha != GlStateManager.BLEND.field_179209_d || dstFactorAlpha != GlStateManager.BLEND.field_179210_e) {
            GlStateManager.BLEND.field_179211_b = srcFactor;
            GlStateManager.BLEND.field_179212_c = dstFactor;
            GlStateManager.BLEND.field_179209_d = srcFactorAlpha;
            GlStateManager.BLEND.field_179210_e = dstFactorAlpha;
            if (Config.isShaders()) {
                Shaders.uniform_blendFunc.setValue(srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha);
            }
            GLX.glBlendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }
    }

    public static void blendEquation(int blendEquation) {
        GL14.glBlendEquation((int)blendEquation);
    }

    public static void setupSolidRenderingTextureCombine(int color) {
        COLOR_BUFFER.put(0, (float)(color >> 16 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(1, (float)(color >> 8 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(2, (float)(color >> 0 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(3, (float)(color >> 24 & 0xFF) / 255.0f);
        GlStateManager.texEnv((int)8960, (int)8705, (FloatBuffer)COLOR_BUFFER);
        GlStateManager.texEnv((int)8960, (int)8704, (int)34160);
        GlStateManager.texEnv((int)8960, (int)34161, (int)7681);
        GlStateManager.texEnv((int)8960, (int)34176, (int)34166);
        GlStateManager.texEnv((int)8960, (int)34192, (int)768);
        GlStateManager.texEnv((int)8960, (int)34162, (int)7681);
        GlStateManager.texEnv((int)8960, (int)34184, (int)5890);
        GlStateManager.texEnv((int)8960, (int)34200, (int)770);
    }

    public static void tearDownSolidRenderingTextureCombine() {
        GlStateManager.texEnv((int)8960, (int)8704, (int)8448);
        GlStateManager.texEnv((int)8960, (int)34161, (int)8448);
        GlStateManager.texEnv((int)8960, (int)34162, (int)8448);
        GlStateManager.texEnv((int)8960, (int)34176, (int)5890);
        GlStateManager.texEnv((int)8960, (int)34184, (int)5890);
        GlStateManager.texEnv((int)8960, (int)34192, (int)768);
        GlStateManager.texEnv((int)8960, (int)34200, (int)770);
    }

    public static void enableFog() {
        GlStateManager.FOG.field_179049_a.func_179200_b();
    }

    public static void disableFog() {
        GlStateManager.FOG.field_179049_a.func_179198_a();
    }

    public static void fogMode(FogMode fogMode) {
        GlStateManager.fogMode((int)fogMode.field_187351_d);
    }

    private static void fogMode(int fogMode) {
        if (fogMode != GlStateManager.FOG.field_179047_b) {
            GlStateManager.FOG.field_179047_b = fogMode;
            GL11.glFogi((int)2917, (int)fogMode);
            if (Config.isShaders()) {
                Shaders.setFogMode(fogMode);
            }
        }
    }

    public static void fogDensity(float param) {
        if (param < 0.0f) {
            param = 0.0f;
        }
        if (param != GlStateManager.FOG.field_179048_c) {
            GlStateManager.FOG.field_179048_c = param;
            GL11.glFogf((int)2914, (float)param);
            if (Config.isShaders()) {
                Shaders.setFogDensity(param);
            }
        }
    }

    public static void fogStart(float param) {
        if (param != GlStateManager.FOG.field_179045_d) {
            GlStateManager.FOG.field_179045_d = param;
            GL11.glFogf((int)2915, (float)param);
        }
    }

    public static void fogEnd(float param) {
        if (param != GlStateManager.FOG.field_179046_e) {
            GlStateManager.FOG.field_179046_e = param;
            GL11.glFogf((int)2916, (float)param);
        }
    }

    public static void fog(int pname, FloatBuffer param) {
        GL11.glFogfv((int)pname, (FloatBuffer)param);
    }

    public static void fogi(int pname, int param) {
        GL11.glFogi((int)pname, (int)param);
    }

    public static void enableCull() {
        GlStateManager.CULL.field_179054_a.func_179200_b();
    }

    public static void disableCull() {
        GlStateManager.CULL.field_179054_a.func_179198_a();
    }

    public static void cullFace(CullFace cullFace) {
        GlStateManager.cullFace((int)cullFace.field_187328_d);
    }

    private static void cullFace(int cullFace) {
        if (cullFace != GlStateManager.CULL.field_179053_b) {
            GlStateManager.CULL.field_179053_b = cullFace;
            GL11.glCullFace((int)cullFace);
        }
    }

    public static void polygonMode(int face, int mode) {
        GL11.glPolygonMode((int)face, (int)mode);
    }

    public static void enablePolygonOffset() {
        GlStateManager.POLY_OFFSET.field_179044_a.func_179200_b();
    }

    public static void disablePolygonOffset() {
        GlStateManager.POLY_OFFSET.field_179044_a.func_179198_a();
    }

    public static void enableLineOffset() {
        GlStateManager.POLY_OFFSET.field_179042_b.func_179200_b();
    }

    public static void disableLineOffset() {
        GlStateManager.POLY_OFFSET.field_179042_b.func_179198_a();
    }

    public static void polygonOffset(float factor, float units) {
        if (factor != GlStateManager.POLY_OFFSET.field_179043_c || units != GlStateManager.POLY_OFFSET.field_179041_d) {
            GlStateManager.POLY_OFFSET.field_179043_c = factor;
            GlStateManager.POLY_OFFSET.field_179041_d = units;
            GL11.glPolygonOffset((float)factor, (float)units);
        }
    }

    public static void enableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.field_179197_a.func_179200_b();
    }

    public static void disableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.field_179197_a.func_179198_a();
    }

    public static void logicOp(LogicOp logicOperation) {
        GlStateManager.logicOp((int)logicOperation.field_187370_q);
    }

    public static void logicOp(int logicOperation) {
        if (logicOperation != GlStateManager.COLOR_LOGIC.field_179196_b) {
            GlStateManager.COLOR_LOGIC.field_179196_b = logicOperation;
            GL11.glLogicOp((int)logicOperation);
        }
    }

    public static void enableTexGen(TexGen texGen) {
        GlStateManager.getTexGen((TexGen)texGen).field_179067_a.func_179200_b();
    }

    public static void disableTexGen(TexGen texGen) {
        GlStateManager.getTexGen((TexGen)texGen).field_179067_a.func_179198_a();
    }

    public static void texGenMode(TexGen texGen, int mode) {
        TexGenCoord glstatemanager$texgencoord = GlStateManager.getTexGen((TexGen)texGen);
        if (mode != glstatemanager$texgencoord.field_179066_c) {
            glstatemanager$texgencoord.field_179066_c = mode;
            GL11.glTexGeni((int)glstatemanager$texgencoord.field_179065_b, (int)9472, (int)mode);
        }
    }

    public static void texGenParam(TexGen texGen, int pname, FloatBuffer params) {
        GL11.glTexGenfv((int)GlStateManager.getTexGen((TexGen)texGen).field_179065_b, (int)pname, (FloatBuffer)params);
    }

    private static TexGenCoord getTexGen(TexGen texGen) {
        switch (1.$SwitchMap$com$mojang$blaze3d$platform$GlStateManager$TexGen[texGen.ordinal()]) {
            case 1: {
                return GlStateManager.TEX_GEN.field_179064_a;
            }
            case 2: {
                return GlStateManager.TEX_GEN.field_179062_b;
            }
            case 3: {
                return GlStateManager.TEX_GEN.field_179063_c;
            }
            case 4: {
                return GlStateManager.TEX_GEN.field_179061_d;
            }
        }
        return GlStateManager.TEX_GEN.field_179064_a;
    }

    public static void activeTexture(int texture) {
        if (activeTexture != texture - GLX.GL_TEXTURE0) {
            activeTexture = texture - GLX.GL_TEXTURE0;
            GLX.glActiveTexture((int)texture);
        }
    }

    public static void enableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179060_a.func_179200_b();
    }

    public static void disableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179060_a.func_179198_a();
    }

    public static void texEnv(int target, int parameterName, FloatBuffer parameters) {
        GL11.glTexEnvfv((int)target, (int)parameterName, (FloatBuffer)parameters);
    }

    public static void texEnv(int target, int parameterName, int parameters) {
        GL11.glTexEnvi((int)target, (int)parameterName, (int)parameters);
    }

    public static void texEnv(int target, int parameterName, float parameters) {
        GL11.glTexEnvf((int)target, (int)parameterName, (float)parameters);
    }

    public static void texParameter(int target, int parameterName, float parameter) {
        GL11.glTexParameterf((int)target, (int)parameterName, (float)parameter);
    }

    public static void texParameter(int target, int parameterName, int parameter) {
        GL11.glTexParameteri((int)target, (int)parameterName, (int)parameter);
    }

    public static int getTexLevelParameter(int target, int level, int parameterName) {
        return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)parameterName);
    }

    public static int genTexture() {
        return GL11.glGenTextures();
    }

    public static void deleteTexture(int texture) {
        if (texture == 0) {
            return;
        }
        GL11.glDeleteTextures((int)texture);
        for (TextureState glstatemanager$texturestate : TEXTURES) {
            if (glstatemanager$texturestate.field_179059_b != texture) continue;
            glstatemanager$texturestate.field_179059_b = 0;
        }
    }

    public static void bindTexture(int texture) {
        if (texture != GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179059_b) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179059_b = texture;
            GL11.glBindTexture((int)3553, (int)texture);
            if (SmartAnimations.isActive()) {
                SmartAnimations.textureRendered(texture);
            }
        }
    }

    public static void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, @Nullable IntBuffer pixels) {
        GL11.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, long pixels) {
        GL11.glTexSubImage2D((int)target, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static void copyTexSubImage2D(int target, int level, int xOffset, int yOffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D((int)target, (int)level, (int)xOffset, (int)yOffset, (int)x, (int)y, (int)width, (int)height);
    }

    public static void getTexImage(int tex, int level, int format, int type, long pixels) {
        GL11.glGetTexImage((int)tex, (int)level, (int)format, (int)type, (long)pixels);
    }

    public static void enableNormalize() {
        NORMALIZE.func_179200_b();
    }

    public static void disableNormalize() {
        NORMALIZE.func_179198_a();
    }

    public static void shadeModel(int mode) {
        if (mode != shadeModel) {
            shadeModel = mode;
            GL11.glShadeModel((int)mode);
        }
    }

    public static void enableRescaleNormal() {
        RESCALE_NORMAL.func_179200_b();
    }

    public static void disableRescaleNormal() {
        RESCALE_NORMAL.func_179198_a();
    }

    public static void viewport(int x, int y, int width, int height) {
        Viewport.INSTANCE.field_199289_b = x;
        Viewport.INSTANCE.field_199290_c = y;
        Viewport.INSTANCE.field_199291_d = width;
        Viewport.INSTANCE.field_199292_e = height;
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        if (red != GlStateManager.COLOR_MASK.field_179188_a || green != GlStateManager.COLOR_MASK.field_179186_b || blue != GlStateManager.COLOR_MASK.field_179187_c || alpha != GlStateManager.COLOR_MASK.field_179185_d) {
            GlStateManager.COLOR_MASK.field_179188_a = red;
            GlStateManager.COLOR_MASK.field_179186_b = green;
            GlStateManager.COLOR_MASK.field_179187_c = blue;
            GlStateManager.COLOR_MASK.field_179185_d = alpha;
            GL11.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
        }
    }

    public static void stencilFunc(int func, int ref, int mask) {
        if (func != GlStateManager.STENCIL.field_179078_a.field_179081_a || func != GlStateManager.STENCIL.field_179078_a.field_212902_b || func != GlStateManager.STENCIL.field_179078_a.field_179080_c) {
            GlStateManager.STENCIL.field_179078_a.field_179081_a = func;
            GlStateManager.STENCIL.field_179078_a.field_212902_b = ref;
            GlStateManager.STENCIL.field_179078_a.field_179080_c = mask;
            GL11.glStencilFunc((int)func, (int)ref, (int)mask);
        }
    }

    public static void stencilMask(int mask) {
        if (mask != GlStateManager.STENCIL.field_179076_b) {
            GlStateManager.STENCIL.field_179076_b = mask;
            GL11.glStencilMask((int)mask);
        }
    }

    public static void stencilOp(int sfail, int dpfail, int dppass) {
        if (sfail != GlStateManager.STENCIL.field_179077_c || dpfail != GlStateManager.STENCIL.field_179074_d || dppass != GlStateManager.STENCIL.field_179075_e) {
            GlStateManager.STENCIL.field_179077_c = sfail;
            GlStateManager.STENCIL.field_179074_d = dpfail;
            GlStateManager.STENCIL.field_179075_e = dppass;
            GL11.glStencilOp((int)sfail, (int)dpfail, (int)dppass);
        }
    }

    public static void clearDepth(double depth) {
        if (depth != GlStateManager.CLEAR.field_179205_a) {
            GlStateManager.CLEAR.field_179205_a = depth;
            GL11.glClearDepth((double)depth);
        }
    }

    public static void clearColor(float red, float green, float blue, float alpha) {
        if (red != GlStateManager.CLEAR.field_179203_b.field_179195_a || green != GlStateManager.CLEAR.field_179203_b.field_179193_b || blue != GlStateManager.CLEAR.field_179203_b.field_179194_c || alpha != GlStateManager.CLEAR.field_179203_b.field_179192_d) {
            GlStateManager.CLEAR.field_179203_b.field_179195_a = red;
            GlStateManager.CLEAR.field_179203_b.field_179193_b = green;
            GlStateManager.CLEAR.field_179203_b.field_179194_c = blue;
            GlStateManager.CLEAR.field_179203_b.field_179192_d = alpha;
            GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static void clearStencil(int s) {
        if (s != GlStateManager.CLEAR.field_212901_c) {
            GlStateManager.CLEAR.field_212901_c = s;
            GL11.glClearStencil((int)s);
        }
    }

    public static void clear(int mask, boolean checkError) {
        if (!clearEnabled) {
            return;
        }
        GL11.glClear((int)mask);
        if (checkError) {
            GlStateManager.getError();
        }
    }

    public static void matrixMode(int mode) {
        GL11.glMatrixMode((int)mode);
    }

    public static void loadIdentity() {
        GL11.glLoadIdentity();
    }

    public static void pushMatrix() {
        GL11.glPushMatrix();
    }

    public static void popMatrix() {
        GL11.glPopMatrix();
    }

    public static void getMatrix(int pname, FloatBuffer params) {
        GL11.glGetFloatv((int)pname, (FloatBuffer)params);
    }

    public static Matrix4f getMatrix4f(int pname) {
        GL11.glGetFloatv((int)pname, (FloatBuffer)MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_195874_a(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        return matrix4f;
    }

    public static void ortho(double left, double right, double bottom, double top, double zNear, double zFar) {
        GL11.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar);
    }

    public static void rotatef(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void rotated(double angle, double y, double p_rotated_4_, double p_rotated_6_) {
        GL11.glRotated((double)angle, (double)y, (double)p_rotated_4_, (double)p_rotated_6_);
    }

    public static void scalef(float x, float y, float z) {
        GL11.glScalef((float)x, (float)y, (float)z);
    }

    public static void scaled(double x, double z, double p_scaled_4_) {
        GL11.glScaled((double)x, (double)z, (double)p_scaled_4_);
    }

    public static void translatef(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    public static void translated(double x, double z, double p_translated_4_) {
        GL11.glTranslated((double)x, (double)z, (double)p_translated_4_);
    }

    public static void multMatrix(FloatBuffer matrix) {
        GL11.glMultMatrixf((FloatBuffer)matrix);
    }

    public static void multMatrix(Matrix4f matrix) {
        matrix.func_195879_b(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        GL11.glMultMatrixf((FloatBuffer)MATRIX_BUFFER);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
        if (red != GlStateManager.COLOR.field_179195_a || green != GlStateManager.COLOR.field_179193_b || blue != GlStateManager.COLOR.field_179194_c || alpha != GlStateManager.COLOR.field_179192_d) {
            GlStateManager.COLOR.field_179195_a = red;
            GlStateManager.COLOR.field_179193_b = green;
            GlStateManager.COLOR.field_179194_c = blue;
            GlStateManager.COLOR.field_179192_d = alpha;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static void color3f(float red, float green, float blue) {
        GlStateManager.color4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void texCoord2f(float s, float t) {
        GL11.glTexCoord2f((float)s, (float)t);
    }

    public static void vertex3f(float x, float y, float z) {
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void clearCurrentColor() {
        GlStateManager.COLOR.field_179195_a = -1.0f;
        GlStateManager.COLOR.field_179193_b = -1.0f;
        GlStateManager.COLOR.field_179194_c = -1.0f;
        GlStateManager.COLOR.field_179192_d = -1.0f;
    }

    public static void normalPointer(int type, int stride, int pointer) {
        GL11.glNormalPointer((int)type, (int)stride, (long)pointer);
    }

    public static void normalPointer(int type, int stride, ByteBuffer pointer) {
        GL11.glNormalPointer((int)type, (int)stride, (ByteBuffer)pointer);
    }

    public static void texCoordPointer(int p_texCoordPointer_0_, int p_texCoordPointer_1_, int p_texCoordPointer_2_, int p_texCoordPointer_3_) {
        GL11.glTexCoordPointer((int)p_texCoordPointer_0_, (int)p_texCoordPointer_1_, (int)p_texCoordPointer_2_, (long)p_texCoordPointer_3_);
    }

    public static void texCoordPointer(int p_texCoordPointer_0_, int p_texCoordPointer_1_, int p_texCoordPointer_2_, ByteBuffer p_texCoordPointer_3_) {
        GL11.glTexCoordPointer((int)p_texCoordPointer_0_, (int)p_texCoordPointer_1_, (int)p_texCoordPointer_2_, (ByteBuffer)p_texCoordPointer_3_);
    }

    public static void vertexPointer(int p_vertexPointer_0_, int p_vertexPointer_1_, int p_vertexPointer_2_, int p_vertexPointer_3_) {
        GL11.glVertexPointer((int)p_vertexPointer_0_, (int)p_vertexPointer_1_, (int)p_vertexPointer_2_, (long)p_vertexPointer_3_);
    }

    public static void vertexPointer(int p_vertexPointer_0_, int p_vertexPointer_1_, int p_vertexPointer_2_, ByteBuffer p_vertexPointer_3_) {
        GL11.glVertexPointer((int)p_vertexPointer_0_, (int)p_vertexPointer_1_, (int)p_vertexPointer_2_, (ByteBuffer)p_vertexPointer_3_);
    }

    public static void colorPointer(int p_colorPointer_0_, int p_colorPointer_1_, int p_colorPointer_2_, int p_colorPointer_3_) {
        GL11.glColorPointer((int)p_colorPointer_0_, (int)p_colorPointer_1_, (int)p_colorPointer_2_, (long)p_colorPointer_3_);
    }

    public static void colorPointer(int p_colorPointer_0_, int p_colorPointer_1_, int p_colorPointer_2_, ByteBuffer p_colorPointer_3_) {
        GL11.glColorPointer((int)p_colorPointer_0_, (int)p_colorPointer_1_, (int)p_colorPointer_2_, (ByteBuffer)p_colorPointer_3_);
    }

    public static void disableClientState(int cap) {
        GL11.glDisableClientState((int)cap);
    }

    public static void enableClientState(int cap) {
        GL11.glEnableClientState((int)cap);
    }

    public static void begin(int mode) {
        GL11.glBegin((int)mode);
    }

    public static void end() {
        GL11.glEnd();
    }

    public static void drawArrays(int mode, int first, int count) {
        GL11.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public static void lineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public static void callList(int list) {
        GL11.glCallList((int)list);
    }

    public static void deleteLists(int list, int range) {
        GL11.glDeleteLists((int)list, (int)range);
    }

    public static void newList(int list, int mode) {
        GL11.glNewList((int)list, (int)mode);
    }

    public static void endList() {
        GL11.glEndList();
    }

    public static int genLists(int range) {
        return GL11.glGenLists((int)range);
    }

    public static void pixelStore(int pname, int param) {
        GL11.glPixelStorei((int)pname, (int)param);
    }

    public static void pixelTransfer(int param, float value) {
        GL11.glPixelTransferf((int)param, (float)value);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public static int getError() {
        return GL11.glGetError();
    }

    public static String getString(int name) {
        return GL11.glGetString((int)name);
    }

    public static void getInteger(int pname, IntBuffer params) {
        GL11.glGetIntegerv((int)pname, (IntBuffer)params);
    }

    public static int getInteger(int pname) {
        return GL11.glGetInteger((int)pname);
    }

    public static void setProfile(Profile profile) {
        profile.func_187373_a();
    }

    public static void unsetProfile(Profile profile) {
        profile.func_187374_b();
    }

    public static int getActiveTextureUnit() {
        return GLX.GL_TEXTURE0 + activeTexture;
    }

    public static void bindCurrentTexture() {
        GL11.glBindTexture((int)3553, (int)GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179059_b);
    }

    public static int getBoundTexture() {
        return GlStateManager.TEXTURES[GlStateManager.activeTexture].field_179059_b;
    }

    public static void checkBoundTexture() {
        if (!Config.isMinecraftThread()) {
            return;
        }
        int glAct = GL11.glGetInteger((int)34016);
        int glTex = GL11.glGetInteger((int)32873);
        int act = GlStateManager.getActiveTextureUnit();
        int tex = GlStateManager.getBoundTexture();
        if (tex <= 0) {
            return;
        }
        if (glAct != act || glTex != tex) {
            Config.dbg("checkTexture: act: " + act + ", glAct: " + glAct + ", tex: " + tex + ", glTex: " + glTex);
        }
    }

    public static void deleteTextures(IntBuffer buf) {
        buf.rewind();
        while (buf.position() < buf.limit()) {
            int texId = buf.get();
            GlStateManager.deleteTexture((int)texId);
        }
        buf.rewind();
    }

    public static boolean isFogEnabled() {
        return BooleanState.access$1200((BooleanState)GlStateManager.FOG.field_179049_a);
    }

    public static void setFogEnabled(boolean state) {
        GlStateManager.FOG.field_179049_a.func_179199_a(state);
    }

    public static void lockAlpha(GlAlphaState stateNew) {
        if (alphaLock.isLocked()) {
            return;
        }
        GlStateManager.getAlphaState((GlAlphaState)alphaLockState);
        GlStateManager.setAlphaState((GlAlphaState)stateNew);
        alphaLock.lock();
    }

    public static void unlockAlpha() {
        if (!alphaLock.unlock()) {
            return;
        }
        GlStateManager.setAlphaState((GlAlphaState)alphaLockState);
    }

    public static void getAlphaState(GlAlphaState state) {
        if (alphaLock.isLocked()) {
            state.setState(alphaLockState);
            return;
        }
        state.setState(BooleanState.access$1200((BooleanState)GlStateManager.ALPHA_TEST.field_179208_a), GlStateManager.ALPHA_TEST.field_179206_b, GlStateManager.ALPHA_TEST.field_179207_c);
    }

    public static void setAlphaState(GlAlphaState state) {
        if (alphaLock.isLocked()) {
            alphaLockState.setState(state);
            return;
        }
        GlStateManager.ALPHA_TEST.field_179208_a.func_179199_a(state.isEnabled());
        GlStateManager.alphaFunc((int)state.getFunc(), (float)state.getRef());
    }

    public static void lockBlend(GlBlendState stateNew) {
        if (blendLock.isLocked()) {
            return;
        }
        GlStateManager.getBlendState((GlBlendState)blendLockState);
        GlStateManager.setBlendState((GlBlendState)stateNew);
        blendLock.lock();
    }

    public static void unlockBlend() {
        if (!blendLock.unlock()) {
            return;
        }
        GlStateManager.setBlendState((GlBlendState)blendLockState);
    }

    public static void getBlendState(GlBlendState gbs) {
        if (blendLock.isLocked()) {
            gbs.setState(blendLockState);
            return;
        }
        gbs.setState(BooleanState.access$1200((BooleanState)GlStateManager.BLEND.field_179213_a), GlStateManager.BLEND.field_179211_b, GlStateManager.BLEND.field_179212_c, GlStateManager.BLEND.field_179209_d, GlStateManager.BLEND.field_179210_e);
    }

    public static void setBlendState(GlBlendState gbs) {
        if (blendLock.isLocked()) {
            blendLockState.setState(gbs);
            return;
        }
        GlStateManager.BLEND.field_179213_a.func_179199_a(gbs.isEnabled());
        if (!gbs.isSeparate()) {
            GlStateManager.blendFunc((int)gbs.getSrcFactor(), (int)gbs.getDstFactor());
        } else {
            GlStateManager.blendFuncSeparate((int)gbs.getSrcFactor(), (int)gbs.getDstFactor(), (int)gbs.getSrcFactorAlpha(), (int)gbs.getDstFactorAlpha());
        }
    }

    public static void glMultiDrawArrays(int mode, IntBuffer bFirst, IntBuffer bCount) {
        GL14.glMultiDrawArrays((int)mode, (IntBuffer)bFirst, (IntBuffer)bCount);
    }

    public static void clear(int mask) {
        GlStateManager.clear((int)mask, (boolean)false);
    }

    public static void callLists(IntBuffer lists) {
        GL11.glCallLists((IntBuffer)lists);
    }

    static {
        TEXTURES = (TextureState[])IntStream.range(0, 32).mapToObj(p_199931_0_ -> new TextureState(null)).toArray(TextureState[]::new);
        shadeModel = 7425;
        RESCALE_NORMAL = new BooleanState(32826);
        COLOR_MASK = new ColorMask(null);
        COLOR = new Color();
        clearEnabled = true;
        alphaLock = new LockCounter();
        alphaLockState = new GlAlphaState();
        blendLock = new LockCounter();
        blendLockState = new GlBlendState();
    }
}

