/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.model.BlockModelCustomizer;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.render.RenderEnv;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.util.BlockUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Cache> field_210267_b = ThreadLocal.withInitial(() -> new Cache(null));
    private static float aoLightValueOpaque = 0.2f;
    private static boolean separateAoLightValue = false;
    private static final BlockRenderLayer[] OVERLAY_LAYERS = new BlockRenderLayer[]{BlockRenderLayer.CUTOUT, BlockRenderLayer.CUTOUT_MIPPED, BlockRenderLayer.TRANSLUCENT};

    public BlockModelRenderer(BlockColors blockColorsIn) {
        this.field_187499_a = blockColorsIn;
        if (Reflector.ForgeMod_forgeLightPipelineEnabled.exists()) {
            Reflector.setFieldValue(Reflector.ForgeMod_forgeLightPipelineEnabled, false);
        }
    }

    public boolean func_217631_a(IEnviromentBlockReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand) {
        boolean flag = Minecraft.func_71379_u() && ReflectorForge.getLightValue((BlockState)stateIn, (IEnviromentBlockReader)worldIn, (BlockPos)posIn) == 0 && ReflectorForge.isAmbientOcclusion((IBakedModel)modelIn, (BlockState)stateIn);
        try {
            boolean rendered;
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity((BlockState)stateIn, (BlockPos)posIn, (IEnviromentBlockReader)worldIn, (BufferBuilder)buffer);
            }
            if (!Config.isAlternateBlocks()) {
                rand = 0L;
            }
            RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
            modelIn = BlockModelCustomizer.getRenderModel((IBakedModel)modelIn, (BlockState)stateIn, (RenderEnv)renderEnv);
            boolean bl = rendered = flag ? this.func_217634_b(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand) : this.func_217635_c(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand);
            if (rendered) {
                this.renderOverlayModels(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand, renderEnv, flag);
            }
            if (Config.isShaders()) {
                SVertexBuilder.popEntity((BufferBuilder)buffer);
            }
            return rendered;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)posIn, (BlockState)stateIn);
            crashreportcategory.func_71507_a("Using AO", (Object)flag);
            throw new ReportedException(crashreport);
        }
    }

    public boolean func_217634_b(IEnviromentBlockReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand) {
        boolean flag = false;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        BlockRenderLayer layer = buffer.getBlockLayer();
        for (Direction direction : Direction.field_199792_n) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (IBlockReader)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.setSeed(rand);
            List list = modelIn.func_200117_a(stateIn, direction, randomIn);
            list = BlockModelCustomizer.getRenderQuads((List)list, (IEnviromentBlockReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (BlockRenderLayer)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list, renderEnv);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.func_200117_a(stateIn, (Direction)null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (IEnviromentBlockReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (BlockRenderLayer)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list1, renderEnv);
            flag = true;
        }
        return flag;
    }

    public boolean func_217635_c(IEnviromentBlockReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand) {
        boolean flag = false;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        BlockRenderLayer layer = buffer.getBlockLayer();
        for (Direction direction : Direction.field_199792_n) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (IBlockReader)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.setSeed(rand);
            List list = modelIn.func_200117_a(stateIn, direction, randomIn);
            int i = stateIn.func_215684_a(worldIn, posIn.func_177972_a(direction));
            list = BlockModelCustomizer.getRenderQuads((List)list, (IEnviromentBlockReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (BlockRenderLayer)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsFlat(worldIn, stateIn, posIn, i, false, buffer, list, renderEnv);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.func_200117_a(stateIn, (Direction)null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (IEnviromentBlockReader)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (BlockRenderLayer)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, true, buffer, list1, renderEnv);
            flag = true;
        }
        return flag;
    }

    private void renderQuadsSmooth(IEnviromentBlockReader blockAccessIn, BlockState stateIn, BlockPos posIn, BufferBuilder buffer, List<BakedQuad> list, RenderEnv renderEnv) {
        float[] quadBounds = renderEnv.getQuadBounds();
        BitSet bitSet = renderEnv.getBoundsFlags();
        AmbientOcclusionFace aoFace = renderEnv.getAoFace();
        Vec3d vec3d = stateIn.func_191059_e((IBlockReader)blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            this.func_217633_a(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, bitSet);
            aoFace.func_217629_a(blockAccessIn, stateIn, posIn, bakedquad.func_178210_d(), quadBounds, bitSet);
            if (bakedquad.func_187508_a().isSpriteEmissive) {
                aoFace.setMaxBlockLight();
            }
            if (buffer.isMultiTexture()) {
                buffer.func_178981_a(bakedquad.getVertexDataSingle());
            } else {
                buffer.func_178981_a(bakedquad.func_178209_a());
            }
            buffer.putSprite(bakedquad.func_187508_a());
            buffer.func_178962_a(AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[0], AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[1], AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[2], AmbientOcclusionFace.access$000((AmbientOcclusionFace)aoFace)[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = FaceBakery.func_178412_b((Direction)bakedquad.func_178210_d());
                float[] fArray = AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace);
                fArray[0] = fArray[0] * diffuse;
                float[] fArray2 = AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace);
                fArray2[1] = fArray2[1] * diffuse;
                float[] fArray3 = AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace);
                fArray3[2] = fArray3[2] * diffuse;
                float[] fArray4 = AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace);
                fArray4[3] = fArray4[3] * diffuse;
            }
            int colorMultiplier = CustomColors.getColorMultiplier((BakedQuad)bakedquad, (BlockState)stateIn, (IEnviromentBlockReader)blockAccessIn, (BlockPos)posIn, (RenderEnv)renderEnv);
            if (bakedquad.func_178212_b() || colorMultiplier != -1) {
                int k = colorMultiplier;
                if (colorMultiplier == -1) {
                    k = this.field_187499_a.func_216860_a(stateIn, blockAccessIn, posIn, bakedquad.func_178211_c());
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (separateAoLightValue) {
                    buffer.putColorMultiplierRgba(f, f1, f2, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0], 4);
                    buffer.putColorMultiplierRgba(f, f1, f2, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1], 3);
                    buffer.putColorMultiplierRgba(f, f1, f2, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2], 2);
                    buffer.putColorMultiplierRgba(f, f1, f2, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3], 1);
                } else {
                    buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0] * f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0] * f1, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0] * f2, 4);
                    buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1] * f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1] * f1, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1] * f2, 3);
                    buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2] * f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2] * f1, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2] * f2, 2);
                    buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3] * f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3] * f1, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3] * f2, 1);
                }
            } else if (separateAoLightValue) {
                buffer.putColorMultiplierRgba(1.0f, 1.0f, 1.0f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0], 4);
                buffer.putColorMultiplierRgba(1.0f, 1.0f, 1.0f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1], 3);
                buffer.putColorMultiplierRgba(1.0f, 1.0f, 1.0f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2], 2);
                buffer.putColorMultiplierRgba(1.0f, 1.0f, 1.0f, AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3], 1);
            } else {
                buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[0], 4);
                buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[1], 3);
                buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[2], 2);
                buffer.func_178978_a(AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3], AmbientOcclusionFace.access$100((AmbientOcclusionFace)aoFace)[3], 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    private void func_217633_a(IEnviromentBlockReader blockReaderIn, BlockState stateIn, BlockPos posIn, int[] vertexData, Direction face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * step]);
            float f7 = Float.intBitsToFloat(vertexData[i * step + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * step + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[Direction.WEST.func_176745_a()] = f;
            quadBounds[Direction.EAST.func_176745_a()] = f3;
            quadBounds[Direction.DOWN.func_176745_a()] = f1;
            quadBounds[Direction.UP.func_176745_a()] = f4;
            quadBounds[Direction.NORTH.func_176745_a()] = f2;
            quadBounds[Direction.SOUTH.func_176745_a()] = f5;
            int j = Direction.field_199792_n.length;
            quadBounds[Direction.WEST.func_176745_a() + j] = 1.0f - f;
            quadBounds[Direction.EAST.func_176745_a() + j] = 1.0f - f3;
            quadBounds[Direction.DOWN.func_176745_a() + j] = 1.0f - f1;
            quadBounds[Direction.UP.func_176745_a() + j] = 1.0f - f4;
            quadBounds[Direction.NORTH.func_176745_a() + j] = 1.0f - f2;
            quadBounds[Direction.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (1.$SwitchMap$net$minecraft$util$Direction[face.ordinal()]) {
            case 1: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || Block.func_208062_a((VoxelShape)stateIn.func_196952_d((IBlockReader)blockReaderIn, posIn))) && f1 == f4);
                break;
            }
            case 2: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || Block.func_208062_a((VoxelShape)stateIn.func_196952_d((IBlockReader)blockReaderIn, posIn))) && f1 == f4);
                break;
            }
            case 3: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || Block.func_208062_a((VoxelShape)stateIn.func_196952_d((IBlockReader)blockReaderIn, posIn))) && f2 == f5);
                break;
            }
            case 4: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || Block.func_208062_a((VoxelShape)stateIn.func_196952_d((IBlockReader)blockReaderIn, posIn))) && f2 == f5);
                break;
            }
            case 5: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || Block.func_208062_a((VoxelShape)stateIn.func_196952_d((IBlockReader)blockReaderIn, posIn))) && f == f3);
                break;
            }
            case 6: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || Block.func_208062_a((VoxelShape)stateIn.func_196952_d((IBlockReader)blockReaderIn, posIn))) && f == f3);
            }
        }
    }

    private void renderQuadsFlat(IEnviromentBlockReader blockAccessIn, BlockState stateIn, BlockPos posIn, int brightnessIn, boolean ownBrightness, BufferBuilder buffer, List<BakedQuad> list, RenderEnv renderEnv) {
        BitSet bitSet = renderEnv.getBoundsFlags();
        Vec3d vec3d = stateIn.func_191059_e((IBlockReader)blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            if (ownBrightness) {
                this.func_217633_a(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), (float[])null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = stateIn.func_215684_a(blockAccessIn, blockpos);
            }
            if (bakedquad.func_187508_a().isSpriteEmissive) {
                brightnessIn |= 0xF0;
            }
            if (buffer.isMultiTexture()) {
                buffer.func_178981_a(bakedquad.getVertexDataSingle());
            } else {
                buffer.func_178981_a(bakedquad.func_178209_a());
            }
            buffer.putSprite(bakedquad.func_187508_a());
            buffer.func_178962_a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            int colorMultiplier = CustomColors.getColorMultiplier((BakedQuad)bakedquad, (BlockState)stateIn, (IEnviromentBlockReader)blockAccessIn, (BlockPos)posIn, (RenderEnv)renderEnv);
            if (bakedquad.func_178212_b() || colorMultiplier != -1) {
                int k = colorMultiplier;
                if (colorMultiplier == -1) {
                    k = this.field_187499_a.func_216860_a(stateIn, blockAccessIn, posIn, bakedquad.func_178211_c());
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = FaceBakery.func_178412_b((Direction)bakedquad.func_178210_d());
                    f *= diffuse;
                    f1 *= diffuse;
                    f2 *= diffuse;
                }
                buffer.func_178978_a(f, f1, f2, 4);
                buffer.func_178978_a(f, f1, f2, 3);
                buffer.func_178978_a(f, f1, f2, 2);
                buffer.func_178978_a(f, f1, f2, 1);
            } else if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = FaceBakery.func_178412_b((Direction)bakedquad.func_178210_d());
                buffer.func_178978_a(diffuse, diffuse, diffuse, 4);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 3);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 2);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    public void func_178262_a(IBakedModel bakedModel, float brightness, float red, float green, float blue) {
        this.func_187495_a((BlockState)null, bakedModel, brightness, red, green, blue);
    }

    public void func_187495_a(@Nullable BlockState state, IBakedModel modelIn, float brightness, float red, float green, float blue) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.field_199792_n) {
            random.setSeed(42L);
            this.func_178264_a(brightness, red, green, blue, modelIn.func_200117_a(state, direction, random));
        }
        random.setSeed(42L);
        this.func_178264_a(brightness, red, green, blue, modelIn.func_200117_a(state, (Direction)null, random));
    }

    public void func_178266_a(IBakedModel model, BlockState state, float brightness, boolean glDisabled) {
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = this.field_187499_a.func_216860_a(state, (IEnviromentBlockReader)null, (BlockPos)null, 0);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (!glDisabled) {
            GlStateManager.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        this.func_187495_a(state, model, brightness, f, f1, f2);
    }

    private void func_178264_a(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                bufferbuilder.func_178990_f(red * brightness, green * brightness, blue * brightness);
            } else {
                bufferbuilder.func_178990_f(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static void func_211847_a() {
        ((Cache)field_210267_b.get()).func_222895_a();
    }

    public static void func_210266_a() {
        ((Cache)field_210267_b.get()).func_222897_b();
    }

    public static float fixAoLightValue(float val) {
        if (val == 0.2f) {
            return aoLightValueOpaque;
        }
        return val;
    }

    public static void updateAoLightValue() {
        aoLightValueOpaque = 1.0f - Config.getAmbientOcclusionLevel() * 0.8f;
        separateAoLightValue = Config.isShaders() && Shaders.isSeparateAo();
    }

    private void renderOverlayModels(IEnviromentBlockReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random random, long rand, RenderEnv renderEnv, boolean smooth) {
        if (renderEnv.isOverlaysRendered()) {
            for (int l2 = 0; l2 < OVERLAY_LAYERS.length; ++l2) {
                BlockRenderLayer layer = OVERLAY_LAYERS[l2];
                ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(layer);
                if (listQuadsOverlay.size() <= 0) continue;
                RegionRenderCacheBuilder rrcb = renderEnv.getRegionRenderCacheBuilder();
                if (rrcb != null) {
                    BufferBuilder overlayBuffer = rrcb.func_179038_a(layer);
                    if (!overlayBuffer.isDrawing()) {
                        overlayBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        overlayBuffer.func_178969_c(buffer.getXOffset(), buffer.getYOffset(), buffer.getZOffset());
                    }
                    for (int q = 0; q < listQuadsOverlay.size(); ++q) {
                        BakedQuad quad = listQuadsOverlay.getQuad(q);
                        List listQuadSingle = listQuadsOverlay.getListQuadsSingle(quad);
                        BlockState quadBlockState = listQuadsOverlay.getBlockState(q);
                        if (quad.getQuadEmissive() != null) {
                            listQuadsOverlay.addQuad(quad.getQuadEmissive(), quadBlockState);
                        }
                        renderEnv.reset(quadBlockState, posIn);
                        if (smooth) {
                            this.renderQuadsSmooth(worldIn, quadBlockState, posIn, overlayBuffer, listQuadSingle, renderEnv);
                            continue;
                        }
                        int col = quadBlockState.func_215684_a(worldIn, posIn.func_177972_a(quad.func_178210_d()));
                        this.renderQuadsFlat(worldIn, quadBlockState, posIn, col, false, overlayBuffer, listQuadSingle, renderEnv);
                    }
                }
                listQuadsOverlay.clear();
            }
        }
        if (Config.isBetterSnow() && !renderEnv.isBreakingAnimation() && BetterSnow.shouldRender((IEnviromentBlockReader)worldIn, (BlockState)stateIn, (BlockPos)posIn)) {
            IBakedModel modelSnow = BetterSnow.getModelSnowLayer();
            BlockState stateSnow = BetterSnow.getStateSnowLayer();
            this.func_217631_a(worldIn, modelSnow, stateSnow, posIn, buffer, checkSides, random, rand);
        }
    }
}

