/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.ResourceLoadProgressGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DownloadTerrainScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.SimpleResource;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.Lagometer;
import net.optifine.RandomEntities;
import net.optifine.gui.GuiChatOF;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class GameRenderer
implements AutoCloseable,
IResourceManagerReloadListener {
    private static final Logger field_147710_q = LogManager.getLogger();
    private static final ResourceLocation field_110924_q = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation field_110923_r = new ResourceLocation("textures/environment/snow.png");
    private final Minecraft field_78531_r;
    private final IResourceManager field_147711_ac;
    private final Random field_78537_ab = new Random();
    private float field_78530_s;
    public FirstPersonRenderer field_78516_c;
    private final MapItemRenderer field_147709_v;
    private int field_78529_t;
    private float field_78507_R;
    private float field_78506_S;
    private float field_82831_U;
    private float field_82832_V;
    private boolean field_175074_C = true;
    private boolean field_175073_D = true;
    private long field_184374_E;
    private long field_78508_Y = Util.func_211177_b();
    private final LightTexture field_78513_d;
    private int field_78534_ac;
    private final float[] field_175076_N = new float[1024];
    private final float[] field_175077_O = new float[1024];
    public final FogRenderer field_205003_A;
    private boolean field_175078_W;
    private double field_78503_V = 1.0;
    private double field_78502_W;
    private double field_78509_X;
    private ItemStack field_190566_ab;
    private int field_190567_ac;
    private float field_190568_ad;
    private float field_190569_ae;
    private ShaderGroup field_147707_d;
    private static final ResourceLocation[] field_147712_ad = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int field_147708_e = field_147712_ad.length;
    private int field_147713_ae;
    private boolean field_175083_ad;
    public int field_175084_ae;
    private final ActiveRenderInfo field_215317_L;
    private boolean initialized = false;
    private World updatedWorld = null;
    public boolean fogStandard = false;
    private float clipDistance = 128.0f;
    private long lastServerTime = 0L;
    private int lastServerTicks = 0;
    private int serverWaitTime = 0;
    private int serverWaitTimeCurrent = 0;
    private float avgServerTimeDiff = 0.0f;
    private float avgServerTickDiff = 0.0f;
    private ShaderGroup[] fxaaShaders = new ShaderGroup[10];
    public int loadVisibleChunksCounter = -1;
    public static final int loadVisibleChunksMessageId = 201435902;
    private boolean guiLoadingVisible = false;

    public GameRenderer(Minecraft p_i554_1_, IResourceManager p_i554_2_) {
        this.field_147713_ae = field_147708_e;
        this.field_215317_L = new ActiveRenderInfo();
        this.field_78531_r = p_i554_1_;
        this.field_147711_ac = p_i554_2_;
        this.field_78516_c = p_i554_1_.func_175597_ag();
        this.field_147709_v = new MapItemRenderer(p_i554_1_.func_110434_K());
        this.field_78513_d = new LightTexture(this);
        this.field_205003_A = new FogRenderer(this);
        this.field_147707_d = null;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.field_175076_N[i << 5 | j] = -f1 / f2;
                this.field_175077_O[i << 5 | j] = f / f2;
            }
        }
    }

    @Override
    public void close() {
        this.field_78513_d.close();
        this.field_147709_v.close();
        this.func_181022_b();
    }

    public boolean func_147702_a() {
        return GLX.usePostProcess && this.field_147707_d != null;
    }

    public void func_181022_b() {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        this.field_147713_ae = field_147708_e;
    }

    public void func_175071_c() {
        this.field_175083_ad = !this.field_175083_ad;
    }

    public void func_175066_a(@Nullable Entity entityIn) {
        if (GLX.usePostProcess) {
            if (this.field_147707_d != null) {
                this.field_147707_d.close();
            }
            this.field_147707_d = null;
            if (entityIn instanceof CreeperEntity) {
                this.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
            } else if (entityIn instanceof SpiderEntity) {
                this.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
            } else if (entityIn instanceof EndermanEntity) {
                this.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
            } else if (Reflector.ForgeHooksClient_loadEntityShader.exists()) {
                Reflector.call(Reflector.ForgeHooksClient_loadEntityShader, entityIn, this);
            }
        }
    }

    private void func_175069_a(ResourceLocation resourceLocationIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        try {
            this.field_147707_d = new ShaderGroup(this.field_78531_r.func_110434_K(), this.field_147711_ac, this.field_78531_r.func_147110_a(), resourceLocationIn);
            this.field_147707_d.func_148026_a(this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
            this.field_175083_ad = true;
        }
        catch (IOException ioexception) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocationIn, (Object)ioexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocationIn, (Object)jsonsyntaxexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
    }

    public void func_195410_a(IResourceManager resourceManager) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (this.field_147713_ae == field_147708_e) {
            this.func_175066_a(this.field_78531_r.func_175606_aa());
        } else {
            this.func_175069_a(field_147712_ad[this.field_147713_ae]);
        }
    }

    public void func_78464_a() {
        if (GLX.usePostProcess && ShaderLinkHelper.func_148074_b() == null) {
            ShaderLinkHelper.func_148076_a();
        }
        this.func_78477_e();
        this.field_78513_d.func_205107_a();
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a((Entity)this.field_78531_r.field_71439_g);
        }
        this.field_215317_L.func_216783_a();
        ++this.field_78529_t;
        this.field_78516_c.func_78441_a();
        this.func_78484_h();
        this.field_82832_V = this.field_82831_U;
        if (this.field_78531_r.field_71456_v.func_184046_j().func_184053_e()) {
            this.field_82831_U += 0.05f;
            if (this.field_82831_U > 1.0f) {
                this.field_82831_U = 1.0f;
            }
        } else if (this.field_82831_U > 0.0f) {
            this.field_82831_U -= 0.0125f;
        }
        if (this.field_190567_ac > 0) {
            --this.field_190567_ac;
            if (this.field_190567_ac == 0) {
                this.field_190566_ab = null;
            }
        }
    }

    public ShaderGroup func_147706_e() {
        return this.field_147707_d;
    }

    public void func_147704_a(int width, int height) {
        if (GLX.usePostProcess) {
            if (this.field_147707_d != null) {
                this.field_147707_d.func_148026_a(width, height);
            }
            this.field_78531_r.field_71438_f.func_72720_a(width, height);
        }
    }

    public void func_78473_a(float partialTicks) {
        Entity entity = this.field_78531_r.func_175606_aa();
        if (entity != null && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.func_213239_aq().func_76320_a("pick");
            this.field_78531_r.field_147125_j = null;
            double d0 = this.field_78531_r.field_71442_b.func_78757_d();
            this.field_78531_r.field_71476_x = entity.func_213324_a(d0, partialTicks, false);
            Vec3d vec3d = entity.func_174824_e(partialTicks);
            boolean flag = false;
            int i = 3;
            double d1 = d0;
            if (this.field_78531_r.field_71442_b.func_78749_i()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            d1 *= d1;
            if (this.field_78531_r.field_71476_x != null) {
                d1 = this.field_78531_r.field_71476_x.func_216347_e().func_72436_e(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
            float f = 1.0f;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_216361_a(vec3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)entity, (Vec3d)vec3d, (Vec3d)vec3d2, (AxisAlignedBB)axisalignedbb, p_215312_0_ -> !p_215312_0_.func_175149_v() && p_215312_0_.func_70067_L(), (double)d1);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.func_216348_a();
                Vec3d vec3d3 = entityraytraceresult.func_216347_e();
                double d2 = vec3d.func_72436_e(vec3d3);
                if (flag && d2 > 9.0) {
                    this.field_78531_r.field_71476_x = BlockRayTraceResult.func_216352_a((Vec3d)vec3d3, (Direction)Direction.func_210769_a((double)vec3d1.field_72450_a, (double)vec3d1.field_72448_b, (double)vec3d1.field_72449_c), (BlockPos)new BlockPos(vec3d3));
                } else if (d2 < d1 || this.field_78531_r.field_71476_x == null) {
                    this.field_78531_r.field_71476_x = entityraytraceresult;
                    if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrameEntity) {
                        this.field_78531_r.field_147125_j = entity1;
                    }
                }
            }
            this.field_78531_r.func_213239_aq().func_76319_b();
        }
    }

    private void func_78477_e() {
        float f = 1.0f;
        if (this.field_78531_r.func_175606_aa() instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractclientplayerentity = (AbstractClientPlayerEntity)this.field_78531_r.func_175606_aa();
            f = abstractclientplayerentity.func_175156_o();
        }
        this.field_78506_S = this.field_78507_R;
        this.field_78507_R += (f - this.field_78507_R) * 0.5f;
        if (this.field_78507_R > 1.5f) {
            this.field_78507_R = 1.5f;
        }
        if (this.field_78507_R < 0.1f) {
            this.field_78507_R = 0.1f;
        }
    }

    private double func_215311_a(ActiveRenderInfo activeRenderInfo, float partialTicks, boolean useFOVSetting) {
        IFluidState ifluidstate;
        if (this.field_175078_W) {
            return 90.0;
        }
        double d0 = 70.0;
        if (useFOVSetting) {
            d0 = this.field_78531_r.field_71474_y.field_74334_X;
            if (Config.isDynamicFov()) {
                d0 *= (double)MathHelper.func_219799_g((float)partialTicks, (float)this.field_78506_S, (float)this.field_78507_R);
            }
        }
        boolean zoomActive = false;
        if (this.field_78531_r.field_71462_r == null) {
            zoomActive = this.field_78531_r.field_71474_y.ofKeyBindZoom.func_151470_d();
        }
        if (zoomActive) {
            if (!Config.zoomMode) {
                Config.zoomMode = true;
                this.field_78531_r.field_71474_y.field_74326_T = true;
                this.field_78531_r.field_71438_f.field_147595_R = true;
            }
            if (Config.zoomMode) {
                d0 /= 4.0;
            }
        } else if (Config.zoomMode) {
            Config.zoomMode = false;
            this.field_78531_r.field_71474_y.field_74326_T = false;
            this.field_78531_r.field_71438_f.field_147595_R = true;
        }
        if (activeRenderInfo.func_216773_g() instanceof LivingEntity && ((LivingEntity)activeRenderInfo.func_216773_g()).func_110143_aJ() <= 0.0f) {
            float f = (float)((LivingEntity)activeRenderInfo.func_216773_g()).field_70725_aQ + partialTicks;
            d0 /= (double)((1.0f - 500.0f / (f + 500.0f)) * 2.0f + 1.0f);
        }
        if (!(ifluidstate = activeRenderInfo.func_216771_k()).func_206888_e()) {
            d0 = d0 * 60.0 / 70.0;
        }
        if (Reflector.ForgeHooksClient_getFOVModifier.exists()) {
            BlockState iblockstate = activeRenderInfo.getBlockState();
            Entity entity = activeRenderInfo.func_216773_g();
            return Reflector.callDouble(Reflector.ForgeHooksClient_getFOVModifier, this, entity, iblockstate, ifluidstate, Float.valueOf(partialTicks), d0);
        }
        return d0;
    }

    private void func_78482_e(float partialTicks) {
        if (this.field_78531_r.func_175606_aa() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.field_78531_r.func_175606_aa();
            float f = (float)livingentity.field_70737_aN - partialTicks;
            if (livingentity.func_110143_aJ() <= 0.0f) {
                float f1 = (float)livingentity.field_70725_aQ + partialTicks;
                GlStateManager.rotatef((float)(40.0f - 8000.0f / (f1 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (f < 0.0f) {
                return;
            }
            f /= (float)livingentity.field_70738_aO;
            f = MathHelper.func_76126_a((float)(f * f * f * f * (float)Math.PI));
            float f2 = livingentity.field_70739_aP;
            GlStateManager.rotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(-f * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void func_78475_f(float partialTicks) {
        if (this.field_78531_r.func_175606_aa() instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)this.field_78531_r.func_175606_aa();
            float f = playerentity.field_70140_Q - playerentity.field_70141_P;
            float f1 = -(playerentity.field_70140_Q + f * partialTicks);
            float f2 = MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            GlStateManager.translatef((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2)), (float)0.0f);
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    public void func_195460_g(float partialTicks) {
        float f;
        this.field_78530_s = this.field_78531_r.field_71474_y.field_151451_c * 16;
        if (Config.isFogFancy()) {
            this.field_78530_s *= 0.95f;
        }
        if (Config.isFogFast()) {
            this.field_78530_s *= 0.83f;
        }
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        this.clipDistance = this.field_78530_s * 2.0f;
        if (this.clipDistance < 173.0f) {
            this.clipDistance = 173.0f;
        }
        if (this.field_78503_V != 1.0) {
            GlStateManager.translatef((float)((float)this.field_78502_W), (float)((float)(-this.field_78509_X)), (float)0.0f);
            GlStateManager.scaled((double)this.field_78503_V, (double)this.field_78503_V, (double)1.0);
        }
        GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)this.func_215311_a(this.field_215317_L, partialTicks, true), (float)((float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l()), (float)0.05f, (float)this.clipDistance));
        GlStateManager.matrixMode((int)5888);
        GlStateManager.loadIdentity();
        this.func_78482_e(partialTicks);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(partialTicks);
        }
        if ((f = MathHelper.func_219799_g((float)partialTicks, (float)this.field_78531_r.field_71439_g.field_71080_cy, (float)this.field_78531_r.field_71439_g.field_71086_bY)) > 0.0f) {
            int i = 20;
            if (this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k)) {
                i = 7;
            }
            float f1 = 5.0f / (f * f + 5.0f) - f * 0.04f;
            f1 *= f1;
            GlStateManager.rotatef((float)(((float)this.field_78529_t + partialTicks) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
            GlStateManager.scalef((float)(1.0f / f1), (float)1.0f, (float)1.0f);
            GlStateManager.rotatef((float)(-((float)this.field_78529_t + partialTicks) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void func_215308_a(ActiveRenderInfo activeRenderInfo, float partialTicks) {
        this.renderHand(activeRenderInfo, partialTicks, true, true, false);
    }

    public void renderHand(ActiveRenderInfo activeRenderInfo, float partialTicks, boolean renderItem, boolean renderOverlay, boolean renderTranslucent) {
        if (!this.field_175078_W) {
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            if (Config.isShaders()) {
                Shaders.applyHandDepth();
            }
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)this.func_215311_a(activeRenderInfo, partialTicks, false), (float)((float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l()), (float)0.05f, (float)(this.field_78530_s * 2.0f)));
            GlStateManager.matrixMode((int)5888);
            GlStateManager.loadIdentity();
            boolean flag = false;
            if (renderItem) {
                boolean shouldRenderHand;
                GlStateManager.pushMatrix();
                this.func_78482_e(partialTicks);
                if (this.field_78531_r.field_71474_y.field_74336_f) {
                    this.func_78475_f(partialTicks);
                }
                flag = this.field_78531_r.func_175606_aa() instanceof LivingEntity && ((LivingEntity)this.field_78531_r.func_175606_aa()).func_70608_bn();
                boolean bl = shouldRenderHand = !ReflectorForge.renderFirstPersonHand((WorldRenderer)this.field_78531_r.field_71438_f, (float)partialTicks);
                if (shouldRenderHand && this.field_78531_r.field_71474_y.field_74320_O == 0 && !flag && !this.field_78531_r.field_71474_y.field_74319_N && this.field_78531_r.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                    this.func_180436_i();
                    if (Config.isShaders()) {
                        ShadersRender.renderItemFP((FirstPersonRenderer)this.field_78516_c, (float)partialTicks, (boolean)renderTranslucent);
                    } else {
                        this.field_78516_c.func_78440_a(partialTicks);
                    }
                    this.func_175072_h();
                }
                GlStateManager.popMatrix();
            }
            if (!renderOverlay) {
                return;
            }
            this.func_175072_h();
            if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !flag) {
                this.field_78516_c.func_78447_b(partialTicks);
                this.func_78482_e(partialTicks);
            }
            if (this.field_78531_r.field_71474_y.field_74336_f) {
                this.func_78475_f(partialTicks);
            }
        }
    }

    public void func_175072_h() {
        this.field_78513_d.func_205108_b();
        if (Config.isShaders()) {
            Shaders.disableLightmap();
        }
    }

    public void func_180436_i() {
        this.field_78513_d.func_205109_c();
        if (Config.isShaders()) {
            Shaders.enableLightmap();
        }
    }

    public float func_180438_a(LivingEntity entitylivingbaseIn, float partialTicks) {
        int i = entitylivingbaseIn.func_70660_b(Effects.field_76439_r).func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    public void func_195458_a(float partialTicks, long nanoTime, boolean renderWorldIn) {
        this.frameInit();
        if (!(this.field_78531_r.func_195544_aj() || !this.field_78531_r.field_71474_y.field_82881_y || this.field_78531_r.field_71474_y.field_85185_A && this.field_78531_r.field_71417_B.func_198031_d())) {
            if (Util.func_211177_b() - this.field_78508_Y > 500L) {
                this.field_78531_r.func_71385_j(false);
            }
        } else {
            this.field_78508_Y = Util.func_211177_b();
        }
        if (!this.field_78531_r.field_71454_w) {
            int i = (int)(this.field_78531_r.field_71417_B.func_198024_e() * (double)this.field_78531_r.field_195558_d.func_198107_o() / (double)this.field_78531_r.field_195558_d.func_198105_m());
            int j = (int)(this.field_78531_r.field_71417_B.func_198026_f() * (double)this.field_78531_r.field_195558_d.func_198087_p() / (double)this.field_78531_r.field_195558_d.func_198083_n());
            int k = this.field_78531_r.field_71474_y.field_74350_i;
            if (renderWorldIn && this.field_78531_r.field_71441_e != null && !Config.isReloadingResources()) {
                this.field_78531_r.func_213239_aq().func_76320_a("level");
                int l2 = Math.min(Minecraft.func_175610_ah(), k);
                l2 = Math.max(l2, 60);
                long i1 = Util.func_211178_c() - nanoTime;
                long j1 = Math.max((long)(1000000000 / l2 / 4) - i1, 0L);
                this.func_78471_a(partialTicks, Util.func_211178_c() + j1);
                if (this.field_78531_r.func_71356_B() && this.field_184374_E < Util.func_211177_b() - 1000L) {
                    this.field_184374_E = Util.func_211177_b();
                    if (!this.field_78531_r.func_71401_C().func_184106_y()) {
                        this.func_184373_n();
                    }
                }
                if (GLX.usePostProcess) {
                    this.field_78531_r.field_71438_f.func_174975_c();
                    if (this.field_147707_d != null && this.field_175083_ad) {
                        GlStateManager.matrixMode((int)5890);
                        GlStateManager.pushMatrix();
                        GlStateManager.loadIdentity();
                        this.field_147707_d.func_148018_a(partialTicks);
                        GlStateManager.popMatrix();
                    }
                    this.field_78531_r.func_147110_a().func_147610_a(true);
                }
                this.field_78531_r.func_213239_aq().func_219895_b("gui");
                if (!this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71462_r != null) {
                    GlStateManager.alphaFunc((int)516, (float)0.1f);
                    this.field_78531_r.field_195558_d.func_216522_a(Minecraft.field_142025_a);
                    this.func_190563_a(this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), partialTicks);
                    this.field_78531_r.field_71456_v.func_175180_a(partialTicks);
                    if (this.field_78531_r.field_71474_y.ofShowFps && !this.field_78531_r.field_71474_y.field_74330_P) {
                        Config.drawFps();
                    }
                    if (this.field_78531_r.field_71474_y.field_74330_P) {
                        Lagometer.showLagometer((int)this.field_78531_r.field_195558_d.func_198100_s());
                    }
                }
                this.field_78531_r.func_213239_aq().func_76319_b();
            } else {
                GlStateManager.viewport((int)0, (int)0, (int)this.field_78531_r.field_195558_d.func_198109_k(), (int)this.field_78531_r.field_195558_d.func_198091_l());
                GlStateManager.matrixMode((int)5889);
                GlStateManager.loadIdentity();
                GlStateManager.matrixMode((int)5888);
                GlStateManager.loadIdentity();
                this.field_78531_r.field_195558_d.func_216522_a(Minecraft.field_142025_a);
                TileEntityRendererDispatcher.field_147556_a.field_147553_e = this.field_78531_r.func_110434_K();
                TileEntityRendererDispatcher.field_147556_a.field_147557_n = this.field_78531_r.field_71466_p;
            }
            if (this.guiLoadingVisible != (this.field_78531_r.field_213279_p != null)) {
                if (this.field_78531_r.field_213279_p != null) {
                    this.field_78531_r.func_110434_K().func_147645_c((ResourceLocation)Config.LOCATION_MOJANG_LOGO);
                    if (this.field_78531_r.field_213279_p instanceof ResourceLoadProgressGui) {
                        ResourceLoadProgressGui rlpg = (ResourceLoadProgressGui)this.field_78531_r.field_213279_p;
                        rlpg.update();
                    }
                }
                boolean bl = this.guiLoadingVisible = this.field_78531_r.field_213279_p != null;
            }
            if (this.field_78531_r.field_213279_p != null) {
                GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
                try {
                    this.field_78531_r.field_213279_p.render(i, j, this.field_78531_r.func_193989_ak());
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering overlay");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Overlay render details");
                    crashreportcategory.func_189529_a("Overlay name", () -> this.field_78531_r.field_213279_p.getClass().getCanonicalName());
                    throw new ReportedException(crashreport);
                }
            }
            if (this.field_78531_r.field_71462_r != null) {
                GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
                try {
                    if (Reflector.ForgeHooksClient_drawScreen.exists()) {
                        Reflector.callVoid(Reflector.ForgeHooksClient_drawScreen, this.field_78531_r.field_71462_r, i, j, Float.valueOf(this.field_78531_r.func_193989_ak()));
                    } else {
                        this.field_78531_r.field_71462_r.render(i, j, this.field_78531_r.func_193989_ak());
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering screen");
                    CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Screen render details");
                    crashreportcategory1.func_189529_a("Screen name", () -> this.field_78531_r.field_71462_r.getClass().getCanonicalName());
                    crashreportcategory1.func_189529_a("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", i, j, this.field_78531_r.field_71417_B.func_198024_e(), this.field_78531_r.field_71417_B.func_198026_f()));
                    crashreportcategory1.func_189529_a("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l(), this.field_78531_r.field_195558_d.func_198100_s()));
                    throw new ReportedException(crashreport1);
                }
            }
        }
        this.frameFinish();
        this.waitForServerThread();
        Lagometer.updateLagometer();
        if (this.field_78531_r.field_71474_y.ofProfiler) {
            this.field_78531_r.field_71474_y.field_74329_Q = true;
        }
    }

    private void func_184373_n() {
        if (this.field_78531_r.field_71438_f.func_184382_g() > 10 && this.field_78531_r.field_71438_f.func_184384_n() && !this.field_78531_r.func_71401_C().func_184106_y()) {
            NativeImage nativeimage = ScreenShotHelper.func_198052_a((int)this.field_78531_r.field_195558_d.func_198109_k(), (int)this.field_78531_r.field_195558_d.func_198091_l(), (Framebuffer)this.field_78531_r.func_147110_a());
            SimpleResource.field_199031_a.execute(() -> {
                int i = nativeimage.func_195702_a();
                int j = nativeimage.func_195714_b();
                int k = 0;
                int l2 = 0;
                if (i > j) {
                    k = (i - j) / 2;
                    i = j;
                } else {
                    l2 = (j - i) / 2;
                    j = i;
                }
                try (NativeImage nativeimage1 = new NativeImage(64, 64, false);){
                    nativeimage.func_195708_a(k, l2, i, j, nativeimage1);
                    nativeimage1.func_209271_a(this.field_78531_r.func_71401_C().func_184109_z());
                }
                catch (IOException ioexception) {
                    field_147710_q.warn("Couldn't save auto screenshot", (Throwable)ioexception);
                }
                finally {
                    nativeimage.close();
                }
            });
        }
    }

    private boolean func_175070_n() {
        boolean flag;
        if (!this.field_175073_D) {
            return false;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        boolean bl = flag = entity instanceof PlayerEntity && !this.field_78531_r.field_71474_y.field_74319_N;
        if (flag && !((PlayerEntity)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemstack = ((LivingEntity)entity).func_184614_ca();
            RayTraceResult raytraceresult = this.field_78531_r.field_71476_x;
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
                BlockState blockstate = this.field_78531_r.field_71441_e.func_180495_p(blockpos);
                if (this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                    flag = blockstate.func_215699_b((World)this.field_78531_r.field_71441_e, blockpos) != null;
                } else {
                    CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)this.field_78531_r.field_71441_e, blockpos, false);
                    flag = !itemstack.func_190926_b() && (itemstack.func_206848_a(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo) || itemstack.func_206847_b(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo));
                }
            }
        }
        return flag;
    }

    public void func_78471_a(float partialTicks, long finishTimeNano) {
        this.field_78513_d.func_205106_a(partialTicks);
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a((Entity)this.field_78531_r.field_71439_g);
        }
        this.func_78473_a(partialTicks);
        if (Config.isShaders()) {
            Shaders.beginRender((Minecraft)this.field_78531_r, (ActiveRenderInfo)this.field_215317_L, (float)partialTicks, (long)finishTimeNano);
        }
        GlStateManager.enableDepthTest();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        this.field_78531_r.func_213239_aq().func_76320_a("center");
        this.func_181560_a(partialTicks, finishTimeNano);
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    private void func_181560_a(float partialTicks, long nanoTime) {
        boolean isShaders = Config.isShaders();
        if (isShaders) {
            Shaders.beginRenderPass(partialTicks, nanoTime);
        }
        WorldRenderer worldrenderer = this.field_78531_r.field_71438_f;
        ParticleManager particlemanager = this.field_78531_r.field_71452_i;
        boolean flag = this.func_175070_n();
        GlStateManager.enableCull();
        this.field_78531_r.func_213239_aq().func_219895_b("camera");
        this.func_195460_g(partialTicks);
        ActiveRenderInfo activerenderinfo = this.field_215317_L;
        activerenderinfo.func_216772_a((IBlockReader)this.field_78531_r.field_71441_e, (Entity)(this.field_78531_r.func_175606_aa() == null ? this.field_78531_r.field_71439_g : this.field_78531_r.func_175606_aa()), this.field_78531_r.field_71474_y.field_74320_O > 0, this.field_78531_r.field_71474_y.field_74320_O == 2, partialTicks);
        ClippingHelper clippinghelper = ClippingHelperImpl.func_78558_a();
        this.field_78531_r.func_213239_aq().func_219895_b("clear");
        if (isShaders) {
            Shaders.setViewport(0, 0, this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
        } else {
            GlStateManager.viewport((int)0, (int)0, (int)this.field_78531_r.field_195558_d.func_198109_k(), (int)this.field_78531_r.field_195558_d.func_198091_l());
        }
        this.field_205003_A.func_217619_a(activerenderinfo, partialTicks);
        GlStateManager.clear((int)16640, (boolean)Minecraft.field_142025_a);
        if (isShaders) {
            Shaders.clearRenderBuffer();
        }
        if (isShaders) {
            Shaders.setCamera((ActiveRenderInfo)activerenderinfo, (float)partialTicks);
        }
        clippinghelper.disabled = Config.isShaders() && !Shaders.isFrustumCulling();
        this.field_78531_r.func_213239_aq().func_219895_b("culling");
        Frustum icamera = new Frustum(clippinghelper);
        double d0 = activerenderinfo.func_216785_c().field_72450_a;
        double d1 = activerenderinfo.func_216785_c().field_72448_b;
        double d2 = activerenderinfo.func_216785_c().field_72449_c;
        if (isShaders) {
            ShadersRender.setFrustrumPosition((ICamera)icamera, (double)d0, (double)d1, (double)d2);
        } else {
            icamera.func_78547_a(d0, d1, d2);
        }
        if ((Config.isSkyEnabled() || Config.isSunMoonEnabled() || Config.isStarsEnabled()) && !Shaders.isShadowPass) {
            this.field_205003_A.func_217618_a(activerenderinfo, -1);
            this.field_78531_r.func_213239_aq().func_219895_b("sky");
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)this.func_215311_a(activerenderinfo, partialTicks, true), (float)((float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l()), (float)0.05f, (float)this.clipDistance));
            GlStateManager.matrixMode((int)5888);
            if (isShaders) {
                Shaders.beginSky();
            }
            worldrenderer.func_195465_a(partialTicks);
            if (isShaders) {
                Shaders.endSky();
            }
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)this.func_215311_a(activerenderinfo, partialTicks, true), (float)((float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l()), (float)0.05f, (float)this.clipDistance));
            GlStateManager.matrixMode((int)5888);
        } else {
            GlStateManager.disableBlend();
        }
        this.field_205003_A.func_217618_a(activerenderinfo, 0);
        GlStateManager.shadeModel((int)7425);
        if (activerenderinfo.func_216785_c().field_72448_b < 128.0 + this.field_78531_r.field_71474_y.ofCloudsHeight * 128.0) {
            this.func_215313_a(activerenderinfo, worldrenderer, partialTicks, d0, d1, d2);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("prepareterrain");
        this.field_205003_A.func_217618_a(activerenderinfo, 0);
        this.field_78531_r.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        RenderHelper.func_74518_a();
        this.field_78531_r.func_213239_aq().func_219895_b("terrain_setup");
        this.field_78531_r.field_71441_e.func_72863_F().func_212863_j_().func_215575_a(Integer.MAX_VALUE, true, true);
        this.checkLoadVisibleChunks(activerenderinfo, (ICamera)icamera, this.field_78531_r.field_71439_g.func_175149_v());
        if (isShaders) {
            ShadersRender.setupTerrain((WorldRenderer)worldrenderer, (ActiveRenderInfo)activerenderinfo, (ICamera)icamera, (int)this.field_175084_ae++, (boolean)this.field_78531_r.field_71439_g.func_175149_v());
        } else {
            worldrenderer.func_215320_a(activerenderinfo, (ICamera)icamera, this.field_175084_ae++, this.field_78531_r.field_71439_g.func_175149_v());
        }
        this.field_78531_r.func_213239_aq().func_219895_b("updatechunks");
        Lagometer.timerChunkUpload.start();
        this.field_78531_r.field_71438_f.func_174967_a(nanoTime);
        Lagometer.timerChunkUpload.end();
        this.field_78531_r.func_213239_aq().func_219895_b("terrain");
        Lagometer.timerTerrain.start();
        if (this.field_78531_r.field_71474_y.ofSmoothFps) {
            this.field_78531_r.func_213239_aq().func_219895_b("finish");
            GL11.glFinish();
            this.field_78531_r.func_213239_aq().func_219895_b("terrain");
        }
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.disableAlphaTest();
        if (isShaders) {
            ShadersRender.beginTerrainSolid();
        }
        worldrenderer.func_215323_a(BlockRenderLayer.SOLID, activerenderinfo);
        GlStateManager.enableAlphaTest();
        if (isShaders) {
            ShadersRender.beginTerrainCutoutMipped();
        }
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, this.field_78531_r.field_71474_y.field_151442_I > 0);
        worldrenderer.func_215323_a(BlockRenderLayer.CUTOUT_MIPPED, activerenderinfo);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        if (isShaders) {
            ShadersRender.beginTerrainCutout();
        }
        worldrenderer.func_215323_a(BlockRenderLayer.CUTOUT, activerenderinfo);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        if (isShaders) {
            ShadersRender.endTerrain();
        }
        Lagometer.timerTerrain.end();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        this.field_78531_r.func_213239_aq().func_219895_b("entities");
        if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
            Reflector.callVoid(Reflector.ForgeHooksClient_setRenderPass, 0);
        }
        worldrenderer.func_215326_a(activerenderinfo, (ICamera)icamera, partialTicks);
        if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
            Reflector.callVoid(Reflector.ForgeHooksClient_setRenderPass, 0);
        }
        RenderHelper.func_74518_a();
        this.func_175072_h();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        if (flag && this.field_78531_r.field_71476_x != null) {
            GlStateManager.disableAlphaTest();
            this.field_78531_r.func_213239_aq().func_219895_b("outline");
            if (!Reflector.ForgeHooksClient_onDrawBlockHighlight.exists() || !Reflector.callBoolean(Reflector.ForgeHooksClient_onDrawBlockHighlight, worldrenderer, activerenderinfo.func_216773_g(), this.field_78531_r.field_71476_x, 0, Float.valueOf(partialTicks))) {
                worldrenderer.func_215325_a(activerenderinfo, this.field_78531_r.field_71476_x, 0);
            }
            GlStateManager.enableAlphaTest();
        }
        if (this.field_78531_r.field_184132_p.func_190074_a()) {
            boolean preDebugFog = GlStateManager.isFogEnabled();
            GlStateManager.disableFog();
            this.field_78531_r.field_184132_p.func_190073_a(nanoTime);
            GlStateManager.setFogEnabled((boolean)preDebugFog);
        }
        if (!worldrenderer.field_72738_E.isEmpty()) {
            this.field_78531_r.func_213239_aq().func_219895_b("destroyProgress");
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
            worldrenderer.func_215318_a(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), activerenderinfo);
            this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
            GlStateManager.disableBlend();
        }
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.disableBlend();
        this.func_180436_i();
        this.field_205003_A.func_217618_a(activerenderinfo, 0);
        this.field_78531_r.func_213239_aq().func_219895_b("particles");
        if (isShaders) {
            Shaders.beginParticles();
        }
        particlemanager.func_215233_a(activerenderinfo, partialTicks);
        if (isShaders) {
            Shaders.endParticles();
        }
        this.func_175072_h();
        GlStateManager.depthMask((boolean)false);
        if (Config.isShaders()) {
            GlStateManager.depthMask((boolean)Shaders.isRainDepth());
        }
        GlStateManager.enableCull();
        this.field_78531_r.func_213239_aq().func_219895_b("weather");
        if (isShaders) {
            Shaders.beginWeather();
        }
        this.func_78474_d(partialTicks);
        if (isShaders) {
            Shaders.endWeather();
        }
        GlStateManager.depthMask((boolean)true);
        worldrenderer.func_215322_a(activerenderinfo, partialTicks);
        if (isShaders) {
            ShadersRender.renderHand0((GameRenderer)this, (ActiveRenderInfo)activerenderinfo, (float)partialTicks);
            Shaders.preWater();
        }
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        this.field_205003_A.func_217618_a(activerenderinfo, 0);
        GlStateManager.enableBlend();
        GlStateManager.depthMask((boolean)false);
        this.field_78531_r.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.shadeModel((int)7425);
        this.field_78531_r.func_213239_aq().func_219895_b("translucent");
        if (isShaders) {
            Shaders.beginWater();
        }
        worldrenderer.func_215323_a(BlockRenderLayer.TRANSLUCENT, activerenderinfo);
        if (isShaders) {
            Shaders.endWater();
        }
        GlStateManager.shadeModel((int)7424);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.disableFog();
        if (activerenderinfo.func_216785_c().field_72448_b >= 128.0 + this.field_78531_r.field_71474_y.ofCloudsHeight * 128.0) {
            this.field_78531_r.func_213239_aq().func_219895_b("aboveClouds");
            this.func_215313_a(activerenderinfo, worldrenderer, partialTicks, d0, d1, d2);
        }
        if (Reflector.ForgeHooksClient_dispatchRenderLast.exists()) {
            this.field_78531_r.func_213239_aq().func_219895_b("forge_render_last");
            Reflector.callVoid(Reflector.ForgeHooksClient_dispatchRenderLast, worldrenderer, Float.valueOf(partialTicks));
        }
        this.field_78531_r.func_213239_aq().func_219895_b("hand");
        if (this.field_175074_C && !Shaders.isShadowPass) {
            if (isShaders) {
                ShadersRender.renderHand1((GameRenderer)this, (ActiveRenderInfo)activerenderinfo, (float)partialTicks);
                Shaders.renderCompositeFinal();
            }
            GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
            if (isShaders) {
                ShadersRender.renderFPOverlay((GameRenderer)this, (ActiveRenderInfo)activerenderinfo, (float)partialTicks);
            } else {
                this.func_215308_a(activerenderinfo, partialTicks);
            }
        }
        if (isShaders) {
            Shaders.endRender();
        }
    }

    private void func_215313_a(ActiveRenderInfo activeRenderInfo, WorldRenderer renderGlobalIn, float partialTicks, double viewEntityX, double viewEntityY, double viewEntityZ) {
        if (this.field_78531_r.field_71474_y.func_216842_e() != CloudOption.OFF && !Config.isCloudsOff() && Shaders.shouldRenderClouds((GameSettings)this.field_78531_r.field_71474_y)) {
            this.field_78531_r.func_213239_aq().func_219895_b("clouds");
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)this.func_215311_a(activeRenderInfo, partialTicks, true), (float)((float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l()), (float)0.05f, (float)(this.clipDistance * 4.0f)));
            GlStateManager.matrixMode((int)5888);
            GlStateManager.pushMatrix();
            this.field_205003_A.func_217618_a(activeRenderInfo, 0);
            renderGlobalIn.func_195466_a(partialTicks, viewEntityX, viewEntityY, viewEntityZ);
            GlStateManager.disableFog();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)this.func_215311_a(activeRenderInfo, partialTicks, true), (float)((float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l()), (float)0.05f, (float)this.clipDistance));
            GlStateManager.matrixMode((int)5888);
        }
    }

    private void func_78484_h() {
        float f = this.field_78531_r.field_71441_e.func_72867_j(1.0f);
        if (!Config.isRainFancy()) {
            f /= 2.0f;
        }
        if (f != 0.0f && Config.isRainSplash()) {
            this.field_78537_ab.setSeed((long)this.field_78529_t * 312987231L);
            ClientWorld iworldreader = this.field_78531_r.field_71441_e;
            BlockPos blockpos = new BlockPos(this.field_215317_L.func_216785_c());
            int i = 10;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            int j = 0;
            int k = (int)(100.0f * f * f);
            if (this.field_78531_r.field_71474_y.field_74362_aa == ParticleStatus.DECREASED) {
                k >>= 1;
            } else if (this.field_78531_r.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
                k = 0;
            }
            for (int l2 = 0; l2 < k; ++l2) {
                double d6;
                double d5;
                double d8;
                BlockPos blockpos1 = iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10), 0, this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10)));
                Biome biome = iworldreader.func_180494_b(blockpos1);
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 10 || blockpos1.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.RAIN || !(biome.func_180626_a(blockpos1) >= 0.15f)) continue;
                double d3 = this.field_78537_ab.nextDouble();
                double d4 = this.field_78537_ab.nextDouble();
                BlockState blockstate = iworldreader.func_180495_p(blockpos2);
                IFluidState ifluidstate = iworldreader.func_204610_c(blockpos1);
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)iworldreader, blockpos2);
                double d7 = voxelshape.func_197760_b(Direction.Axis.Y, d3, d4);
                if (d7 >= (d8 = (double)ifluidstate.func_215679_a((IBlockReader)iworldreader, blockpos1))) {
                    d5 = d7;
                    d6 = voxelshape.func_197764_a(Direction.Axis.Y, d3, d4);
                } else {
                    d5 = 0.0;
                    d6 = 0.0;
                }
                if (!(d5 > -1.7976931348623157E308)) continue;
                if (!(ifluidstate.func_206884_a(FluidTags.field_206960_b) || blockstate.func_177230_c() == Blocks.field_196814_hQ || blockstate.func_177230_c() == Blocks.field_222433_lV && ((Boolean)blockstate.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue())) {
                    if (this.field_78537_ab.nextInt(++j) == 0) {
                        d0 = (double)blockpos2.func_177958_n() + d3;
                        d1 = (double)((float)blockpos2.func_177956_o() + 0.1f) + d5 - 1.0;
                        d2 = (double)blockpos2.func_177952_p() + d4;
                    }
                    this.field_78531_r.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197600_K, (double)blockpos2.func_177958_n() + d3, (double)((float)blockpos2.func_177956_o() + 0.1f) + d5, (double)blockpos2.func_177952_p() + d4, 0.0, 0.0, 0.0);
                    continue;
                }
                this.field_78531_r.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)blockpos1.func_177958_n() + d3, (double)((float)blockpos1.func_177956_o() + 0.1f) - d6, (double)blockpos1.func_177952_p() + d4, 0.0, 0.0, 0.0);
            }
            if (j > 0 && this.field_78537_ab.nextInt(3) < this.field_78534_ac++) {
                this.field_78534_ac = 0;
                if (d1 > (double)(blockpos.func_177956_o() + 1) && iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    this.field_78531_r.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    this.field_78531_r.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    protected void func_78474_d(float partialTicks) {
        Dimension worldProvider;
        Object weatherRenderer;
        if (Reflector.ForgeDimension_getWeatherRenderer.exists() && (weatherRenderer = Reflector.call(worldProvider = this.field_78531_r.field_71441_e.field_73011_w, Reflector.ForgeDimension_getWeatherRenderer, new Object[0])) != null) {
            Reflector.callVoid(weatherRenderer, Reflector.IRenderHandler_render, Float.valueOf(partialTicks), this.field_78531_r.field_71441_e, this.field_78531_r);
            return;
        }
        float f = this.field_78531_r.field_71441_e.func_72867_j(partialTicks);
        if (f > 0.0f) {
            if (Config.isRainOff()) {
                return;
            }
            this.func_180436_i();
            ClientWorld world = this.field_78531_r.field_71441_e;
            int i = MathHelper.func_76128_c((double)this.field_215317_L.func_216785_c().field_72450_a);
            int j = MathHelper.func_76128_c((double)this.field_215317_L.func_216785_c().field_72448_b);
            int k = MathHelper.func_76128_c((double)this.field_215317_L.func_216785_c().field_72449_c);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.disableCull();
            GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            double d0 = this.field_215317_L.func_216785_c().field_72450_a;
            double d1 = this.field_215317_L.func_216785_c().field_72448_b;
            double d2 = this.field_215317_L.func_216785_c().field_72449_c;
            int l2 = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (Config.isRainFancy()) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.field_78529_t + partialTicks;
            bufferbuilder.func_178969_c(-d0, -d1, -d2);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.field_175076_N[i2] * 0.5;
                    double d4 = (double)this.field_175077_O[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int j2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l22 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l22 < j2) {
                        l22 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l2) {
                        i3 = l2;
                    }
                    if (k2 == l22) continue;
                    this.field_78537_ab.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (f2 >= 0.15f) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            this.field_78531_r.func_110434_K().func_110577_a(field_110924_q);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        double d5 = -((double)(this.field_78529_t + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.field_78537_ab.nextDouble());
                        double d6 = (double)((float)l1 + 0.5f) - this.field_215317_L.func_216785_c().field_72450_a;
                        double d7 = (double)((float)k1 + 0.5f) - this.field_215317_L.func_216785_c().field_72449_c;
                        float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int j3 = world.func_217338_b((BlockPos)blockpos$mutableblockpos, 0);
                        int k3 = j3 >> 16 & 0xFFFF;
                        int l3 = j3 & 0xFFFF;
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l22, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l22, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l22 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l22 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        this.field_78531_r.func_110434_K().func_110577_a(field_110923_r);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = -((float)(this.field_78529_t & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = this.field_78537_ab.nextDouble() + (double)f1 * 0.01 * (double)((float)this.field_78537_ab.nextGaussian());
                    double d10 = this.field_78537_ab.nextDouble() + (double)(f1 * (float)this.field_78537_ab.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - this.field_215317_L.func_216785_c().field_72450_a;
                    double d12 = (double)((float)k1 + 0.5f) - this.field_215317_L.func_216785_c().field_72449_c;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_217338_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l22, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l22, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l22 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l22 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            this.func_175072_h();
        }
    }

    public void func_191514_d(boolean black) {
        this.field_205003_A.func_205090_a(black);
    }

    public void func_190564_k() {
        this.field_190566_ab = null;
        this.field_147709_v.func_148249_a();
        this.field_215317_L.func_216781_o();
    }

    public MapItemRenderer func_147701_i() {
        return this.field_147709_v;
    }

    private void waitForServerThread() {
        this.serverWaitTimeCurrent = 0;
        if (!Config.isSmoothWorld() || !Config.isSingleProcessor()) {
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (!this.field_78531_r.func_71387_A()) {
            return;
        }
        IntegratedServer srv = this.field_78531_r.func_71401_C();
        if (srv == null) {
            return;
        }
        boolean paused = this.field_78531_r.func_147113_T();
        if (paused || this.field_78531_r.field_71462_r instanceof DownloadTerrainScreen) {
            if (this.field_78531_r.field_71462_r instanceof DownloadTerrainScreen) {
                Config.sleep(20L);
            }
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (this.serverWaitTime > 0) {
            Lagometer.timerServer.start();
            Config.sleep(this.serverWaitTime);
            Lagometer.timerServer.end();
            this.serverWaitTimeCurrent = this.serverWaitTime;
        }
        long timeNow = System.nanoTime() / 1000000L;
        if (this.lastServerTime == 0L || this.lastServerTicks == 0) {
            this.lastServerTime = timeNow;
            this.lastServerTicks = srv.func_71259_af();
            this.avgServerTickDiff = 1.0f;
            this.avgServerTimeDiff = 50.0f;
            return;
        }
        long timeDiff = timeNow - this.lastServerTime;
        if (timeDiff < 0L) {
            this.lastServerTime = timeNow;
            timeDiff = 0L;
        }
        if (timeDiff < 50L) {
            return;
        }
        this.lastServerTime = timeNow;
        int ticks = srv.func_71259_af();
        int tickDiff = ticks - this.lastServerTicks;
        if (tickDiff < 0) {
            this.lastServerTicks = ticks;
            tickDiff = 0;
        }
        if (tickDiff < 1 && this.serverWaitTime < 100) {
            this.serverWaitTime += 2;
        }
        if (tickDiff > 1 && this.serverWaitTime > 0) {
            --this.serverWaitTime;
        }
        this.lastServerTicks = ticks;
    }

    private void frameInit() {
        ClientWorld world;
        GlErrors.frameStart();
        if (!this.initialized) {
            if (Config.getBitsOs() == 64 && Config.getBitsJre() == 32) {
                Config.setNotify64BitJava(true);
            }
            this.initialized = true;
        }
        if ((world = this.field_78531_r.field_71441_e) != null) {
            if (Config.getNewRelease() != null) {
                String userEdition = "HD_U".replace("HD_U", "HD Ultra").replace("L", "Light");
                String fullNewVer = userEdition + " " + Config.getNewRelease();
                StringTextComponent msg = new StringTextComponent(I18n.func_135052_a((String)"of.message.newVersion", (Object[])new Object[]{"\u00a7n" + fullNewVer + "\u00a7r"}));
                msg.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://optifine.net/downloads")));
                this.field_78531_r.field_71456_v.func_146158_b().func_146227_a((ITextComponent)msg);
                Config.setNewRelease(null);
            }
            if (Config.isNotify64BitJava()) {
                Config.setNotify64BitJava(false);
                StringTextComponent msg = new StringTextComponent(I18n.func_135052_a((String)"of.message.java64Bit", (Object[])new Object[0]));
                this.field_78531_r.field_71456_v.func_146158_b().func_146227_a((ITextComponent)msg);
            }
        }
        if (this.field_78531_r.field_71462_r instanceof MainMenuScreen) {
            this.updateMainMenu((MainMenuScreen)this.field_78531_r.field_71462_r);
        }
        if (this.updatedWorld != world) {
            RandomEntities.worldChanged((World)this.updatedWorld, (World)world);
            Config.updateThreadPriorities();
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            this.updatedWorld = world;
        }
        if (!this.setFxaaShader(Shaders.configAntialiasingLevel)) {
            Shaders.configAntialiasingLevel = 0;
        }
        if (this.field_78531_r.field_71462_r != null && this.field_78531_r.field_71462_r.getClass() == ChatScreen.class) {
            this.field_78531_r.func_147108_a((Screen)new GuiChatOF((ChatScreen)this.field_78531_r.field_71462_r));
        }
    }

    private void frameFinish() {
        int err;
        if (this.field_78531_r.field_71441_e != null && Config.isShowGlErrors() && TimedEvent.isActive("CheckGlErrorFrameFinish", 10000L) && (err = GlStateManager.getError()) != 0 && GlErrors.isEnabled(err)) {
            String text = Config.getGlErrorString(err);
            StringTextComponent msg = new StringTextComponent(I18n.func_135052_a((String)"of.message.openglError", (Object[])new Object[]{err, text}));
            this.field_78531_r.field_71456_v.func_146158_b().func_146227_a((ITextComponent)msg);
        }
    }

    private void updateMainMenu(MainMenuScreen mainGui) {
        try {
            String str = null;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int day = calendar.get(5);
            int month = calendar.get(2) + 1;
            if (day == 8 && month == 4) {
                str = "Happy birthday, OptiFine!";
            }
            if (day == 14 && month == 8) {
                str = "Happy birthday, sp614x!";
            }
            if (str == null) {
                return;
            }
            Reflector.setFieldValue(mainGui, Reflector.GuiMainMenu_splashText, str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean setFxaaShader(int fxaaLevel) {
        if (!GLX.isUsingFBOs()) {
            return false;
        }
        if (this.field_147707_d != null && this.field_147707_d != this.fxaaShaders[2] && this.field_147707_d != this.fxaaShaders[4]) {
            return true;
        }
        if (fxaaLevel == 2 || fxaaLevel == 4) {
            if (this.field_147707_d != null && this.field_147707_d == this.fxaaShaders[fxaaLevel]) {
                return true;
            }
            if (this.field_78531_r.field_71441_e == null) {
                return true;
            }
            this.func_175069_a(new ResourceLocation("shaders/post/fxaa_of_" + fxaaLevel + "x.json"));
            this.fxaaShaders[fxaaLevel] = this.field_147707_d;
            return this.field_175083_ad;
        }
        if (this.field_147707_d == null) {
            return true;
        }
        this.field_147707_d.close();
        this.field_147707_d = null;
        return true;
    }

    private void checkLoadVisibleChunks(ActiveRenderInfo activeRenderInfo, ICamera icamera, boolean spectator) {
        if (this.loadVisibleChunksCounter == 0) {
            this.loadAllVisibleChunks(activeRenderInfo, icamera, spectator);
            this.field_78531_r.field_71456_v.func_146158_b().func_146242_c(201435902);
        }
        if (this.loadVisibleChunksCounter > -1) {
            --this.loadVisibleChunksCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllVisibleChunks(ActiveRenderInfo activeRenderInfo, ICamera icamera, boolean spectator) {
        int chunkUpdatesConfig = this.field_78531_r.field_71474_y.ofChunkUpdates;
        boolean lazyChunkLoadingConfig = this.field_78531_r.field_71474_y.ofLazyChunkLoading;
        try {
            this.field_78531_r.field_71474_y.ofChunkUpdates = 1000;
            this.field_78531_r.field_71474_y.ofLazyChunkLoading = false;
            WorldRenderer renderGlobal = Config.getRenderGlobal();
            int countLoadedChunks = renderGlobal.getCountLoadedChunks();
            long timeStart = System.currentTimeMillis();
            Config.dbg("Loading visible chunks");
            long timeLog = System.currentTimeMillis() + 5000L;
            int chunksUpdated = 0;
            boolean hasUpdates = false;
            do {
                hasUpdates = false;
                for (int i = 0; i < 100; ++i) {
                    renderGlobal.field_147595_R = true;
                    renderGlobal.func_215320_a(activeRenderInfo, icamera, this.field_175084_ae++, spectator);
                    if (!renderGlobal.func_184384_n()) {
                        hasUpdates = true;
                    }
                    chunksUpdated += renderGlobal.getCountChunksToUpdate();
                    while (!renderGlobal.func_184384_n()) {
                        renderGlobal.func_174967_a(System.nanoTime() + 1000000000L);
                    }
                    chunksUpdated -= renderGlobal.getCountChunksToUpdate();
                    if (!hasUpdates) break;
                }
                if (renderGlobal.getCountLoadedChunks() != countLoadedChunks) {
                    hasUpdates = true;
                    countLoadedChunks = renderGlobal.getCountLoadedChunks();
                }
                if (System.currentTimeMillis() <= timeLog) continue;
                Config.log("Chunks loaded: " + chunksUpdated);
                timeLog = System.currentTimeMillis() + 5000L;
            } while (hasUpdates);
            Config.log("Chunks loaded: " + chunksUpdated);
            Config.log("Finished loading visible chunks");
            ChunkRender.field_178592_a = 0;
        }
        finally {
            this.field_78531_r.field_71474_y.ofChunkUpdates = chunkUpdatesConfig;
            this.field_78531_r.field_71474_y.ofLazyChunkLoading = lazyChunkLoadingConfig;
        }
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }

    public static void func_215307_a(FontRenderer fontRendererIn, String str, float x, float y, float z, int verticalShift, float viewerYaw, float viewerPitch, boolean isSneaking) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)z);
        GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)viewerPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        if (!isSneaking) {
            GlStateManager.disableDepthTest();
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = fontRendererIn.func_78256_a(str) / 2;
        GlStateManager.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float f = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        if (!isSneaking) {
            fontRendererIn.func_211126_b(str, (float)(-fontRendererIn.func_78256_a(str) / 2), (float)verticalShift, 0x20FFFFFF);
            GlStateManager.enableDepthTest();
        }
        GlStateManager.depthMask((boolean)true);
        fontRendererIn.func_211126_b(str, (float)(-fontRendererIn.func_78256_a(str) / 2), (float)verticalShift, isSneaking ? 0x20FFFFFF : -1);
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public void func_190565_a(ItemStack stack) {
        this.field_190566_ab = stack;
        this.field_190567_ac = 40;
        this.field_190568_ad = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
        this.field_190569_ae = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
    }

    private void func_190563_a(int widthsp, int heightScaled, float partialTicks) {
        if (this.field_190566_ab != null && this.field_190567_ac > 0) {
            int i = 40 - this.field_190567_ac;
            float f = ((float)i + partialTicks) / 40.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.field_190568_ad * (float)(widthsp / 4);
            float f6 = this.field_190569_ae * (float)(heightScaled / 4);
            GlStateManager.enableAlphaTest();
            GlStateManager.pushMatrix();
            GlStateManager.pushLightingAttributes();
            GlStateManager.enableDepthTest();
            GlStateManager.disableCull();
            RenderHelper.func_74519_b();
            GlStateManager.translatef((float)((float)(widthsp / 2) + f5 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), (float)((float)(heightScaled / 2) + f6 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), (float)-50.0f);
            float f7 = 50.0f + 175.0f * MathHelper.func_76126_a((float)f4);
            GlStateManager.scalef((float)f7, (float)(-f7), (float)f7);
            GlStateManager.rotatef((float)(900.0f * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)f4))), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(6.0f * MathHelper.func_76134_b((float)(f * 8.0f))), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(6.0f * MathHelper.func_76134_b((float)(f * 8.0f))), (float)0.0f, (float)0.0f, (float)1.0f);
            this.field_78531_r.func_175599_af().func_181564_a(this.field_190566_ab, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popAttributes();
            GlStateManager.popMatrix();
            RenderHelper.func_74518_a();
            GlStateManager.enableCull();
            GlStateManager.disableDepthTest();
        }
    }

    public Minecraft func_205000_l() {
        return this.field_78531_r;
    }

    public float func_205002_d(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.field_82832_V, (float)this.field_82831_U);
    }

    public float func_205001_m() {
        return this.field_78530_s;
    }

    public ActiveRenderInfo func_215316_n() {
        return this.field_215317_L;
    }
}

