/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.AbstractChunkRenderContainer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ListedChunkRender;
import net.minecraft.util.BlockRenderLayer;
import net.optifine.Config;

public class RenderList
extends AbstractChunkRenderContainer {
    private double viewEntityX;
    private double viewEntityY;
    private double viewEntityZ;
    IntBuffer bufferLists = Config.createDirectIntBuffer(16);

    public void func_178001_a(BlockRenderLayer layer) {
        if (this.field_178007_b) {
            if (Config.isRenderRegions()) {
                int regionX = Integer.MIN_VALUE;
                int regionZ = Integer.MIN_VALUE;
                for (ChunkRender renderchunk : this.field_178009_a) {
                    ListedChunkRender listedrenderchunk = (ListedChunkRender)renderchunk;
                    if (regionX != renderchunk.regionX || regionZ != renderchunk.regionZ) {
                        if (this.bufferLists.position() > 0) {
                            this.drawRegion(regionX, regionZ, this.bufferLists);
                        }
                        regionX = renderchunk.regionX;
                        regionZ = renderchunk.regionZ;
                    }
                    if (this.bufferLists.position() >= this.bufferLists.capacity()) {
                        IntBuffer bufferListsNew = Config.createDirectIntBuffer(this.bufferLists.capacity() * 2);
                        this.bufferLists.flip();
                        bufferListsNew.put(this.bufferLists);
                        this.bufferLists = bufferListsNew;
                    }
                    this.bufferLists.put(listedrenderchunk.func_178600_a(layer, listedrenderchunk.func_178571_g()));
                }
                if (this.bufferLists.position() > 0) {
                    this.drawRegion(regionX, regionZ, this.bufferLists);
                }
            } else {
                for (ChunkRender chunkrender : this.field_178009_a) {
                    ListedChunkRender listedchunkrender = (ListedChunkRender)chunkrender;
                    GlStateManager.pushMatrix();
                    this.func_178003_a(chunkrender);
                    GlStateManager.callList((int)listedchunkrender.func_178600_a(layer, listedchunkrender.func_178571_g()));
                    GlStateManager.popMatrix();
                }
            }
            if (Config.isMultiTexture()) {
                GlStateManager.bindCurrentTexture();
            }
            GlStateManager.clearCurrentColor();
            this.field_178009_a.clear();
        }
    }

    public void func_178004_a(double viewEntityXIn, double viewEntityYIn, double viewEntityZIn) {
        this.viewEntityX = viewEntityXIn;
        this.viewEntityY = viewEntityYIn;
        this.viewEntityZ = viewEntityZIn;
        super.func_178004_a(viewEntityXIn, viewEntityYIn, viewEntityZIn);
    }

    private void drawRegion(int regionX, int regionZ, IntBuffer buffer) {
        GlStateManager.pushMatrix();
        this.preRenderRegion(regionX, 0, regionZ);
        buffer.flip();
        GlStateManager.callLists((IntBuffer)buffer);
        buffer.clear();
        GlStateManager.popMatrix();
    }

    public void preRenderRegion(int x, int y, int z) {
        GlStateManager.translatef((float)((float)((double)x - this.viewEntityX)), (float)((float)((double)y - this.viewEntityY)), (float)((float)((double)z - this.viewEntityZ)));
    }
}

