/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.IChunkRendererFactory;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.optifine.Config;
import net.optifine.render.VboRegion;

public class ViewFrustum {
    protected final WorldRenderer field_178169_a;
    protected final World field_178167_b;
    protected int field_178168_c;
    protected int field_178165_d;
    protected int field_178166_e;
    public ChunkRender[] field_178164_f;
    private Map<ChunkPos, VboRegion[]> mapVboRegions = new HashMap();

    public ViewFrustum(World p_i518_1_, int p_i518_2_, WorldRenderer p_i518_3_, IChunkRendererFactory p_i518_4_) {
        this.field_178169_a = p_i518_3_;
        this.field_178167_b = p_i518_1_;
        this.func_178159_a(p_i518_2_);
        this.func_178158_a(p_i518_4_);
    }

    protected void func_178158_a(IChunkRendererFactory renderChunkFactory) {
        int l2;
        int i = this.field_178165_d * this.field_178168_c * this.field_178166_e;
        this.field_178164_f = new ChunkRender[i];
        for (int j = 0; j < this.field_178165_d; ++j) {
            for (int k = 0; k < this.field_178168_c; ++k) {
                for (l2 = 0; l2 < this.field_178166_e; ++l2) {
                    int i1 = this.func_212478_a(j, k, l2);
                    this.field_178164_f[i1] = renderChunkFactory.create(this.field_178167_b, this.field_178169_a);
                    this.field_178164_f[i1].func_189562_a(j * 16, k * 16, l2 * 16);
                    if (!Config.isVbo() || !Config.isRenderRegions()) continue;
                    this.updateVboRegion(this.field_178164_f[i1]);
                }
            }
        }
        for (int k = 0; k < this.field_178164_f.length; ++k) {
            ChunkRender renderChunk = this.field_178164_f[k];
            for (l2 = 0; l2 < Direction.field_199792_n.length; ++l2) {
                Direction facing = Direction.field_199792_n[l2];
                BlockPos posOffset16 = renderChunk.func_181701_a(facing);
                ChunkRender neighbour = this.func_178161_a(posOffset16);
                renderChunk.setRenderChunkNeighbour(facing, neighbour);
            }
        }
    }

    public void func_178160_a() {
        for (ChunkRender chunkrender : this.field_178164_f) {
            chunkrender.func_178566_a();
        }
        this.deleteVboRegions();
    }

    private int func_212478_a(int x, int y, int z) {
        return (z * this.field_178168_c + y) * this.field_178165_d + x;
    }

    protected void func_178159_a(int renderDistanceChunks) {
        int i;
        this.field_178165_d = i = renderDistanceChunks * 2 + 1;
        this.field_178168_c = 16;
        this.field_178166_e = i;
    }

    public void func_178163_a(double viewEntityX, double viewEntityZ) {
        int i = MathHelper.func_76128_c((double)viewEntityX) - 8;
        int j = MathHelper.func_76128_c((double)viewEntityZ) - 8;
        int k = this.field_178165_d * 16;
        for (int l2 = 0; l2 < this.field_178165_d; ++l2) {
            int i1 = this.func_178157_a(i, k, l2);
            for (int j1 = 0; j1 < this.field_178166_e; ++j1) {
                int k1 = this.func_178157_a(j, k, j1);
                for (int l1 = 0; l1 < this.field_178168_c; ++l1) {
                    int i2 = l1 * 16;
                    ChunkRender chunkrender = this.field_178164_f[this.func_212478_a(l2, l1, j1)];
                    chunkrender.func_189562_a(i1, i2, k1);
                }
            }
        }
    }

    private int func_178157_a(int midBlocksIn, int countBlocksIn, int chunksIn) {
        int i = chunksIn * 16;
        int j = i - midBlocksIn + countBlocksIn / 2;
        if (j < 0) {
            j -= countBlocksIn - 1;
        }
        return i - j / countBlocksIn * countBlocksIn;
    }

    public void func_217628_a(int xIn, int yIn, int zIn, boolean p_217628_4_) {
        int i = Math.floorMod(xIn, this.field_178165_d);
        int j = Math.floorMod(yIn, this.field_178168_c);
        int k = Math.floorMod(zIn, this.field_178166_e);
        ChunkRender chunkrender = this.field_178164_f[this.func_212478_a(i, j, k)];
        chunkrender.func_178575_a(p_217628_4_);
    }

    @Nullable
    public ChunkRender func_178161_a(BlockPos pos) {
        int i = pos.func_177958_n() >> 4;
        int j = pos.func_177956_o() >> 4;
        int k = pos.func_177952_p() >> 4;
        if (j >= 0 && j < this.field_178168_c) {
            i = MathHelper.func_180184_b((int)i, (int)this.field_178165_d);
            k = MathHelper.func_180184_b((int)k, (int)this.field_178166_e);
            return this.field_178164_f[this.func_212478_a(i, j, k)];
        }
        return null;
    }

    private void updateVboRegion(ChunkRender renderChunk) {
        int ix;
        BlockPos pos = renderChunk.func_178568_j();
        int rx = pos.func_177958_n() >> 8 << 8;
        int rz = pos.func_177952_p() >> 8 << 8;
        ChunkPos cp = new ChunkPos(rx, rz);
        BlockRenderLayer[] layers = BlockRenderLayer.values();
        VboRegion[] regions = (VboRegion[])this.mapVboRegions.get(cp);
        if (regions == null) {
            regions = new VboRegion[layers.length];
            for (ix = 0; ix < layers.length; ++ix) {
                regions[ix] = new VboRegion(layers[ix]);
            }
            this.mapVboRegions.put(cp, regions);
        }
        for (ix = 0; ix < layers.length; ++ix) {
            VboRegion vr = regions[ix];
            if (vr == null) continue;
            renderChunk.func_178565_b(ix).setVboRegion(vr);
        }
    }

    public void deleteVboRegions() {
        Set keys = this.mapVboRegions.keySet();
        for (ChunkPos cp : keys) {
            VboRegion[] vboRegions = (VboRegion[])this.mapVboRegions.get(cp);
            for (int i = 0; i < vboRegions.length; ++i) {
                VboRegion vboRegion = vboRegions[i];
                if (vboRegion != null) {
                    vboRegion.deleteGlBuffers();
                }
                vboRegions[i] = null;
            }
        }
        this.mapVboRegions.clear();
    }
}

