/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GLX;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomBlockLayers;
import net.optifine.override.ChunkCacheOF;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.render.AabbFrame;
import net.optifine.render.RenderEnv;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.util.ChunkUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChunkRender {
    private final World field_178588_d;
    private final WorldRenderer field_178589_e;
    public static int field_178592_a;
    public CompiledChunk field_178590_b = CompiledChunk.field_178502_a;
    private final ReentrantLock field_178587_g = new ReentrantLock();
    private final ReentrantLock field_178598_h = new ReentrantLock();
    private ChunkRenderTask field_178599_i;
    private final Set<TileEntity> field_181056_j = Sets.newHashSet();
    private final VertexBuffer[] field_178594_l = new VertexBuffer[BlockRenderLayer.values().length];
    public AxisAlignedBB field_178591_c;
    private int field_178595_m = -1;
    private boolean field_178593_n = true;
    private final BlockPos.MutableBlockPos field_178586_f = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos[] field_181702_p = (BlockPos.MutableBlockPos[])Util.func_200696_a((Object)new BlockPos.MutableBlockPos[6], p_205125_0_ -> {
        for (int j = 0; j < ((BlockPos.MutableBlockPos[])p_205125_0_).length; ++j) {
            p_205125_0_[j] = new BlockPos.MutableBlockPos();
        }
    });
    private boolean field_188284_q;
    public static final BlockRenderLayer[] BLOCK_RENDER_LAYERS;
    private static final boolean FORGE_BLOCK_CAN_RENDER_IN_LAYER;
    private static final boolean FORGE_FLUID_CAN_RENDER_IN_LAYER;
    private static final boolean FORGE_SET_RENDER_LAYER;
    private final boolean isMipmaps = Config.isMipmaps();
    private final boolean fixBlockLayer = !Reflector.BetterFoliageClient.exists();
    private boolean playerUpdate = false;
    public int regionX;
    public int regionZ;
    private final ChunkRender[] renderChunksOfset16 = new ChunkRender[6];
    private boolean renderChunksOffset16Updated = false;
    private Chunk chunk;
    private ChunkRender[] renderChunkNeighbours = new ChunkRender[Direction.field_199792_n.length];
    private ChunkRender[] renderChunkNeighboursValid = new ChunkRender[Direction.field_199792_n.length];
    private boolean renderChunkNeighboursUpated = false;
    private WorldRenderer.LocalRenderInformationContainer renderInfo = new WorldRenderer.LocalRenderInformationContainer(this, null, 0);
    public AabbFrame boundingBoxParent;

    public ChunkRender(World p_i561_1_, WorldRenderer p_i561_2_) {
        this.field_178588_d = p_i561_1_;
        this.field_178589_e = p_i561_2_;
        if (GLX.useVbo()) {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                this.field_178594_l[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            }
        }
    }

    private static boolean func_217673_a(BlockPos pos, World world) {
        return !world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_76621_g();
    }

    public boolean func_217674_b() {
        int i = 24;
        if (this.func_188280_f() <= 576.0) {
            return true;
        }
        World world = this.func_188283_p();
        return ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.WEST.ordinal()], (World)world) && ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.NORTH.ordinal()], (World)world) && ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.EAST.ordinal()], (World)world) && ChunkRender.func_217673_a((BlockPos)this.field_181702_p[Direction.SOUTH.ordinal()], (World)world);
    }

    public boolean func_178577_a(int frameIndexIn) {
        if (this.field_178595_m == frameIndexIn) {
            return false;
        }
        this.field_178595_m = frameIndexIn;
        return true;
    }

    public VertexBuffer func_178565_b(int layer) {
        return this.field_178594_l[layer];
    }

    public void func_189562_a(int x, int y, int z) {
        if (x != this.field_178586_f.func_177958_n() || y != this.field_178586_f.func_177956_o() || z != this.field_178586_f.func_177952_p()) {
            this.func_178585_h();
            this.field_178586_f.func_181079_c(x, y, z);
            int bits = 8;
            this.regionX = x >> bits << bits;
            this.regionZ = z >> bits << bits;
            this.field_178591_c = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + 16), (double)(z + 16));
            for (Direction direction : Direction.field_199792_n) {
                this.field_181702_p[direction.ordinal()].func_189533_g((Vec3i)this.field_178586_f).func_189534_c(direction, 16);
            }
            this.renderChunksOffset16Updated = false;
            this.renderChunkNeighboursUpated = false;
            for (int i = 0; i < this.renderChunkNeighbours.length; ++i) {
                ChunkRender neighbour = this.renderChunkNeighbours[i];
                if (neighbour == null) continue;
                neighbour.renderChunkNeighboursUpated = false;
            }
            this.chunk = null;
            this.boundingBoxParent = null;
        }
    }

    public void func_178570_a(float x, float y, float z, ChunkRenderTask generator) {
        CompiledChunk compiledchunk = generator.func_178544_c();
        if (compiledchunk.func_178487_c() != null && !compiledchunk.func_178491_b(BlockRenderLayer.TRANSLUCENT)) {
            BufferBuilder bufferTranslucent = generator.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT);
            this.func_178573_a(bufferTranslucent, (BlockPos)this.field_178586_f);
            bufferTranslucent.func_178993_a(compiledchunk.func_178487_c());
            this.func_178584_a(BlockRenderLayer.TRANSLUCENT, x, y, z, bufferTranslucent, compiledchunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_178581_b(float x, float y, float z, ChunkRenderTask generator) {
        CompiledChunk compiledchunk = new CompiledChunk();
        boolean i = true;
        BlockPos blockpos = this.field_178586_f.func_185334_h();
        BlockPos blockpos1 = blockpos.func_177982_a(15, 15, 15);
        World world = this.field_178588_d;
        if (world != null) {
            generator.func_178540_f().lock();
            try {
                if (generator.func_178546_a() != ChunkRenderTask.Status.COMPILING) {
                    return;
                }
                generator.func_178543_a(compiledchunk);
            }
            finally {
                generator.func_178540_f().unlock();
            }
            VisGraph lvt_10_1_ = new VisGraph();
            HashSet lvt_11_1_ = Sets.newHashSet();
            ChunkCacheOF lvt_12_1_ = null;
            if (!this.isChunkRegionEmpty(blockpos)) {
                ChunkCacheOF blockAccess;
                ++field_178592_a;
                lvt_12_1_ = blockAccess = this.makeChunkCacheOF(blockpos);
                blockAccess.renderStart();
                BlockRenderLayer[] singleLayer = new BlockRenderLayer[1];
                boolean[] aboolean = new boolean[BLOCK_RENDER_LAYERS.length];
                BlockModelRenderer.func_211847_a();
                Random random = new Random();
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                for (BlockPosM blockpos2 : BlockPosM.getAllInBoxMutable((BlockPos)blockpos, (BlockPos)blockpos1)) {
                    RenderEnv renderEnv;
                    int ix;
                    IFluidState ifluidstate;
                    TileEntityRenderer tileentityrenderer;
                    TileEntity tileentity;
                    BlockState blockstate = lvt_12_1_.func_180495_p((BlockPos)blockpos2);
                    Block block = blockstate.func_177230_c();
                    if (blockstate.func_200015_d((IBlockReader)lvt_12_1_, (BlockPos)blockpos2)) {
                        lvt_10_1_.func_178606_a((BlockPos)blockpos2);
                    }
                    if (ReflectorForge.blockHasTileEntity((BlockState)blockstate) && (tileentity = lvt_12_1_.getTileEntity((BlockPos)blockpos2, Chunk.CreateEntityType.CHECK)) != null && (tileentityrenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileentity)) != null) {
                        if (tileentityrenderer.func_188185_a(tileentity)) {
                            lvt_11_1_.add(tileentity);
                        } else {
                            compiledchunk.func_178490_a(tileentity);
                        }
                    }
                    if (!(ifluidstate = blockstate.func_204520_s()).func_206888_e()) {
                        BlockRenderLayer[] fluidLayers = this.getFluidRenderLayers(ifluidstate, singleLayer);
                        for (ix = 0; ix < fluidLayers.length; ++ix) {
                            BlockRenderLayer blockrenderlayer1 = fluidLayers[ix];
                            if (FORGE_FLUID_CAN_RENDER_IN_LAYER && !Reflector.callBoolean(ifluidstate, Reflector.ForgeIFluidState_canRenderInLayer, blockrenderlayer1)) continue;
                            if (FORGE_SET_RENDER_LAYER) {
                                Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, blockrenderlayer1);
                            }
                            int j = blockrenderlayer1.ordinal();
                            BufferBuilder bufferbuilder = generator.func_178545_d().func_179039_a(j);
                            bufferbuilder.setBlockLayer(blockrenderlayer1);
                            renderEnv = bufferbuilder.getRenderEnv(blockstate, (BlockPos)blockpos2);
                            renderEnv.setRegionRenderCacheBuilder(generator.func_178545_d());
                            blockAccess.setRenderEnv(renderEnv);
                            if (!compiledchunk.func_178492_d(blockrenderlayer1)) {
                                compiledchunk.func_178493_c(blockrenderlayer1);
                                this.func_178573_a(bufferbuilder, blockpos);
                            }
                            int n = j;
                            aboolean[n] = aboolean[n] | blockrendererdispatcher.func_215331_a((BlockPos)blockpos2, (IEnviromentBlockReader)lvt_12_1_, bufferbuilder, ifluidstate);
                        }
                    }
                    if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
                        BlockRenderLayer[] blockLayers = this.getBlockRenderLayers(blockstate, singleLayer);
                        for (ix = 0; ix < blockLayers.length; ++ix) {
                            BlockRenderLayer blockrenderlayer2 = blockLayers[ix];
                            if (FORGE_BLOCK_CAN_RENDER_IN_LAYER && !Reflector.callBoolean(blockstate, Reflector.ForgeIBlockState_canRenderInLayer, blockrenderlayer2)) continue;
                            if (FORGE_SET_RENDER_LAYER) {
                                Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, blockrenderlayer2);
                            }
                            blockrenderlayer2 = this.fixBlockLayer((IEnviromentBlockReader)blockAccess, blockstate, (BlockPos)blockpos2, blockrenderlayer2);
                            int k = blockrenderlayer2.ordinal();
                            BufferBuilder bufferbuilder1 = generator.func_178545_d().func_179039_a(k);
                            bufferbuilder1.setBlockLayer(blockrenderlayer2);
                            renderEnv = bufferbuilder1.getRenderEnv(blockstate, (BlockPos)blockpos2);
                            renderEnv.setRegionRenderCacheBuilder(generator.func_178545_d());
                            blockAccess.setRenderEnv(renderEnv);
                            if (!compiledchunk.func_178492_d(blockrenderlayer2)) {
                                compiledchunk.func_178493_c(blockrenderlayer2);
                                this.func_178573_a(bufferbuilder1, blockpos);
                            }
                            int n = k;
                            aboolean[n] = aboolean[n] | blockrendererdispatcher.func_215330_a(blockstate, (BlockPos)blockpos2, (IEnviromentBlockReader)lvt_12_1_, bufferbuilder1, random);
                            if (!renderEnv.isOverlaysRendered()) continue;
                            this.postRenderOverlays(generator.func_178545_d(), compiledchunk, aboolean);
                            renderEnv.setOverlaysRendered(false);
                        }
                    }
                    if (!FORGE_SET_RENDER_LAYER) continue;
                    Reflector.callVoid(Reflector.ForgeHooksClient_setRenderLayer, new Object[]{null});
                }
                for (BlockRenderLayer blockrenderlayer : BLOCK_RENDER_LAYERS) {
                    if (aboolean[blockrenderlayer.ordinal()]) {
                        compiledchunk.func_178486_a(blockrenderlayer);
                    }
                    if (compiledchunk.func_178492_d(blockrenderlayer)) {
                        if (Config.isShaders()) {
                            SVertexBuilder.calcNormalChunkLayer((BufferBuilder)generator.func_178545_d().func_179038_a(blockrenderlayer));
                        }
                        BufferBuilder bufferBuilder = generator.func_178545_d().func_179038_a(blockrenderlayer);
                        this.func_178584_a(blockrenderlayer, x, y, z, bufferBuilder, compiledchunk);
                        if (bufferBuilder.animatedSprites == null) continue;
                        compiledchunk.setAnimatedSprites(blockrenderlayer, (BitSet)bufferBuilder.animatedSprites.clone());
                        continue;
                    }
                    compiledchunk.setAnimatedSprites(blockrenderlayer, null);
                }
                blockAccess.renderFinish();
                BlockModelRenderer.func_210266_a();
            }
            compiledchunk.func_178488_a(lvt_10_1_.func_178607_a());
            this.field_178587_g.lock();
            try {
                HashSet set = Sets.newHashSet((Iterable)lvt_11_1_);
                HashSet set1 = Sets.newHashSet((Iterable)this.field_181056_j);
                set.removeAll(this.field_181056_j);
                set1.removeAll(lvt_11_1_);
                this.field_181056_j.clear();
                this.field_181056_j.addAll(lvt_11_1_);
                this.field_178589_e.func_181023_a((Collection)set1, (Collection)set);
            }
            finally {
                this.field_178587_g.unlock();
            }
        }
    }

    protected void func_178578_b() {
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                this.field_178599_i.func_178542_e();
                this.field_178599_i = null;
            }
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    public ReentrantLock func_178579_c() {
        return this.field_178587_g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkRenderTask func_178574_d() {
        ChunkRenderTask chunkrendertask;
        this.field_178587_g.lock();
        try {
            this.func_178578_b();
            BlockPos blockpos = this.field_178586_f.func_185334_h();
            boolean i = true;
            ChunkRenderCache chunkrendercache = null;
            chunkrendertask = this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.REBUILD_CHUNK, this.func_188280_f(), chunkrendercache);
        }
        finally {
            this.field_178587_g.unlock();
        }
        return chunkrendertask;
    }

    @Nullable
    public ChunkRenderTask func_178582_e() {
        ChunkRenderTask chunkrendertask;
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i == null || this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.PENDING) {
                ChunkRenderTask chunkrendertask2;
                if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                    this.field_178599_i.func_178542_e();
                    this.field_178599_i = null;
                }
                this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.RESORT_TRANSPARENCY, this.func_188280_f(), (ChunkRenderCache)null);
                this.field_178599_i.func_178543_a(this.field_178590_b);
                ChunkRenderTask chunkRenderTask = chunkrendertask2 = this.field_178599_i;
                return chunkRenderTask;
            }
            chunkrendertask = null;
        }
        finally {
            this.field_178587_g.unlock();
        }
        return chunkrendertask;
    }

    protected double func_188280_f() {
        ActiveRenderInfo activerenderinfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        double d0 = this.field_178591_c.field_72340_a + 8.0 - activerenderinfo.func_216785_c().field_72450_a;
        double d1 = this.field_178591_c.field_72338_b + 8.0 - activerenderinfo.func_216785_c().field_72448_b;
        double d2 = this.field_178591_c.field_72339_c + 8.0 - activerenderinfo.func_216785_c().field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    private void func_178573_a(BufferBuilder bufferBuilderIn, BlockPos pos) {
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (Config.isRenderRegions()) {
            int bits = 8;
            int dx = pos.func_177958_n() >> bits << bits;
            int dy = pos.func_177956_o() >> bits << bits;
            int dz = pos.func_177952_p() >> bits << bits;
            dx = this.regionX;
            dz = this.regionZ;
            bufferBuilderIn.func_178969_c((double)(-dx), (double)(-dy), (double)(-dz));
        } else {
            bufferBuilderIn.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        }
    }

    private void func_178584_a(BlockRenderLayer layer, float x, float y, float z, BufferBuilder bufferBuilderIn, CompiledChunk compiledChunkIn) {
        if (layer == BlockRenderLayer.TRANSLUCENT && !compiledChunkIn.func_178491_b(layer)) {
            bufferBuilderIn.func_181674_a(x, y, z);
            compiledChunkIn.func_178494_a(bufferBuilderIn.func_181672_a());
        }
        bufferBuilderIn.func_178977_d();
    }

    public CompiledChunk func_178571_g() {
        return this.field_178590_b;
    }

    public void func_178580_a(CompiledChunk compiledChunkIn) {
        this.field_178598_h.lock();
        try {
            this.field_178590_b = compiledChunkIn;
        }
        finally {
            this.field_178598_h.unlock();
        }
    }

    public void func_178585_h() {
        this.func_178578_b();
        this.field_178590_b = CompiledChunk.field_178502_a;
        this.field_178593_n = true;
    }

    public void func_178566_a() {
        this.func_178585_h();
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            if (this.field_178594_l[i] == null) continue;
            this.field_178594_l[i].func_177362_c();
        }
    }

    public BlockPos func_178568_j() {
        return this.field_178586_f;
    }

    public void func_178575_a(boolean immediate) {
        if (this.field_178593_n) {
            immediate |= this.field_188284_q;
        }
        this.field_178593_n = true;
        this.field_188284_q = immediate;
        if (this.isWorldPlayerUpdate()) {
            this.playerUpdate = true;
        }
    }

    public void func_188282_m() {
        this.field_178593_n = false;
        this.field_188284_q = false;
        this.playerUpdate = false;
    }

    public boolean func_178569_m() {
        return this.field_178593_n;
    }

    public boolean func_188281_o() {
        return this.field_178593_n && this.field_188284_q;
    }

    public BlockPos func_181701_a(Direction facing) {
        return this.field_181702_p[facing.ordinal()];
    }

    public World func_188283_p() {
        return this.field_178588_d;
    }

    private boolean isWorldPlayerUpdate() {
        if (this.field_178588_d instanceof ClientWorld) {
            ClientWorld worldClient = (ClientWorld)this.field_178588_d;
            return worldClient.isPlayerUpdate();
        }
        return false;
    }

    public boolean isPlayerUpdate() {
        return this.playerUpdate;
    }

    private BlockRenderLayer[] getFluidRenderLayers(IFluidState fluidState, BlockRenderLayer[] singleLayer) {
        if (FORGE_FLUID_CAN_RENDER_IN_LAYER) {
            return BLOCK_RENDER_LAYERS;
        }
        singleLayer[0] = fluidState.func_180664_k();
        return singleLayer;
    }

    private BlockRenderLayer[] getBlockRenderLayers(BlockState blockState, BlockRenderLayer[] singleLayer) {
        if (FORGE_BLOCK_CAN_RENDER_IN_LAYER) {
            return BLOCK_RENDER_LAYERS;
        }
        singleLayer[0] = blockState.func_177230_c().func_180664_k();
        return singleLayer;
    }

    private BlockRenderLayer fixBlockLayer(IEnviromentBlockReader worldReader, BlockState blockState, BlockPos blockPos, BlockRenderLayer layer) {
        BlockRenderLayer layerCustom;
        if (CustomBlockLayers.isActive() && (layerCustom = CustomBlockLayers.getRenderLayer((IEnviromentBlockReader)worldReader, (BlockState)blockState, (BlockPos)blockPos)) != null) {
            return layerCustom;
        }
        if (!this.fixBlockLayer) {
            return layer;
        }
        if (this.isMipmaps) {
            if (layer == BlockRenderLayer.CUTOUT) {
                Block block = blockState.func_177230_c();
                if (block instanceof RedstoneWireBlock) {
                    return layer;
                }
                if (block instanceof CactusBlock) {
                    return layer;
                }
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
        } else if (layer == BlockRenderLayer.CUTOUT_MIPPED) {
            return BlockRenderLayer.CUTOUT;
        }
        return layer;
    }

    private void postRenderOverlays(RegionRenderCacheBuilder regionRenderCacheBuilder, CompiledChunk compiledChunk, boolean[] layerFlags) {
        this.postRenderOverlay(BlockRenderLayer.CUTOUT, regionRenderCacheBuilder, compiledChunk, layerFlags);
        this.postRenderOverlay(BlockRenderLayer.CUTOUT_MIPPED, regionRenderCacheBuilder, compiledChunk, layerFlags);
        this.postRenderOverlay(BlockRenderLayer.TRANSLUCENT, regionRenderCacheBuilder, compiledChunk, layerFlags);
    }

    private void postRenderOverlay(BlockRenderLayer layer, RegionRenderCacheBuilder regionRenderCacheBuilder, CompiledChunk compiledchunk, boolean[] layerFlags) {
        BufferBuilder bufferOverlay = regionRenderCacheBuilder.func_179038_a(layer);
        if (bufferOverlay.isDrawing()) {
            compiledchunk.func_178493_c(layer);
            layerFlags[layer.ordinal()] = true;
        }
    }

    private ChunkCacheOF makeChunkCacheOF(BlockPos posIn) {
        BlockPos posFrom = posIn.func_177982_a(-1, -1, -1);
        BlockPos posTo = posIn.func_177982_a(16, 16, 16);
        ChunkRenderCache chunkCache = ChunkRender.createRegionRenderCache((World)this.field_178588_d, (BlockPos)posFrom, (BlockPos)posTo, (int)1);
        if (Reflector.MinecraftForgeClient_onRebuildChunk.exists()) {
            Reflector.call(Reflector.MinecraftForgeClient_onRebuildChunk, this.field_178588_d, posIn, chunkCache);
        }
        ChunkCacheOF chunkCacheOF = new ChunkCacheOF(chunkCache, posFrom, posTo, 1);
        return chunkCacheOF;
    }

    private static ChunkRenderCache createRegionRenderCache(World world, BlockPos posFrom, BlockPos posTo, int i) {
        return ChunkRenderCache.generateCache((World)world, (BlockPos)posFrom, (BlockPos)posTo, (int)i, (boolean)false);
    }

    public ChunkRender getRenderChunkOffset16(ViewFrustum viewFrustum, Direction facing) {
        if (!this.renderChunksOffset16Updated) {
            for (int i = 0; i < Direction.field_199792_n.length; ++i) {
                Direction ef = Direction.field_199792_n[i];
                BlockPos posOffset16 = this.func_181701_a(ef);
                this.renderChunksOfset16[i] = viewFrustum.func_178161_a(posOffset16);
            }
            this.renderChunksOffset16Updated = true;
        }
        return this.renderChunksOfset16[facing.ordinal()];
    }

    public Chunk getChunk() {
        return this.getChunk((BlockPos)this.field_178586_f);
    }

    private Chunk getChunk(BlockPos posIn) {
        Chunk chunkLocal = this.chunk;
        if (chunkLocal != null && ChunkUtils.isLoaded((Chunk)chunkLocal)) {
            return chunkLocal;
        }
        this.chunk = chunkLocal = this.field_178588_d.func_175726_f(posIn);
        return chunkLocal;
    }

    public boolean isChunkRegionEmpty() {
        return this.isChunkRegionEmpty((BlockPos)this.field_178586_f);
    }

    private boolean isChunkRegionEmpty(BlockPos posIn) {
        int yStart = posIn.func_177956_o();
        int yEnd = yStart + 15;
        return this.getChunk(posIn).func_76606_c(yStart, yEnd);
    }

    public void setRenderChunkNeighbour(Direction facing, ChunkRender neighbour) {
        this.renderChunkNeighbours[facing.ordinal()] = neighbour;
        this.renderChunkNeighboursValid[facing.ordinal()] = neighbour;
    }

    public ChunkRender getRenderChunkNeighbour(Direction facing) {
        if (!this.renderChunkNeighboursUpated) {
            this.updateRenderChunkNeighboursValid();
        }
        return this.renderChunkNeighboursValid[facing.ordinal()];
    }

    public WorldRenderer.LocalRenderInformationContainer getRenderInfo() {
        return this.renderInfo;
    }

    private void updateRenderChunkNeighboursValid() {
        int x = this.func_178568_j().func_177958_n();
        int z = this.func_178568_j().func_177952_p();
        int north = Direction.NORTH.ordinal();
        int south = Direction.SOUTH.ordinal();
        int west = Direction.WEST.ordinal();
        int east = Direction.EAST.ordinal();
        this.renderChunkNeighboursValid[north] = this.renderChunkNeighbours[north].func_178568_j().func_177952_p() == z - 16 ? this.renderChunkNeighbours[north] : null;
        this.renderChunkNeighboursValid[south] = this.renderChunkNeighbours[south].func_178568_j().func_177952_p() == z + 16 ? this.renderChunkNeighbours[south] : null;
        this.renderChunkNeighboursValid[west] = this.renderChunkNeighbours[west].func_178568_j().func_177958_n() == x - 16 ? this.renderChunkNeighbours[west] : null;
        this.renderChunkNeighboursValid[east] = this.renderChunkNeighbours[east].func_178568_j().func_177958_n() == x + 16 ? this.renderChunkNeighbours[east] : null;
        this.renderChunkNeighboursUpated = true;
    }

    public boolean isBoundingBoxInFrustum(ICamera camera, int frameCount) {
        if (this.getBoundingBoxParent().isBoundingBoxInFrustumFully(camera, frameCount)) {
            return true;
        }
        return camera.func_78546_a(this.field_178591_c);
    }

    public AabbFrame getBoundingBoxParent() {
        if (this.boundingBoxParent == null) {
            AabbFrame bbp;
            BlockPos pos = this.func_178568_j();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int bits = 5;
            int xp = x >> bits << bits;
            int yp = y >> bits << bits;
            int zp = z >> bits << bits;
            if ((xp != x || yp != y || zp != z) && (bbp = this.field_178589_e.getRenderChunk(new BlockPos(xp, yp, zp)).getBoundingBoxParent()) != null && bbp.field_72340_a == (double)xp && bbp.field_72338_b == (double)yp && bbp.field_72339_c == (double)zp) {
                this.boundingBoxParent = bbp;
            }
            if (this.boundingBoxParent == null) {
                int delta = 1 << bits;
                this.boundingBoxParent = new AabbFrame(xp, yp, zp, xp + delta, yp + delta, zp + delta);
            }
        }
        return this.boundingBoxParent;
    }

    public String toString() {
        return "pos: " + this.func_178568_j() + ", frameIndex: " + this.field_178595_m;
    }

    static {
        BLOCK_RENDER_LAYERS = BlockRenderLayer.values();
        FORGE_BLOCK_CAN_RENDER_IN_LAYER = Reflector.ForgeIBlockState_canRenderInLayer.exists();
        FORGE_FLUID_CAN_RENDER_IN_LAYER = Reflector.ForgeIFluidState_canRenderInLayer.exists();
        FORGE_SET_RENDER_LAYER = Reflector.ForgeHooksClient_setRenderLayer.exists();
    }
}

