/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.ChunkRenderWorker;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.ListedChunkRender;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Util;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChunkRenderDispatcher {
    private static final Logger field_178523_a = LogManager.getLogger();
    private static final ThreadFactory field_178521_b = new ThreadFactoryBuilder().setNameFormat("Chunk Batcher %d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_178523_a)).build();
    private final int field_188249_c;
    private final List<Thread> field_188250_d = Lists.newArrayList();
    private final List<ChunkRenderWorker> field_178522_c = Lists.newArrayList();
    private final PriorityBlockingQueue<ChunkRenderTask> field_178519_d = Queues.newPriorityBlockingQueue();
    private final BlockingQueue<RegionRenderCacheBuilder> field_178520_e;
    private final WorldVertexBufferUploader field_178517_f = new WorldVertexBufferUploader();
    private final VertexBufferUploader field_178518_g = new VertexBufferUploader();
    private final Queue<PendingUpload> field_178524_h = Queues.newPriorityQueue();
    private final ChunkRenderWorker field_178525_i;
    private Vec3d field_217672_l = Vec3d.field_186680_a;

    public ChunkRenderDispatcher(boolean p_i559_1_) {
        int i = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / 0xA00000 - 1);
        int j = Runtime.getRuntime().availableProcessors();
        int k = p_i559_1_ ? j : Math.min(j, 4);
        int l2 = Math.max(1, Math.min(k * 3, i));
        this.field_178525_i = new ChunkRenderWorker(this, new RegionRenderCacheBuilder());
        ArrayList list = Lists.newArrayListWithExpectedSize((int)l2);
        try {
            for (int i1 = 0; i1 < l2; ++i1) {
                list.add(new RegionRenderCacheBuilder());
            }
        }
        catch (OutOfMemoryError var11) {
            field_178523_a.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l2);
            int j1 = list.size() * 2 / 3;
            for (int k1 = 0; k1 < j1; ++k1) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.field_188249_c = list.size();
        this.field_178520_e = Queues.newArrayBlockingQueue((int)this.field_188249_c);
        this.field_178520_e.addAll(list);
        int l1 = Math.min(k, this.field_188249_c);
        if (l1 > 1) {
            for (int i2 = 0; i2 < l1; ++i2) {
                ChunkRenderWorker chunkrenderworker = new ChunkRenderWorker(this);
                Thread thread = field_178521_b.newThread((Runnable)chunkrenderworker);
                thread.start();
                this.field_178522_c.add(chunkrenderworker);
                this.field_188250_d.add(thread);
            }
        }
    }

    public String func_178504_a() {
        return this.field_188250_d.isEmpty() ? String.format("pC: %03d, single-threaded", this.field_178519_d.size()) : String.format("pC: %03d, pU: %02d, aB: %02d", this.field_178519_d.size(), this.field_178524_h.size(), this.field_178520_e.size());
    }

    public void func_217669_a(Vec3d posIn) {
        this.field_217672_l = posIn;
    }

    public Vec3d func_217671_b() {
        return this.field_217672_l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178516_a(long finishTimeNano) {
        boolean flag1;
        boolean flag = false;
        do {
            ChunkRenderTask chunkrendertask;
            flag1 = false;
            if (this.field_188250_d.isEmpty() && (chunkrendertask = (ChunkRenderTask)this.field_178519_d.poll()) != null) {
                try {
                    this.field_178525_i.func_178474_a(chunkrendertask);
                    flag1 = true;
                }
                catch (InterruptedException var8) {
                    field_178523_a.warn("Skipped task due to interrupt");
                }
            }
            PendingUpload pendingUpload = null;
            Queue queue = this.field_178524_h;
            synchronized (queue) {
                pendingUpload = (PendingUpload)this.field_178524_h.poll();
            }
            if (pendingUpload == null) continue;
            PendingUpload.access$000((PendingUpload)pendingUpload).run();
            flag1 = true;
            flag = true;
        } while (finishTimeNano != 0L && flag1 && finishTimeNano >= Util.func_211178_c());
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178507_a(ChunkRender chunkRenderer) {
        boolean flag1;
        chunkRenderer.func_178579_c().lock();
        try {
            ChunkRenderTask chunkrendertask = chunkRenderer.func_178574_d();
            chunkrendertask.func_178539_a(() -> this.field_178519_d.remove(chunkrendertask));
            boolean flag = this.field_178519_d.offer(chunkrendertask);
            if (!flag) {
                chunkrendertask.func_178542_e();
            }
            flag1 = flag;
        }
        finally {
            chunkRenderer.func_178579_c().unlock();
        }
        return flag1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178505_b(ChunkRender chunkRenderer) {
        boolean flag;
        chunkRenderer.func_178579_c().lock();
        try {
            ChunkRenderTask chunkrendertask = chunkRenderer.func_178574_d();
            try {
                this.field_178525_i.func_178474_a(chunkrendertask);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            flag = true;
        }
        finally {
            chunkRenderer.func_178579_c().unlock();
        }
        return flag;
    }

    public void func_178514_b() {
        this.func_178513_e();
        ArrayList list = Lists.newArrayList();
        while (list.size() != this.field_188249_c) {
            this.func_178516_a(Long.MAX_VALUE);
            try {
                list.add(this.func_178515_c());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.field_178520_e.addAll(list);
    }

    public void func_178512_a(RegionRenderCacheBuilder builder) {
        this.field_178520_e.add(builder);
    }

    public RegionRenderCacheBuilder func_178515_c() throws InterruptedException {
        return (RegionRenderCacheBuilder)this.field_178520_e.take();
    }

    public ChunkRenderTask func_178511_d() throws InterruptedException {
        return (ChunkRenderTask)this.field_178519_d.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178509_c(ChunkRender chunkRenderer) {
        boolean flag;
        chunkRenderer.func_178579_c().lock();
        try {
            ChunkRenderTask chunkrendertask = chunkRenderer.func_178582_e();
            if (chunkrendertask == null) {
                boolean flag2;
                boolean bl = flag2 = true;
                return bl;
            }
            chunkrendertask.func_178539_a(() -> this.field_178519_d.remove(chunkrendertask));
            flag = this.field_178519_d.offer(chunkrendertask);
        }
        finally {
            chunkRenderer.func_178579_c().unlock();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Object> func_188245_a(BlockRenderLayer layerIn, BufferBuilder builderIn, ChunkRender renderChunkIn, CompiledChunk compiledChunkIn, double distanceSqIn) {
        if (Minecraft.func_71410_x().func_213162_bc()) {
            if (GLX.useVbo()) {
                this.func_178506_a(builderIn, renderChunkIn.func_178565_b(layerIn.ordinal()));
            } else {
                this.func_217670_a(builderIn, ((ListedChunkRender)renderChunkIn).func_178600_a(layerIn, compiledChunkIn));
            }
            builderIn.func_178969_c(0.0, 0.0, 0.0);
            return Futures.immediateFuture(null);
        }
        ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(() -> this.func_188245_a(layerIn, builderIn, renderChunkIn, compiledChunkIn, distanceSqIn), null);
        Queue queue = this.field_178524_h;
        synchronized (queue) {
            this.field_178524_h.add(new PendingUpload(this, listenablefuturetask, distanceSqIn));
            return listenablefuturetask;
        }
    }

    private void func_217670_a(BufferBuilder bufferBuilderIn, int list) {
        GlStateManager.newList((int)list, (int)4864);
        this.field_178517_f.func_181679_a(bufferBuilderIn);
        GlStateManager.endList();
    }

    private void func_178506_a(BufferBuilder bufferBuilderIn, VertexBuffer vertexBufferIn) {
        this.field_178518_g.func_178178_a(vertexBufferIn);
        this.field_178518_g.func_181679_a(bufferBuilderIn);
    }

    public void func_178513_e() {
        while (!this.field_178519_d.isEmpty()) {
            ChunkRenderTask chunkrendertask = (ChunkRenderTask)this.field_178519_d.poll();
            if (chunkrendertask == null) continue;
            chunkrendertask.func_178542_e();
        }
    }

    public boolean func_188247_f() {
        return this.field_178519_d.isEmpty() && this.field_178524_h.isEmpty();
    }

    public void func_188244_g() {
        this.func_178513_e();
        for (ChunkRenderWorker chunkrenderworker : this.field_178522_c) {
            chunkrenderworker.func_188264_a();
        }
        for (Thread thread : this.field_188250_d) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedexception) {
                field_178523_a.warn("Interrupted whilst waiting for worker to die", (Throwable)interruptedexception);
            }
        }
        this.field_178520_e.clear();
    }
}

