/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.shaders.Shaders;

public abstract class EntityRenderer<T extends Entity>
implements IEntityRenderer {
    private static final ResourceLocation field_110778_a = new ResourceLocation("textures/misc/shadow.png");
    protected final EntityRendererManager field_76990_c;
    public float field_76989_e;
    protected float field_76987_f = 1.0f;
    protected boolean field_188301_f;
    private Class entityClass = null;
    private ResourceLocation locationTextureCustom = null;

    protected EntityRenderer(EntityRendererManager p_i443_1_) {
        this.field_76990_c = p_i443_1_;
    }

    public void func_188297_a(boolean renderOutlinesIn) {
        this.field_188301_f = renderOutlinesIn;
    }

    public boolean func_177071_a(T livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (!livingEntity.func_145770_h(camX, camY, camZ)) {
            return false;
        }
        if (((Entity)livingEntity).field_70158_ak) {
            return true;
        }
        AxisAlignedBB axisalignedbb = livingEntity.func_184177_bl().func_186662_g(0.5);
        if (axisalignedbb.func_181656_b() || axisalignedbb.func_72320_b() == 0.0) {
            axisalignedbb = new AxisAlignedBB(((Entity)livingEntity).field_70165_t - 2.0, ((Entity)livingEntity).field_70163_u - 2.0, ((Entity)livingEntity).field_70161_v - 2.0, ((Entity)livingEntity).field_70165_t + 2.0, ((Entity)livingEntity).field_70163_u + 2.0, ((Entity)livingEntity).field_70161_v + 2.0);
        }
        return camera.func_78546_a(axisalignedbb);
    }

    public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!this.field_188301_f) {
            this.func_177067_a(entity, x, y, z);
        }
    }

    protected int func_188298_c(T entityIn) {
        ScorePlayerTeam scoreplayerteam = (ScorePlayerTeam)entityIn.func_96124_cp();
        return scoreplayerteam != null && scoreplayerteam.func_178775_l().func_211163_e() != null ? scoreplayerteam.func_178775_l().func_211163_e() : 0xFFFFFF;
    }

    protected void func_177067_a(T entity, double x, double y, double z) {
        if (this.func_177070_b(entity)) {
            this.func_147906_a(entity, entity.func_145748_c_().func_150254_d(), x, y, z, 64);
        }
    }

    protected boolean func_177070_b(T entity) {
        return entity.func_94059_bO() && entity.func_145818_k_();
    }

    protected void func_188296_a(T entityIn, double x, double y, double z, String name, double distanceSq) {
        this.func_147906_a(entityIn, name, x, y, z, 64);
    }

    @Nullable
    protected abstract ResourceLocation func_110775_a(T var1);

    protected boolean func_180548_c(T entity) {
        ResourceLocation resourcelocation = this.func_110775_a(entity);
        if (this.locationTextureCustom != null) {
            resourcelocation = this.locationTextureCustom;
        }
        if (resourcelocation == null) {
            return false;
        }
        this.func_110776_a(resourcelocation);
        return true;
    }

    public void func_110776_a(ResourceLocation location) {
        this.field_76990_c.field_78724_e.func_110577_a(location);
    }

    private void func_76977_a(Entity entity, double x, double y, double z, float partialTicks) {
        GlStateManager.disableLighting();
        AtlasTexture atlastexture = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite textureatlassprite = atlastexture.func_195424_a(ModelBakery.field_207763_a);
        TextureAtlasSprite textureatlassprite1 = atlastexture.func_195424_a(ModelBakery.field_207764_b);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        float f = entity.func_213311_cf() * 1.4f;
        GlStateManager.scalef((float)f, (float)f, (float)f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = entity.func_213302_cg() / f;
        float f4 = (float)(entity.field_70163_u - entity.func_174813_aQ().field_72338_b);
        GlStateManager.rotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f3) * 0.02f));
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f5 = 0.0f;
        int i = 0;
        boolean multitexture = Config.isMultiTexture();
        if (multitexture) {
            bufferbuilder.setBlockLayer(BlockRenderLayer.SOLID);
        }
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        while (f3 > 0.0f) {
            TextureAtlasSprite textureatlassprite2 = i % 2 == 0 ? textureatlassprite : textureatlassprite1;
            bufferbuilder.setSprite(textureatlassprite2);
            this.func_110776_a(AtlasTexture.field_110575_b);
            float f6 = textureatlassprite2.func_94209_e();
            float f7 = textureatlassprite2.func_94206_g();
            float f8 = textureatlassprite2.func_94212_f();
            float f9 = textureatlassprite2.func_94210_h();
            if (i / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            bufferbuilder.func_181662_b((double)(f1 - 0.0f), (double)(0.0f - f4), (double)f5).func_187315_a((double)f8, (double)f9).func_181675_d();
            bufferbuilder.func_181662_b((double)(-f1 - 0.0f), (double)(0.0f - f4), (double)f5).func_187315_a((double)f6, (double)f9).func_181675_d();
            bufferbuilder.func_181662_b((double)(-f1 - 0.0f), (double)(1.4f - f4), (double)f5).func_187315_a((double)f6, (double)f7).func_181675_d();
            bufferbuilder.func_181662_b((double)(f1 - 0.0f), (double)(1.4f - f4), (double)f5).func_187315_a((double)f8, (double)f7).func_181675_d();
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 += 0.03f;
            ++i;
        }
        tessellator.func_78381_a();
        if (multitexture) {
            bufferbuilder.setBlockLayer(null);
            GlStateManager.bindCurrentTexture();
        }
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
    }

    private void func_76975_c(Entity entityIn, double x, double y, double z, float shadowAlpha, float partialTicks) {
        MobEntity mobentity;
        if (Config.isShaders() && Shaders.shouldSkipDefaultShadow) {
            return;
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.field_76990_c.field_78724_e.func_110577_a(field_110778_a);
        IWorldReader iworldreader = this.func_76982_b();
        GlStateManager.depthMask((boolean)false);
        float f = this.field_76989_e;
        if (entityIn instanceof MobEntity && (mobentity = (MobEntity)entityIn).func_70631_g_()) {
            f *= 0.5f;
        }
        double d5 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70142_S, (double)entityIn.field_70165_t);
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70137_T, (double)entityIn.field_70163_u);
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70136_U, (double)entityIn.field_70161_v);
        int i = MathHelper.func_76128_c((double)(d5 - (double)f));
        int j = MathHelper.func_76128_c((double)(d5 + (double)f));
        int k = MathHelper.func_76128_c((double)(d0 - (double)f));
        int l2 = MathHelper.func_76128_c((double)d0);
        int i1 = MathHelper.func_76128_c((double)(d1 - (double)f));
        int j1 = MathHelper.func_76128_c((double)(d1 + (double)f));
        double d2 = x - d5;
        double d3 = y - d0;
        double d4 = z - d1;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l2, j1))) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate = iworldreader.func_180495_p(blockpos1);
            if (blockstate.func_185901_i() == BlockRenderType.INVISIBLE || iworldreader.func_201696_r(blockpos) <= 3) continue;
            this.func_217759_a(blockstate, iworldreader, blockpos1, x, y, z, blockpos, shadowAlpha, f, d2, d3, d4);
        }
        tessellator.func_78381_a();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
    }

    private IWorldReader func_76982_b() {
        return this.field_76990_c.field_78722_g;
    }

    private void func_217759_a(BlockState state, IWorldReader worldReader, BlockPos p_217759_3_, double p_217759_4_, double p_217759_6_, double p_217759_8_, BlockPos p_217759_10_, float p_217759_11_, float p_217759_12_, double p_217759_13_, double p_217759_15_, double p_217759_17_) {
        VoxelShape voxelshape;
        if (Block.func_208062_a((VoxelShape)state.func_196952_d((IBlockReader)worldReader, p_217759_3_)) && !(voxelshape = state.func_196954_c((IBlockReader)this.func_76982_b(), p_217759_10_.func_177977_b())).func_197766_b()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double d0 = ((double)p_217759_11_ - (p_217759_6_ - ((double)p_217759_10_.func_177956_o() + p_217759_15_)) / 2.0) * 0.5 * (double)this.func_76982_b().func_205052_D(p_217759_10_);
            if (d0 >= 0.0) {
                if (d0 > 1.0) {
                    d0 = 1.0;
                }
                AxisAlignedBB axisalignedbb = voxelshape.func_197752_a();
                double d1 = (double)p_217759_10_.func_177958_n() + axisalignedbb.field_72340_a + p_217759_13_;
                double d2 = (double)p_217759_10_.func_177958_n() + axisalignedbb.field_72336_d + p_217759_13_;
                double d3 = (double)p_217759_10_.func_177956_o() + axisalignedbb.field_72338_b + p_217759_15_ + 0.015625;
                double d4 = (double)p_217759_10_.func_177952_p() + axisalignedbb.field_72339_c + p_217759_17_;
                double d5 = (double)p_217759_10_.func_177952_p() + axisalignedbb.field_72334_f + p_217759_17_;
                float f = (float)((p_217759_4_ - d1) / 2.0 / (double)p_217759_12_ + 0.5);
                float f1 = (float)((p_217759_4_ - d2) / 2.0 / (double)p_217759_12_ + 0.5);
                float f2 = (float)((p_217759_8_ - d4) / 2.0 / (double)p_217759_12_ + 0.5);
                float f3 = (float)((p_217759_8_ - d5) / 2.0 / (double)p_217759_12_ + 0.5);
                bufferbuilder.func_181662_b(d1, d3, d4).func_187315_a((double)f, (double)f2).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d1, d3, d5).func_187315_a((double)f, (double)f3).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d2, d3, d5).func_187315_a((double)f1, (double)f3).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d2, d3, d4).func_187315_a((double)f1, (double)f2).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
            }
        }
    }

    public static void func_76978_a(AxisAlignedBB boundingBox, double x, double y, double z) {
        GlStateManager.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_178969_c(x, y, z);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181708_h);
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.enableTexture();
    }

    public void func_76979_b(Entity entityIn, double x, double y, double z, float yaw, float partialTicks) {
        if (this.field_76990_c.field_78733_k != null) {
            double d0;
            float f;
            if (this.field_76990_c.field_78733_k.field_181151_V && this.field_76989_e > 0.0f && !entityIn.func_82150_aj() && this.field_76990_c.func_178627_a() && (f = (float)((1.0 - (d0 = this.field_76990_c.func_78714_a(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v)) / 256.0) * (double)this.field_76987_f)) > 0.0f) {
                this.func_76975_c(entityIn, x, y, z, f, partialTicks);
            }
            if (entityIn.func_90999_ad() && !entityIn.func_175149_v()) {
                this.func_76977_a(entityIn, x, y, z, partialTicks);
            }
        }
    }

    public FontRenderer func_76983_a() {
        return this.field_76990_c.func_78716_a();
    }

    protected void func_147906_a(T entityIn, String str, double x, double y, double z, int maxDistance) {
        double d0 = entityIn.func_195048_a(this.field_76990_c.field_217783_c.func_216785_c());
        if (d0 <= (double)(maxDistance * maxDistance)) {
            boolean flag = entityIn.func_213287_bg();
            float f = this.field_76990_c.field_78735_i;
            float f1 = this.field_76990_c.field_78732_j;
            float f2 = entityIn.func_213302_cg() + 0.5f - (flag ? 0.25f : 0.0f);
            int i = "deadmau5".equals(str) ? -10 : 0;
            GameRenderer.func_215307_a((FontRenderer)this.func_76983_a(), (String)str, (float)((float)x), (float)((float)y + f2), (float)((float)z), (int)i, (float)f, (float)f1, (boolean)flag);
        }
    }

    public EntityRendererManager func_177068_d() {
        return this.field_76990_c;
    }

    public boolean func_188295_H_() {
        return false;
    }

    public void func_188300_b(T entityIn, double x, double y, double z, float entityYaw, float partialTicks) {
    }

    public void func_217758_e(T entityIn) {
        int i = entityIn.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
    }

    @Override
    public Class getEntityClass() {
        return this.entityClass;
    }

    @Override
    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public ResourceLocation getLocationTextureCustom() {
        return this.locationTextureCustom;
    }

    public void setLocationTextureCustom(ResourceLocation locationTextureCustom) {
        this.locationTextureCustom = locationTextureCustom;
    }
}

