/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;

public class ItemFrameRenderer
extends EntityRenderer<ItemFrameEntity> {
    private static final ResourceLocation field_110789_a = new ResourceLocation("textures/map/map_background.png");
    private static final ModelResourceLocation field_209585_f = new ModelResourceLocation("item_frame", "map=false");
    private static final ModelResourceLocation field_209586_g = new ModelResourceLocation("item_frame", "map=true");
    private final Minecraft field_147917_g = Minecraft.func_71410_x();
    private final ItemRenderer field_177074_h;
    private static double itemRenderDistanceSq = 4096.0;

    public ItemFrameRenderer(EntityRendererManager p_i498_1_, ItemRenderer p_i498_2_) {
        super(p_i498_1_);
        this.field_177074_h = p_i498_2_;
    }

    public void func_76986_a(ItemFrameEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        BlockPos blockpos = entity.func_174857_n();
        double d0 = (double)blockpos.func_177958_n() - entity.field_70165_t + x;
        double d1 = (double)blockpos.func_177956_o() - entity.field_70163_u + y;
        double d2 = (double)blockpos.func_177952_p() - entity.field_70161_v + z;
        GlStateManager.translated((double)(d0 + 0.5), (double)(d1 + 0.5), (double)(d2 + 0.5));
        GlStateManager.rotatef((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(180.0f - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        this.field_76990_c.field_78724_e.func_110577_a(AtlasTexture.field_110575_b);
        BlockRendererDispatcher blockrendererdispatcher = this.field_147917_g.func_175602_ab();
        ModelManager modelmanager = blockrendererdispatcher.func_175023_a().func_178126_b();
        ModelResourceLocation modelresourcelocation = entity.func_82335_i().func_77973_b() instanceof FilledMapItem ? field_209586_g : field_209585_f;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        blockrendererdispatcher.func_175019_b().func_178262_a(modelmanager.func_174953_a(modelresourcelocation), 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
        if (entity.func_82335_i().func_77973_b() == Items.field_151098_aY) {
            GlStateManager.pushLightingAttributes();
            RenderHelper.func_74519_b();
        }
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.4375f);
        this.func_82402_b(entity);
        if (entity.func_82335_i().func_77973_b() == Items.field_151098_aY) {
            RenderHelper.func_74518_a();
            GlStateManager.popAttributes();
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        this.func_177067_a(entity, x + (double)((float)entity.field_174860_b.func_82601_c() * 0.3f), y - 0.25, z + (double)((float)entity.field_174860_b.func_82599_e() * 0.3f));
    }

    @Nullable
    protected ResourceLocation func_110775_a(ItemFrameEntity entity) {
        return null;
    }

    private void func_82402_b(ItemFrameEntity itemFrame) {
        ItemStack itemstack = itemFrame.func_82335_i();
        if (!itemstack.func_190926_b()) {
            if (!this.isRenderItem(itemFrame)) {
                return;
            }
            GlStateManager.pushMatrix();
            boolean flag = itemstack.func_77973_b() instanceof FilledMapItem;
            int i = flag ? itemFrame.func_82333_j() % 4 * 2 : itemFrame.func_82333_j();
            GlStateManager.rotatef((float)((float)i * 360.0f / 8.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            if (!Reflector.postForgeBusEvent(Reflector.RenderItemInFrameEvent_Constructor, itemFrame, this)) {
                if (flag) {
                    GlStateManager.disableLighting();
                    this.field_76990_c.field_78724_e.func_110577_a(field_110789_a);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    float f = 0.0078125f;
                    GlStateManager.scalef((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
                    GlStateManager.translatef((float)-64.0f, (float)-64.0f, (float)0.0f);
                    MapData mapdata = ReflectorForge.getMapData((ItemStack)itemstack, (World)itemFrame.field_70170_p);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    if (mapdata != null) {
                        this.field_147917_g.field_71460_t.func_147701_i().func_148250_a(mapdata, true);
                    }
                } else {
                    GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                    this.field_177074_h.func_181564_a(itemstack, ItemCameraTransforms.TransformType.FIXED);
                }
            }
            GlStateManager.popMatrix();
        }
    }

    protected void func_177067_a(ItemFrameEntity entity, double x, double y, double z) {
        if (Minecraft.func_71382_s() && !entity.func_82335_i().func_190926_b() && entity.func_82335_i().func_82837_s() && this.field_76990_c.field_147941_i == entity) {
            float f;
            double d0 = entity.func_195048_a(this.field_76990_c.field_217783_c.func_216785_c());
            float f2 = f = entity.func_213287_bg() ? 32.0f : 64.0f;
            if (d0 < (double)(f * f)) {
                String s = entity.func_82335_i().func_200301_q().func_150254_d();
                this.func_147906_a((Entity)entity, s, x, y, z, 64);
            }
        }
    }

    private boolean isRenderItem(ItemFrameEntity itemFrame) {
        if (Shaders.isShadowPass) {
            return false;
        }
        if (!Config.zoomMode) {
            Entity viewEntity = this.field_147917_g.func_175606_aa();
            double distSq = itemFrame.func_70092_e(viewEntity.field_70165_t, viewEntity.field_70163_u, viewEntity.field_70161_v);
            if (distSq > itemRenderDistanceSq) {
                return false;
            }
        }
        return true;
    }

    public static void updateItemRenderDistance() {
        Minecraft mc = Minecraft.func_71410_x();
        double fov = Config.limit(mc.field_71474_y.field_74334_X, 1.0, 120.0);
        double itemRenderDistance = Math.max(6.0 * (double)mc.field_195558_d.func_198083_n() / fov, 16.0);
        itemRenderDistanceSq = itemRenderDistance * itemRenderDistance;
    }
}

