/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.util.math.MathHelper;
import net.optifine.Config;
import net.optifine.shaders.Shaders;

public abstract class MobRenderer<T extends MobEntity, M extends EntityModel<T>>
extends LivingRenderer<T, M> {
    public MobRenderer(EntityRendererManager p_i441_1_, M p_i441_2_, float p_i441_3_) {
        super(p_i441_1_, p_i441_2_, p_i441_3_);
    }

    protected boolean func_177070_b(T entity) {
        return super.func_177070_b(entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }

    public boolean func_177071_a(T livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (super.func_177071_a(livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        Entity entity = livingEntity.func_110166_bE();
        return entity != null ? camera.func_78546_a(entity.func_184177_bl()) : false;
    }

    public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        if (!this.field_188301_f) {
            this.func_110827_b(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    protected void func_110827_b(T entityLivingIn, double x, double y, double z, float entityYaw, float partialTicks) {
        if (Config.isShaders() && Shaders.isShadowPass) {
            return;
        }
        Entity entity = entityLivingIn.func_110166_bE();
        if (entity != null) {
            y -= (1.6 - (double)entityLivingIn.func_213302_cg()) * 0.5;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double d0 = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)entity.field_70177_z, (float)entity.field_70126_B) * ((float)Math.PI / 180);
            double d1 = MathHelper.func_219799_g((float)(partialTicks * 0.5f), (float)entity.field_70125_A, (float)entity.field_70127_C) * ((float)Math.PI / 180);
            double d2 = Math.cos(d0);
            double d3 = Math.sin(d0);
            double d4 = Math.sin(d1);
            if (entity instanceof HangingEntity) {
                d2 = 0.0;
                d3 = 0.0;
                d4 = -1.0;
            }
            double d5 = Math.cos(d1);
            double d6 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70169_q, (double)entity.field_70165_t) - d2 * 0.7 - d3 * 0.5 * d5;
            double d7 = MathHelper.func_219803_d((double)partialTicks, (double)(entity.field_70167_r + (double)entity.func_70047_e() * 0.7), (double)(entity.field_70163_u + (double)entity.func_70047_e() * 0.7)) - d4 * 0.5 - 0.25;
            double d8 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70166_s, (double)entity.field_70161_v) - d3 * 0.7 + d2 * 0.5 * d5;
            double d9 = (double)(MathHelper.func_219799_g((float)partialTicks, (float)((MobEntity)entityLivingIn).field_70761_aq, (float)((MobEntity)entityLivingIn).field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
            d2 = Math.cos(d9) * (double)entityLivingIn.func_213311_cf() * 0.4;
            d3 = Math.sin(d9) * (double)entityLivingIn.func_213311_cf() * 0.4;
            double d10 = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entityLivingIn).field_70169_q, (double)((MobEntity)entityLivingIn).field_70165_t) + d2;
            double d11 = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entityLivingIn).field_70167_r, (double)((MobEntity)entityLivingIn).field_70163_u);
            double d12 = MathHelper.func_219803_d((double)partialTicks, (double)((MobEntity)entityLivingIn).field_70166_s, (double)((MobEntity)entityLivingIn).field_70161_v) + d3;
            x += d2;
            z += d3;
            double d13 = (float)(d6 - d10);
            double d14 = (float)(d7 - d11);
            double d15 = (float)(d8 - d12);
            GlStateManager.disableTexture();
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            if (Config.isShaders()) {
                Shaders.beginLeash();
            }
            int i = 24;
            double d16 = 0.025;
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int j = 0; j <= 24; ++j) {
                float f = 0.5f;
                float f1 = 0.4f;
                float f2 = 0.3f;
                if (j % 2 == 0) {
                    f *= 0.7f;
                    f1 *= 0.7f;
                    f2 *= 0.7f;
                }
                float f3 = (float)j / 24.0f;
                bufferbuilder.func_181662_b(x + d13 * (double)f3 + 0.0, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f), z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + d13 * (double)f3 + 0.025, y + d14 * (double)(f3 * f3 + f3) * 0.5 + (double)((24.0f - (float)j) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f3).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (int k = 0; k <= 24; ++k) {
                float f4 = 0.5f;
                float f5 = 0.4f;
                float f6 = 0.3f;
                if (k % 2 == 0) {
                    f4 *= 0.7f;
                    f5 *= 0.7f;
                    f6 *= 0.7f;
                }
                float f7 = (float)k / 24.0f;
                bufferbuilder.func_181662_b(x + d13 * (double)f7 + 0.0, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f) + 0.025, z + d15 * (double)f7).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
                bufferbuilder.func_181662_b(x + d13 * (double)f7 + 0.025, y + d14 * (double)(f7 * f7 + f7) * 0.5 + (double)((24.0f - (float)k) / 18.0f + 0.125f), z + d15 * (double)f7 + 0.025).func_181666_a(f4, f5, f6, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            if (Config.isShaders()) {
                Shaders.endLeash();
            }
            GlStateManager.enableLighting();
            GlStateManager.enableTexture();
            GlStateManager.enableCull();
        }
    }
}

