/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MooshroomRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.CowModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.optifine.Config;

public class MooshroomMushroomLayer<T extends MooshroomEntity>
extends LayerRenderer<T, CowModel<T>> {
    private RendererModel modelRendererMushroom;
    private static final ResourceLocation LOCATION_MUSHROOM_RED = new ResourceLocation("textures/entity/cow/red_mushroom.png");
    private static final ResourceLocation LOCATION_MUSHROOM_BROWN = new ResourceLocation("textures/entity/cow/brown_mushroom.png");
    private static boolean hasTextureMushroomRed = false;
    private static boolean hasTextureMushroomBrown = false;

    public MooshroomMushroomLayer(IEntityRenderer<T, CowModel<T>> p_i388_1_) {
        super(p_i388_1_);
        MooshroomRenderer mooshroomRenderer = (MooshroomRenderer)p_i388_1_;
        this.modelRendererMushroom = new RendererModel((Model)mooshroomRenderer.field_77045_g);
        this.modelRendererMushroom.func_78787_b(16, 16);
        this.modelRendererMushroom.field_78800_c = -6.0f;
        this.modelRendererMushroom.field_78798_e = -8.0f;
        this.modelRendererMushroom.field_78796_g = MathHelper.PI / 4.0f;
        int[][] faceUvs = new int[6][];
        faceUvs[2] = new int[]{16, 16, 0, 0};
        faceUvs[3] = new int[]{16, 16, 0, 0};
        this.modelRendererMushroom.addBox((int[][])faceUvs, 0.0f, 0.0f, 10.0f, 20.0f, 16.0f, 0.0f, 0.0f);
        int[][] faceUvs2 = new int[6][];
        faceUvs2[4] = new int[]{16, 16, 0, 0};
        faceUvs2[5] = new int[]{16, 16, 0, 0};
        this.modelRendererMushroom.addBox((int[][])faceUvs2, 10.0f, 0.0f, 0.0f, 0.0f, 16.0f, 20.0f, 0.0f);
    }

    public void func_212842_a_(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!entitylivingbaseIn.func_70631_g_() && !entitylivingbaseIn.func_82150_aj()) {
            BlockState blockstate = entitylivingbaseIn.func_213444_dV().func_221093_a();
            ResourceLocation locMushroom = this.getCustomMushroom(blockstate);
            if (locMushroom != null) {
                this.func_215333_a(locMushroom);
            } else {
                this.func_215333_a(AtlasTexture.field_110575_b);
            }
            GlStateManager.enableCull();
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.translatef((float)0.2f, (float)0.35f, (float)0.5f);
            GlStateManager.rotatef((float)42.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.5f);
            if (locMushroom != null) {
                this.modelRendererMushroom.func_78785_a(0.0625f);
            } else {
                blockrendererdispatcher.func_175016_a(blockstate, 1.0f);
            }
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.1f, (float)0.0f, (float)-0.6f);
            GlStateManager.rotatef((float)42.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.5f);
            if (locMushroom != null) {
                this.modelRendererMushroom.func_78785_a(0.0625f);
            } else {
                blockrendererdispatcher.func_175016_a(blockstate, 1.0f);
            }
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            ((CowModel)this.func_215332_c()).func_205063_a().func_78794_c(0.0625f);
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0f, (float)0.7f, (float)-0.2f);
            GlStateManager.rotatef((float)12.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.5f);
            if (locMushroom != null) {
                this.modelRendererMushroom.func_78785_a(0.0625f);
            } else {
                blockrendererdispatcher.func_175016_a(blockstate, 1.0f);
            }
            GlStateManager.popMatrix();
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.disableCull();
        }
    }

    public boolean func_177142_b() {
        return true;
    }

    private ResourceLocation getCustomMushroom(BlockState iblockstate) {
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150337_Q && hasTextureMushroomRed) {
            return LOCATION_MUSHROOM_RED;
        }
        if (block == Blocks.field_150338_P && hasTextureMushroomBrown) {
            return LOCATION_MUSHROOM_BROWN;
        }
        return null;
    }

    public static void update() {
        hasTextureMushroomRed = Config.hasResource((ResourceLocation)LOCATION_MUSHROOM_RED);
        hasTextureMushroomBrown = Config.hasResource((ResourceLocation)LOCATION_MUSHROOM_BROWN);
    }
}

