/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraft.util.ResourceLocation;
import net.optifine.Config;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.model.ModelSprite;

public class RendererModel {
    public float field_78801_a = 64.0f;
    public float field_78799_b = 32.0f;
    private int field_78803_o;
    private int field_78813_p;
    public float field_78800_c;
    public float field_78797_d;
    public float field_78798_e;
    public float field_78795_f;
    public float field_78796_g;
    public float field_78808_h;
    private boolean field_78812_q;
    private int field_78811_r;
    public boolean field_78809_i;
    public boolean field_78806_j = true;
    public boolean field_78807_k;
    public final List<ModelBox> field_78804_l;
    public List<RendererModel> field_78805_m;
    public final String field_78802_n;
    public float field_82906_o;
    public float field_82908_p;
    public float field_82907_q;
    public List spriteList = new ArrayList();
    public boolean mirrorV = false;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    private float savedScale;
    private ResourceLocation textureLocation = null;
    private String id = null;
    private ModelUpdater modelUpdater;
    private WorldRenderer renderGlobal = Config.getRenderGlobal();

    public RendererModel(Model p_i252_1_, String p_i252_2_) {
        this.field_78804_l = Lists.newArrayList();
        p_i252_1_.field_78092_r.add(this);
        this.field_78802_n = p_i252_2_;
        this.func_78787_b(p_i252_1_.field_78090_t, p_i252_1_.field_78089_u);
    }

    public RendererModel(Model p_i253_1_) {
        this(p_i253_1_, (String)null);
    }

    public RendererModel(Model p_i254_1_, int p_i254_2_, int p_i254_3_) {
        this(p_i254_1_);
        this.func_78784_a(p_i254_2_, p_i254_3_);
    }

    public void func_217177_a(RendererModel p_217177_1_) {
        this.field_78795_f = p_217177_1_.field_78795_f;
        this.field_78796_g = p_217177_1_.field_78796_g;
        this.field_78808_h = p_217177_1_.field_78808_h;
        this.field_78800_c = p_217177_1_.field_78800_c;
        this.field_78797_d = p_217177_1_.field_78797_d;
        this.field_78798_e = p_217177_1_.field_78798_e;
    }

    public void func_78792_a(RendererModel renderer) {
        if (this.field_78805_m == null) {
            this.field_78805_m = Lists.newArrayList();
        }
        this.field_78805_m.add(renderer);
    }

    public void func_217179_c(RendererModel p_217179_1_) {
        if (this.field_78805_m != null) {
            this.field_78805_m.remove(p_217179_1_);
        }
    }

    public RendererModel func_78784_a(int x, int y) {
        this.field_78803_o = x;
        this.field_78813_p = y;
        return this;
    }

    public RendererModel func_217178_a(String partName, float offX, float offY, float offZ, int width, int height, int depth, float delta, int texX, int texY) {
        partName = this.field_78802_n + "." + partName;
        this.func_78784_a(texX, texY);
        this.field_78804_l.add(new ModelBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, delta).func_78244_a(partName));
        return this;
    }

    public RendererModel func_78789_a(float offX, float offY, float offZ, int width, int height, int depth) {
        this.field_78804_l.add(new ModelBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f));
        return this;
    }

    public RendererModel func_178769_a(float offX, float offY, float offZ, int width, int height, int depth, boolean mirrored) {
        this.field_78804_l.add(new ModelBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f, mirrored));
        return this;
    }

    public void func_78790_a(float offX, float offY, float offZ, int width, int height, int depth, float scaleFactor) {
        this.field_78804_l.add(new ModelBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, scaleFactor));
    }

    public void func_205345_a(float offX, float offY, float offZ, int width, int height, int depth, float scaleFactor, boolean mirrorIn) {
        this.field_78804_l.add(new ModelBox(this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, scaleFactor, mirrorIn));
    }

    public void func_78793_a(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.field_78800_c = rotationPointXIn;
        this.field_78797_d = rotationPointYIn;
        this.field_78798_e = rotationPointZIn;
    }

    public void func_78785_a(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.field_78812_q) {
                this.func_78788_d(scale);
            }
            int lastTextureId = 0;
            if (this.textureLocation != null && !this.renderGlobal.renderOverlayDamaged) {
                if (this.renderGlobal.renderOverlayEyes) {
                    return;
                }
                lastTextureId = GlStateManager.getBoundTexture();
                Config.getTextureManager().func_110577_a(this.textureLocation);
            }
            if (this.modelUpdater != null) {
                this.modelUpdater.update();
            }
            boolean scaleXYZ = this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f;
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            if (this.field_78795_f == 0.0f && this.field_78796_g == 0.0f && this.field_78808_h == 0.0f) {
                if (this.field_78800_c == 0.0f && this.field_78797_d == 0.0f && this.field_78798_e == 0.0f) {
                    if (scaleXYZ) {
                        GlStateManager.scalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
                    }
                    GlStateManager.callList((int)this.field_78811_r);
                    if (this.field_78805_m != null) {
                        for (int k = 0; k < this.field_78805_m.size(); ++k) {
                            ((RendererModel)this.field_78805_m.get(k)).func_78785_a(scale);
                        }
                    }
                    if (scaleXYZ) {
                        GlStateManager.scalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
                    }
                } else {
                    GlStateManager.pushMatrix();
                    GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                    if (scaleXYZ) {
                        GlStateManager.scalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
                    }
                    GlStateManager.callList((int)this.field_78811_r);
                    if (this.field_78805_m != null) {
                        for (int j = 0; j < this.field_78805_m.size(); ++j) {
                            ((RendererModel)this.field_78805_m.get(j)).func_78785_a(scale);
                        }
                    }
                    if (scaleXYZ) {
                        GlStateManager.scalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
                    }
                    GlStateManager.popMatrix();
                }
            } else {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.rotatef((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.rotatef((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.rotatef((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (scaleXYZ) {
                    GlStateManager.scalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
                }
                GlStateManager.callList((int)this.field_78811_r);
                if (this.field_78805_m != null) {
                    for (int i = 0; i < this.field_78805_m.size(); ++i) {
                        ((RendererModel)this.field_78805_m.get(i)).func_78785_a(scale);
                    }
                }
                GlStateManager.popMatrix();
            }
            GlStateManager.popMatrix();
            if (lastTextureId != 0) {
                GlStateManager.bindTexture((int)lastTextureId);
            }
        }
    }

    public void func_78791_b(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.field_78812_q) {
                this.func_78788_d(scale);
            }
            int lastTextureId = 0;
            if (this.textureLocation != null && !this.renderGlobal.renderOverlayDamaged) {
                if (this.renderGlobal.renderOverlayEyes) {
                    return;
                }
                lastTextureId = GlStateManager.getBoundTexture();
                Config.getTextureManager().func_110577_a(this.textureLocation);
            }
            if (this.modelUpdater != null) {
                this.modelUpdater.update();
            }
            boolean scaleXYZ = this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f;
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            if (this.field_78796_g != 0.0f) {
                GlStateManager.rotatef((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.field_78795_f != 0.0f) {
                GlStateManager.rotatef((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.field_78808_h != 0.0f) {
                GlStateManager.rotatef((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (scaleXYZ) {
                GlStateManager.scalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            }
            GlStateManager.callList((int)this.field_78811_r);
            if (this.field_78805_m != null) {
                for (int i = 0; i < this.field_78805_m.size(); ++i) {
                    ((RendererModel)this.field_78805_m.get(i)).func_78785_a(scale);
                }
            }
            GlStateManager.popMatrix();
            if (lastTextureId != 0) {
                GlStateManager.bindTexture((int)lastTextureId);
            }
        }
    }

    public void func_78794_c(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.field_78812_q) {
                this.func_78788_d(scale);
            }
            if (this.field_78795_f == 0.0f && this.field_78796_g == 0.0f && this.field_78808_h == 0.0f) {
                if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f) {
                    GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                }
            } else {
                GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.rotatef((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.rotatef((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.rotatef((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    private void func_78788_d(float scale) {
        int i;
        if (this.field_78811_r == 0) {
            this.savedScale = scale;
            this.field_78811_r = GLAllocation.func_74526_a((int)1);
        }
        GlStateManager.newList((int)this.field_78811_r, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        for (i = 0; i < this.field_78804_l.size(); ++i) {
            ((ModelBox)this.field_78804_l.get(i)).func_178780_a(bufferbuilder, scale);
        }
        for (i = 0; i < this.spriteList.size(); ++i) {
            ModelSprite sprite = (ModelSprite)this.spriteList.get(i);
            sprite.render(Tessellator.func_178181_a(), scale);
        }
        GlStateManager.endList();
        this.field_78812_q = true;
    }

    public RendererModel func_78787_b(int textureWidthIn, int textureHeightIn) {
        this.field_78801_a = textureWidthIn;
        this.field_78799_b = textureHeightIn;
        return this;
    }

    public void addSprite(float posX, float posY, float posZ, int sizeX, int sizeY, int sizeZ, float sizeAdd) {
        this.spriteList.add(new ModelSprite(this, this.field_78803_o, this.field_78813_p, posX, posY, posZ, sizeX, sizeY, sizeZ, sizeAdd));
    }

    public boolean getCompiled() {
        return this.field_78812_q;
    }

    public int getDisplayList() {
        return this.field_78811_r;
    }

    public void resetDisplayList() {
        if (this.field_78812_q) {
            this.field_78812_q = false;
            this.func_78788_d(this.savedScale);
        }
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addBox(int[][] faceUvs, float x, float y, float z, float dx, float dy, float dz, float delta) {
        this.field_78804_l.add(new ModelBox(this, faceUvs, x, y, z, dx, dy, dz, delta, this.field_78809_i));
    }

    public RendererModel getChild(int index) {
        if (this.field_78805_m == null) {
            return null;
        }
        if (index < 0 || index >= this.field_78805_m.size()) {
            return null;
        }
        return (RendererModel)this.field_78805_m.get(index);
    }

    public RendererModel getChild(String name) {
        if (name == null) {
            return null;
        }
        if (this.field_78805_m != null) {
            for (int i = 0; i < this.field_78805_m.size(); ++i) {
                RendererModel child = (RendererModel)this.field_78805_m.get(i);
                if (!name.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }

    public RendererModel getChildDeep(String name) {
        if (name == null) {
            return null;
        }
        RendererModel mrChild = this.getChild(name);
        if (mrChild != null) {
            return mrChild;
        }
        if (this.field_78805_m != null) {
            for (int i = 0; i < this.field_78805_m.size(); ++i) {
                RendererModel child = (RendererModel)this.field_78805_m.get(i);
                RendererModel mr = child.getChildDeep(name);
                if (mr == null) continue;
                return mr;
            }
        }
        return null;
    }

    public void setModelUpdater(ModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: " + this.id + ", boxes: " + (this.field_78804_l != null ? Integer.valueOf(this.field_78804_l.size()) : null) + ", submodels: " + (this.field_78805_m != null ? Integer.valueOf(this.field_78805_m.size()) : null));
        return sb.toString();
    }
}

