/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.optifine.Config;
import net.optifine.ItemOverrideCache;

public class ItemOverrideList {
    public static final ItemOverrideList field_188022_a = new ItemOverrideList();
    private final List<ItemOverride> field_188023_b = Lists.newArrayList();
    private final List<IBakedModel> field_209582_c;
    private ItemOverrideCache itemOverrideCache;
    public static ResourceLocation lastModelLocation = null;

    private ItemOverrideList() {
        this.field_209582_c = Collections.emptyList();
    }

    public ItemOverrideList(ModelBakery p_i546_1_, BlockModel p_i546_2_, Function<ResourceLocation, IUnbakedModel> p_i546_3_, List<ItemOverride> p_i546_4_) {
        this.field_209582_c = p_i546_4_.stream().map(p_217649_3_ -> {
            IUnbakedModel iunbakedmodel = (IUnbakedModel)p_i546_3_.apply(p_217649_3_.func_188026_a());
            return Objects.equals(iunbakedmodel, p_i546_2_) ? null : p_i546_1_.func_217845_a(p_217649_3_.func_188026_a(), (ISprite)ModelRotation.X0_Y0);
        }).collect(Collectors.toList());
        Collections.reverse(this.field_209582_c);
        for (int i = p_i546_4_.size() - 1; i >= 0; --i) {
            this.field_188023_b.add(p_i546_4_.get(i));
        }
        if (this.field_188023_b.size() > 65) {
            this.itemOverrideCache = ItemOverrideCache.make(this.field_188023_b);
        }
    }

    @Nullable
    public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        boolean customItems = Config.isCustomItems();
        if (customItems) {
            lastModelLocation = null;
        }
        if (!this.field_188023_b.isEmpty()) {
            Integer modelIndex;
            if (this.itemOverrideCache != null && (modelIndex = this.itemOverrideCache.getModelIndex(stack, worldIn, entityIn)) != null) {
                int indexCached = modelIndex;
                if (indexCached >= 0 && indexCached < this.field_209582_c.size()) {
                    IBakedModel modelCached;
                    if (customItems) {
                        lastModelLocation = ((ItemOverride)this.field_188023_b.get(indexCached)).func_188026_a();
                    }
                    if ((modelCached = (IBakedModel)this.field_209582_c.get(indexCached)) != null) {
                        return modelCached;
                    }
                }
                return model;
            }
            for (int i = 0; i < this.field_188023_b.size(); ++i) {
                ItemOverride itemoverride = (ItemOverride)this.field_188023_b.get(i);
                if (!itemoverride.func_188027_a(stack, worldIn, entityIn)) continue;
                IBakedModel ibakedmodel = (IBakedModel)this.field_209582_c.get(i);
                if (customItems) {
                    lastModelLocation = itemoverride.func_188026_a();
                }
                if (this.itemOverrideCache != null) {
                    this.itemOverrideCache.putModelIndex(stack, worldIn, entityIn, i);
                }
                if (ibakedmodel == null) {
                    return model;
                }
                return ibakedmodel;
            }
            if (this.itemOverrideCache != null) {
                this.itemOverrideCache.putModelIndex(stack, worldIn, entityIn, ItemOverrideCache.INDEX_NONE);
            }
        }
        return model;
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        return originalModel;
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return ImmutableList.copyOf((Collection)this.field_188023_b);
    }
}

