/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.optifine.http.HttpPipeline;
import net.optifine.http.HttpRequest;
import net.optifine.http.HttpResponse;
import net.optifine.player.CapeImageBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadingTexture
extends SimpleTexture {
    private static final Logger field_147644_c = LogManager.getLogger();
    private static final AtomicInteger field_147643_d = new AtomicInteger(0);
    @Nullable
    private final File field_152434_e;
    private final String field_110562_b;
    @Nullable
    private final IImageBuffer field_110563_c;
    @Nullable
    private Thread field_110561_e;
    private volatile boolean field_110559_g;
    public Boolean imageFound = null;
    public boolean pipeline = false;
    private boolean uploadPending = false;

    public DownloadingTexture(@Nullable File p_i512_1_, String p_i512_2_, ResourceLocation p_i512_3_, @Nullable IImageBuffer p_i512_4_) {
        super(p_i512_3_);
        this.field_152434_e = p_i512_1_;
        this.field_110562_b = p_i512_2_;
        this.field_110563_c = p_i512_4_;
    }

    private void func_195416_b(NativeImage nativeImageIn) {
        TextureUtil.prepareImage((int)this.func_110552_b(), (int)nativeImageIn.func_195702_a(), (int)nativeImageIn.func_195714_b());
        nativeImageIn.func_195697_a(0, 0, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195417_a(NativeImage nativeImageIn) {
        if (this.field_110563_c != null) {
            this.field_110563_c.func_152634_a();
        }
        DownloadingTexture downloadingTexture = this;
        synchronized (downloadingTexture) {
            this.func_195416_b(nativeImageIn);
            this.field_110559_g = true;
        }
        this.imageFound = nativeImageIn != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195413_a(IResourceManager manager) throws IOException {
        if (!this.field_110559_g) {
            DownloadingTexture downloadingTexture = this;
            synchronized (downloadingTexture) {
                super.func_195413_a(manager);
                this.field_110559_g = true;
            }
        }
        if (this.field_110561_e == null) {
            if (this.field_152434_e != null && this.field_152434_e.isFile()) {
                field_147644_c.debug("Loading http texture from local cache ({})", (Object)this.field_152434_e);
                try (NativeImage nativeimage = null;){
                    nativeimage = NativeImage.func_195713_a((InputStream)new FileInputStream(this.field_152434_e));
                    if (this.field_110563_c != null) {
                        nativeimage = this.field_110563_c.func_195786_a(nativeimage);
                    }
                    this.func_195417_a(nativeimage);
                    this.loadingFinished();
                }
            } else {
                this.func_152433_a();
            }
        }
    }

    protected void func_152433_a() {
        this.field_110561_e = new /* Unavailable Anonymous Inner Class!! */;
        this.field_110561_e.setDaemon(true);
        this.field_110561_e.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_147644_c));
        this.field_110561_e.start();
    }

    private boolean shouldPipeline() {
        if (!this.pipeline) {
            return false;
        }
        Proxy proxy = Minecraft.func_71410_x().func_110437_J();
        if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.SOCKS) {
            return false;
        }
        return this.field_110562_b.startsWith("http://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPipelined() {
        try {
            HttpRequest req = HttpPipeline.makeRequest(this.field_110562_b, Minecraft.func_71410_x().func_110437_J());
            HttpResponse resp = HttpPipeline.executeRequest(req);
            if (resp.getStatus() / 100 == 2) {
                NativeImage ni;
                byte[] body = resp.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                if (this.field_152434_e != null) {
                    FileUtils.copyInputStreamToFile((InputStream)bais, (File)this.field_152434_e);
                    ni = NativeImage.func_195713_a((InputStream)new FileInputStream(this.field_152434_e));
                } else {
                    ni = NativeImage.func_195713_a((InputStream)bais);
                }
                if (this.field_110563_c != null) {
                    ni = this.field_110563_c.func_195786_a(ni);
                }
                NativeImage nif = ni;
                Minecraft.func_71410_x().execute(() -> this.func_195417_a(nif));
                this.uploadPending = true;
                return;
            }
        }
        catch (Exception var6) {
            field_147644_c.error("Couldn't download http texture: " + var6.getClass().getName() + ": " + var6.getMessage());
            return;
        }
        finally {
            this.loadingFinished();
        }
    }

    private void loadingFinished() {
        if (this.uploadPending) {
            return;
        }
        if (this.field_110563_c instanceof CapeImageBuffer) {
            CapeImageBuffer cib = (CapeImageBuffer)this.field_110563_c;
            cib.cleanup();
        }
    }

    public IImageBuffer getImageBuffer() {
        return this.field_110563_c;
    }

    static /* synthetic */ String access$000(DownloadingTexture x0) {
        return x0.field_110562_b;
    }

    static /* synthetic */ File access$100(DownloadingTexture x0) {
        return x0.field_152434_e;
    }

    static /* synthetic */ Logger access$200() {
        return field_147644_c;
    }

    static /* synthetic */ boolean access$300(DownloadingTexture x0) {
        return x0.shouldPipeline();
    }

    static /* synthetic */ void access$400(DownloadingTexture x0) {
        x0.loadPipelined();
    }

    static /* synthetic */ boolean access$502(DownloadingTexture x0, boolean x1) {
        x0.uploadPending = x1;
        return x0.uploadPending;
    }

    static /* synthetic */ void access$600(DownloadingTexture x0) {
        x0.loadingFinished();
    }

    static /* synthetic */ IImageBuffer access$300(DownloadingTexture x0) {
        return x0.field_110563_c;
    }
}

