/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.gen.Heightmap;
import net.optifine.ChunkDataOF;
import net.optifine.ChunkOF;

public class SChunkDataPacket
implements IPacket<IClientPlayNetHandler> {
    private int field_149284_a;
    private int field_149282_b;
    private int field_186948_c;
    private CompoundNBT field_218711_d;
    private byte[] field_186949_d;
    private List<CompoundNBT> field_189557_e;
    private boolean field_149279_g;
    private Map<String, Object> customData;

    public SChunkDataPacket() {
    }

    public SChunkDataPacket(Chunk p_i936_1_, int p_i936_2_) {
        ChunkPos chunkpos = p_i936_1_.func_76632_l();
        this.field_149284_a = chunkpos.field_77276_a;
        this.field_149282_b = chunkpos.field_77275_b;
        this.field_149279_g = p_i936_2_ == 65535;
        this.field_218711_d = new CompoundNBT();
        for (Map.Entry entry : p_i936_1_.func_217311_f()) {
            if (!((Heightmap.Type)entry.getKey()).func_222681_b()) continue;
            this.field_218711_d.func_218657_a(((Heightmap.Type)entry.getKey()).func_203500_b(), (INBT)new LongArrayNBT(((Heightmap)entry.getValue()).func_202269_a()));
        }
        this.field_186949_d = new byte[this.func_218709_a(p_i936_1_, p_i936_2_)];
        this.field_186948_c = this.func_218708_a(new PacketBuffer(this.func_186945_f()), p_i936_1_, p_i936_2_);
        this.field_189557_e = Lists.newArrayList();
        for (Map.Entry entry : p_i936_1_.func_177434_r().entrySet()) {
            BlockPos blockpos = (BlockPos)entry.getKey();
            TileEntity tileentity = (TileEntity)entry.getValue();
            int i = blockpos.func_177956_o() >> 4;
            if (!this.func_149274_i() && (p_i936_2_ & 1 << i) == 0) continue;
            CompoundNBT compoundnbt = tileentity.func_189517_E_();
            this.field_189557_e.add(compoundnbt);
        }
        this.customData = new HashMap();
        ChunkDataOF chunkDataOF = ChunkOF.makeChunkDataOF((Chunk)p_i936_1_);
        this.customData.put("ChunkDataOF", chunkDataOF);
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        this.field_149284_a = buf.readInt();
        this.field_149282_b = buf.readInt();
        this.field_149279_g = buf.readBoolean();
        this.field_186948_c = buf.func_150792_a();
        this.field_218711_d = buf.func_150793_b();
        int i = buf.func_150792_a();
        if (i > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.field_186949_d = new byte[i];
        buf.readBytes(this.field_186949_d);
        int j = buf.func_150792_a();
        this.field_189557_e = Lists.newArrayList();
        for (int k = 0; k < j; ++k) {
            this.field_189557_e.add(buf.func_150793_b());
        }
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        buf.writeInt(this.field_149284_a);
        buf.writeInt(this.field_149282_b);
        buf.writeBoolean(this.field_149279_g);
        buf.func_150787_b(this.field_186948_c);
        buf.func_150786_a(this.field_218711_d);
        buf.func_150787_b(this.field_186949_d.length);
        buf.writeBytes(this.field_186949_d);
        buf.func_150787_b(this.field_189557_e.size());
        for (CompoundNBT compoundnbt : this.field_189557_e) {
            buf.func_150786_a(compoundnbt);
        }
    }

    public void func_148833_a(IClientPlayNetHandler handler) {
        handler.func_147263_a(this);
    }

    public PacketBuffer func_186946_a() {
        return new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.field_186949_d), this.customData);
    }

    private ByteBuf func_186945_f() {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])this.field_186949_d);
        bytebuf.writerIndex(0);
        return bytebuf;
    }

    public int func_218708_a(PacketBuffer buf, Chunk chunkIn, int writeSkylight) {
        int i = 0;
        ChunkSection[] achunksection = chunkIn.func_76587_i();
        int k = achunksection.length;
        for (int j = 0; j < k; ++j) {
            ChunkSection chunksection = achunksection[j];
            if (chunksection == Chunk.field_186036_a || this.func_149274_i() && chunksection.func_76663_a() || (writeSkylight & 1 << j) == 0) continue;
            i |= 1 << j;
            chunksection.func_222630_b(buf);
        }
        if (this.func_149274_i()) {
            Biome[] abiome = chunkIn.func_201590_e();
            for (int l2 = 0; l2 < abiome.length; ++l2) {
                buf.writeInt(Registry.field_212624_m.func_148757_b((Object)abiome[l2]));
            }
        }
        return i;
    }

    protected int func_218709_a(Chunk chunkIn, int p_218709_2_) {
        int i = 0;
        ChunkSection[] achunksection = chunkIn.func_76587_i();
        int k = achunksection.length;
        for (int j = 0; j < k; ++j) {
            ChunkSection chunksection = achunksection[j];
            if (chunksection == Chunk.field_186036_a || this.func_149274_i() && chunksection.func_76663_a() || (p_218709_2_ & 1 << j) == 0) continue;
            i += chunksection.func_222633_j();
        }
        if (this.func_149274_i()) {
            i += chunkIn.func_201590_e().length * 4;
        }
        return i;
    }

    public int func_149273_e() {
        return this.field_149284_a;
    }

    public int func_149271_f() {
        return this.field_149282_b;
    }

    public int func_149276_g() {
        return this.field_186948_c;
    }

    public boolean func_149274_i() {
        return this.field_149279_g;
    }

    public CompoundNBT func_218710_g() {
        return this.field_218711_d;
    }

    public List<CompoundNBT> func_189554_f() {
        return this.field_189557_e;
    }
}

