/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.mojang.blaze3d.platform.GlStateManager;
import java.time.Duration;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.IProfiler;
import net.optifine.Config;
import net.optifine.Lagometer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugProfiler
implements IProfiler {
    private static final Logger field_223005_a = LogManager.getLogger();
    private static final long field_219901_a = Duration.ofMillis(300L).toNanos();
    private final IntSupplier field_219902_b;
    private final DebugResultEntryImpl field_219903_c = new DebugResultEntryImpl(this, null);
    private final DebugResultEntryImpl field_219904_d = new DebugResultEntryImpl(this, null);
    private boolean clientProfiler = false;
    private boolean lagometerActive = false;
    private boolean fastRender = false;
    private static final String SCHEDULED_EXECUTABLES = "scheduledExecutables";
    private static final String TICK = "tick";
    private static final String SOUND = "sound";
    private static final String RENDER = "render";
    private static final String DISPLAY = "display";
    private static final int HASH_SCHEDULED_EXECUTABLES = "scheduledExecutables".hashCode();
    private static final int HASH_TICK = "tick".hashCode();
    private static final int HASH_SOUND = "sound".hashCode();
    private static final int HASH_RENDER = "render".hashCode();
    private static final int HASH_DISPLAY = "display".hashCode();

    public DebugProfiler(IntSupplier p_i1225_1_) {
        this.field_219902_b = p_i1225_1_;
    }

    public IDebugResultEntry func_219899_d() {
        return this.field_219903_c;
    }

    public void func_219894_a() {
        this.clientProfiler = Minecraft.func_71410_x().func_213239_aq() == this;
        this.lagometerActive = this.clientProfiler && Lagometer.isActive();
        this.fastRender = this.clientProfiler && Config.isFastRender();
        this.field_219903_c.field_219940_a.func_219894_a();
        this.field_219904_d.field_219940_a.func_219894_a();
    }

    public void func_219897_b() {
        this.field_219903_c.field_219940_a.func_219897_b();
        this.field_219904_d.field_219940_a.func_219897_b();
    }

    public void func_76320_a(String name) {
        int hashName;
        if (this.lagometerActive) {
            hashName = name.hashCode();
            if (hashName == HASH_SCHEDULED_EXECUTABLES && name.equals(SCHEDULED_EXECUTABLES)) {
                Lagometer.timerScheduledExecutables.start();
            } else if (hashName == HASH_TICK && name.equals(TICK) && Config.isMinecraftThread()) {
                Lagometer.timerScheduledExecutables.end();
                Lagometer.timerTick.start();
            }
        }
        if (this.fastRender) {
            hashName = name.hashCode();
            if (hashName == HASH_RENDER && name.equals(RENDER)) {
                GlStateManager.clearEnabled = false;
            } else if (hashName == HASH_DISPLAY && name.equals(DISPLAY)) {
                GlStateManager.clearEnabled = true;
            }
        }
        this.field_219903_c.field_219940_a.func_76320_a(name);
        this.field_219904_d.field_219940_a.func_76320_a(name);
    }

    public void func_194340_a(Supplier<String> nameSupplier) {
        this.field_219903_c.field_219940_a.func_194340_a(nameSupplier);
        this.field_219904_d.field_219940_a.func_194340_a(nameSupplier);
    }

    public void func_76319_b() {
        this.field_219903_c.field_219940_a.func_76319_b();
        this.field_219904_d.field_219940_a.func_76319_b();
    }

    public void func_219895_b(String name) {
        int hashName;
        if (this.lagometerActive && (hashName = name.hashCode()) == HASH_SOUND && name.equals(SOUND)) {
            Lagometer.timerTick.end();
        }
        this.field_219903_c.field_219940_a.func_219895_b(name);
        this.field_219904_d.field_219940_a.func_219895_b(name);
    }

    public void func_194339_b(Supplier<String> nameSupplier) {
        this.field_219903_c.field_219940_a.func_194339_b(nameSupplier);
        this.field_219904_d.field_219940_a.func_194339_b(nameSupplier);
    }

    static /* synthetic */ IntSupplier access$100(DebugProfiler x0) {
        return x0.field_219902_b;
    }
}

