/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.LanServerPingThread;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.CryptManager;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameType;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegratedServer
extends MinecraftServer {
    private static final Logger field_147148_h = LogManager.getLogger();
    private final Minecraft field_71349_l;
    private final WorldSettings field_71350_m;
    private boolean field_71348_o;
    private int field_195580_l = -1;
    private LanServerPingThread field_71345_q;
    private UUID field_211528_n;
    private long ticksSaveLast = 0L;
    public World difficultyUpdateWorld = null;
    public BlockPos difficultyUpdatePos = null;
    public DifficultyInstance difficultyLast = null;

    public IntegratedServer(Minecraft p_i564_1_, String p_i564_2_, String p_i564_3_, WorldSettings p_i564_4_, YggdrasilAuthenticationService p_i564_5_, MinecraftSessionService p_i564_6_, GameProfileRepository p_i564_7_, PlayerProfileCache p_i564_8_, IChunkStatusListenerFactory p_i564_9_) {
        super(new File(p_i564_1_.field_71412_D, "saves"), p_i564_1_.func_110437_J(), p_i564_1_.func_184126_aj(), new Commands(false), p_i564_5_, p_i564_6_, p_i564_7_, p_i564_8_, p_i564_9_, p_i564_2_);
        this.func_71224_l(p_i564_1_.func_110432_I().func_111285_a());
        this.func_71246_n(p_i564_3_);
        this.func_71204_b(p_i564_1_.func_71355_q());
        this.func_71194_c(p_i564_4_.func_77167_c());
        this.func_71191_d(256);
        this.func_184105_a((PlayerList)new IntegratedPlayerList(this));
        this.field_71349_l = p_i564_1_;
        this.field_71350_m = this.func_71242_L() ? MinecraftServer.field_213219_c : p_i564_4_;
    }

    public void func_71247_a(String saveName, String worldNameIn, long seed, WorldType type, JsonElement generatorOptions) {
        this.func_71237_c(saveName);
        SaveHandler savehandler = this.func_71254_M().func_197715_a(saveName, (MinecraftServer)this);
        this.func_175584_a(this.func_71270_I(), savehandler);
        WorldInfo worldinfo = savehandler.func_75757_d();
        if (worldinfo == null) {
            worldinfo = new WorldInfo(this.field_71350_m, worldNameIn);
        } else {
            worldinfo.func_76062_a(worldNameIn);
        }
        this.func_195560_a(savehandler.func_75765_b(), worldinfo);
        IChunkStatusListener ichunkstatuslistener = this.field_213220_d.create(11);
        this.func_213194_a(savehandler, worldinfo, this.field_71350_m, ichunkstatuslistener);
        if (this.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_176130_y() == null) {
            this.func_147139_a(this.field_71349_l.field_71474_y.field_74318_M, true);
        }
        this.func_213186_a(ichunkstatuslistener);
    }

    public boolean func_71197_b() throws IOException {
        field_147148_h.info("Starting integrated minecraft server version " + SharedConstants.func_215069_a().getName());
        this.func_71229_d(true);
        this.func_71251_e(true);
        this.func_71257_f(true);
        this.func_71188_g(true);
        this.func_71245_h(true);
        field_147148_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        if (Reflector.ServerLifecycleHooks_handleServerAboutToStart.exists() && !Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerAboutToStart, this)) {
            return false;
        }
        this.func_71247_a(this.func_71270_I(), this.func_71221_J(), this.field_71350_m.func_77160_d(), this.field_71350_m.func_77165_h(), this.field_71350_m.func_205391_j());
        this.func_71205_p(this.func_71214_G() + " - " + this.func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76065_j());
        if (Reflector.ServerLifecycleHooks_handleServerStarting.exists()) {
            return Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerStarting, this);
        }
        return true;
    }

    public void func_71217_p(BooleanSupplier hasTimeLeft) {
        this.onTick();
        boolean flag = this.field_71348_o;
        this.field_71348_o = Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147113_T();
        DebugProfiler debugprofiler = this.func_213185_aS();
        if (!flag && this.field_71348_o) {
            debugprofiler.func_76320_a("autoSave");
            field_147148_h.info("Saving and pausing game...");
            this.func_184103_al().func_72389_g();
            this.func_213211_a(false, false, false);
            debugprofiler.func_76319_b();
        }
        if (!this.field_71348_o) {
            super.func_71217_p(hasTimeLeft);
            int i = Math.max(2, this.field_71349_l.field_71474_y.field_151451_c + -2);
            if (i != this.func_184103_al().func_72395_o()) {
                field_147148_h.info("Changing view distance to {}, from {}", (Object)i, (Object)this.func_184103_al().func_72395_o());
                this.func_184103_al().func_217884_a(i, i - 2);
            }
        }
    }

    public boolean func_71225_e() {
        return false;
    }

    public GameType func_71265_f() {
        return this.field_71350_m.func_77162_e();
    }

    public Difficulty func_147135_j() {
        if (this.field_71349_l.field_71441_e == null) {
            return this.field_71349_l.field_71474_y.field_74318_M;
        }
        return this.field_71349_l.field_71441_e.func_72912_H().func_176130_y();
    }

    public boolean func_71199_h() {
        return this.field_71350_m.func_77158_f();
    }

    public boolean func_195569_l() {
        return true;
    }

    public boolean func_195041_r_() {
        return true;
    }

    public File func_71238_n() {
        return this.field_71349_l.field_71412_D;
    }

    public boolean func_71262_S() {
        return false;
    }

    public boolean func_181035_ah() {
        return false;
    }

    public void func_71228_a(CrashReport report) {
        this.field_71349_l.func_71404_a(report);
    }

    public CrashReport func_71230_b(CrashReport report) {
        report = super.func_71230_b(report);
        report.func_85056_g().func_71507_a("Type", (Object)"Integrated Server (map_client.txt)");
        report.func_85056_g().func_189529_a("Is Modded", () -> {
            String s = ClientBrandRetriever.getClientModName();
            if (!s.equals("vanilla")) {
                return "Definitely; Client brand changed to '" + s + "'";
            }
            s = this.getServerModName();
            if (!"vanilla".equals(s)) {
                return "Definitely; Server brand changed to '" + s + "'";
            }
            return Minecraft.class.getSigners() == null ? "Very likely; Jar signature invalidated" : "Probably not. Jar signature remains and both client + server brands are untouched.";
        });
        return report;
    }

    public void func_70000_a(Snooper snooper) {
        super.func_70000_a(snooper);
        snooper.func_152768_a("snooper_partner", (Object)this.field_71349_l.func_71378_E().func_80006_f());
    }

    public boolean func_195565_a(GameType gameMode, boolean cheats, int port) {
        try {
            this.func_147137_ag().func_151265_a((InetAddress)null, port);
            field_147148_h.info("Started serving on {}", (Object)port);
            this.field_195580_l = port;
            this.field_71345_q = new LanServerPingThread(this.func_71273_Y(), port + "");
            this.field_71345_q.start();
            this.func_184103_al().func_152604_a(gameMode);
            this.func_184103_al().func_72387_b(cheats);
            int i = this.func_211833_a(this.field_71349_l.field_71439_g.func_146103_bH());
            this.field_71349_l.field_71439_g.func_184839_n(i);
            for (ServerPlayerEntity serverplayerentity : this.func_184103_al().func_181057_v()) {
                this.func_195571_aL().func_197051_a(serverplayerentity);
            }
            return true;
        }
        catch (IOException var7) {
            return false;
        }
    }

    public void func_71260_j() {
        super.func_71260_j();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    public void func_71263_m(boolean waitForServer) {
        if (!Reflector.MinecraftForge.exists() || this.func_71278_l()) {
            this.func_213167_f(() -> {
                for (ServerPlayerEntity serverplayerentity : Lists.newArrayList((Iterable)this.func_184103_al().func_181057_v())) {
                    if (serverplayerentity.func_110124_au().equals(this.field_211528_n)) continue;
                    this.func_184103_al().func_72367_e(serverplayerentity);
                }
            });
        }
        super.func_71263_m(waitForServer);
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    public boolean func_71344_c() {
        return this.field_195580_l > -1;
    }

    public int func_71215_F() {
        return this.field_195580_l;
    }

    public void func_71235_a(GameType gameMode) {
        super.func_71235_a(gameMode);
        this.func_184103_al().func_152604_a(gameMode);
    }

    public boolean func_82356_Z() {
        return true;
    }

    public int func_110455_j() {
        return 2;
    }

    public void func_211527_b(UUID uuid) {
        this.field_211528_n = uuid;
    }

    public boolean func_213199_b(GameProfile profileIn) {
        return profileIn.getName().equalsIgnoreCase(this.func_71214_G());
    }

    private void onTick() {
        Iterable iws = this.func_212370_w();
        for (ServerWorld ws : iws) {
            this.onTick(ws);
        }
    }

    private void onTick(ServerWorld ws) {
        if (!Config.isTimeDefault()) {
            this.fixWorldTime(ws);
        }
        if (!Config.isWeatherEnabled()) {
            this.fixWorldWeather(ws);
        }
        if (this.difficultyUpdateWorld == ws && this.difficultyUpdatePos != null) {
            this.difficultyLast = ws.func_175649_E(this.difficultyUpdatePos);
            this.difficultyUpdateWorld = null;
            this.difficultyUpdatePos = null;
        }
    }

    public DifficultyInstance getDifficultyAsync(World world, BlockPos blockPos) {
        this.difficultyUpdateWorld = world;
        this.difficultyUpdatePos = blockPos;
        return this.difficultyLast;
    }

    private void fixWorldWeather(ServerWorld ws) {
        WorldInfo worldInfo = ws.func_72912_H();
        if (worldInfo.func_76059_o() || worldInfo.func_76061_m()) {
            worldInfo.func_76080_g(0);
            worldInfo.func_76084_b(false);
            ws.func_72894_k(0.0f);
            worldInfo.func_76090_f(0);
            worldInfo.func_76069_a(false);
            ws.func_147442_i(0.0f);
            this.func_184103_al().func_148540_a((IPacket)new SChangeGameStatePacket(2, 0.0f));
            this.func_184103_al().func_148540_a((IPacket)new SChangeGameStatePacket(7, 0.0f));
            this.func_184103_al().func_148540_a((IPacket)new SChangeGameStatePacket(8, 0.0f));
        }
    }

    private void fixWorldTime(ServerWorld ws) {
        WorldInfo worldInfo = ws.func_72912_H();
        if (worldInfo.func_76077_q().func_77148_a() != 1) {
            return;
        }
        long time = ws.func_72820_D();
        long timeOfDay = time % 24000L;
        if (Config.isTimeDayOnly()) {
            if (timeOfDay <= 1000L) {
                ws.func_72877_b(time - timeOfDay + 1001L);
            }
            if (timeOfDay >= 11000L) {
                ws.func_72877_b(time - timeOfDay + 24001L);
            }
        }
        if (Config.isTimeNightOnly()) {
            if (timeOfDay <= 14000L) {
                ws.func_72877_b(time - timeOfDay + 14001L);
            }
            if (timeOfDay >= 22000L) {
                ws.func_72877_b(time - timeOfDay + 24000L + 14001L);
            }
        }
    }

    public boolean func_213211_a(boolean silentIn, boolean flushIn, boolean commandIn) {
        if (silentIn) {
            int ticksSaveInterval;
            int ticks = this.func_71259_af();
            if ((long)ticks < this.ticksSaveLast + (long)(ticksSaveInterval = this.field_71349_l.field_71474_y.ofAutoSaveTicks)) {
                return false;
            }
            this.ticksSaveLast = ticks;
        }
        return super.func_213211_a(silentIn, flushIn, commandIn);
    }
}

