/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.Random;
import java.util.UUID;
import java.util.function.IntPredicate;
import net.minecraft.util.Util;
import net.minecraft.util.math.Vec3i;
import net.optifine.util.MathUtils;
import org.apache.commons.lang3.math.NumberUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MathHelper {
    public static final float field_180189_a = MathHelper.func_76129_c((float)2.0f);
    private static final int SIN_BITS = 12;
    private static final int SIN_MASK = 4095;
    private static final int SIN_COUNT = 4096;
    private static final int SIN_COUNT_D4 = 1024;
    public static final float PI = MathUtils.roundToFloat(Math.PI);
    public static final float PI2 = MathUtils.roundToFloat(Math.PI * 2);
    public static final float PId2 = MathUtils.roundToFloat(1.5707963267948966);
    private static final float radToIndex = MathUtils.roundToFloat(651.8986469044033);
    public static final float deg2Rad = MathUtils.roundToFloat(Math.PI / 180);
    private static final float[] SIN_TABLE_FAST = new float[4096];
    public static boolean fastMath = false;
    private static final float[] field_76144_a = (float[])Util.func_200696_a((Object)new float[65536], p_203445_0_ -> {
        for (int i = 0; i < ((float[])p_203445_0_).length; ++i) {
            p_203445_0_[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    });
    private static final Random field_188211_c = new Random();
    private static final int[] field_151242_b = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    private static final double field_181163_d = Double.longBitsToDouble(4805340802404319232L);
    private static final double[] field_181164_e = new double[257];
    private static final double[] field_181165_f = new double[257];

    public static float func_76126_a(float value) {
        if (fastMath) {
            return SIN_TABLE_FAST[(int)(value * radToIndex) & 0xFFF];
        }
        return field_76144_a[(int)(value * 10430.378f) & 0xFFFF];
    }

    public static float func_76134_b(float value) {
        if (fastMath) {
            return SIN_TABLE_FAST[(int)(value * radToIndex + 1024.0f) & 0xFFF];
        }
        return field_76144_a[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float func_76129_c(float value) {
        return (float)Math.sqrt(value);
    }

    public static float func_76133_a(double value) {
        return (float)Math.sqrt(value);
    }

    public static int func_76141_d(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static int func_76140_b(double value) {
        return (int)(value + 1024.0) - 1024;
    }

    public static int func_76128_c(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static long func_76124_d(double value) {
        long i = (long)value;
        return value < (double)i ? i - 1L : i;
    }

    public static int func_207806_e(double value) {
        return (int)(value >= 0.0 ? value : -value + 1.0);
    }

    public static float func_76135_e(float value) {
        return Math.abs(value);
    }

    public static int func_76130_a(int value) {
        return Math.abs(value);
    }

    public static int func_76123_f(float value) {
        int i = (int)value;
        return value > (float)i ? i + 1 : i;
    }

    public static int func_76143_f(double value) {
        int i = (int)value;
        return value > (double)i ? i + 1 : i;
    }

    public static int func_76125_a(int num, int min, int max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static float func_76131_a(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static double func_151237_a(double num, double min, double max) {
        if (num < min) {
            return min;
        }
        return num > max ? max : num;
    }

    public static double func_151238_b(double lowerBnd, double upperBnd, double slide) {
        if (slide < 0.0) {
            return lowerBnd;
        }
        return slide > 1.0 ? upperBnd : MathHelper.func_219803_d((double)slide, (double)lowerBnd, (double)upperBnd);
    }

    public static double func_76132_a(double p_76132_0_, double p_76132_2_) {
        if (p_76132_0_ < 0.0) {
            p_76132_0_ = -p_76132_0_;
        }
        if (p_76132_2_ < 0.0) {
            p_76132_2_ = -p_76132_2_;
        }
        return p_76132_0_ > p_76132_2_ ? p_76132_0_ : p_76132_2_;
    }

    public static int func_76137_a(int p_76137_0_, int p_76137_1_) {
        return Math.floorDiv(p_76137_0_, p_76137_1_);
    }

    public static int func_76136_a(Random random, int minimum, int maximum) {
        return minimum >= maximum ? minimum : random.nextInt(maximum - minimum + 1) + minimum;
    }

    public static float func_151240_a(Random random, float minimum, float maximum) {
        return minimum >= maximum ? minimum : random.nextFloat() * (maximum - minimum) + minimum;
    }

    public static double func_82716_a(Random random, double minimum, double maximum) {
        return minimum >= maximum ? minimum : random.nextDouble() * (maximum - minimum) + minimum;
    }

    public static double func_76127_a(long[] values) {
        long i = 0L;
        for (long j : values) {
            i += j;
        }
        return (double)i / (double)values.length;
    }

    public static boolean func_180185_a(float x, float y) {
        return Math.abs(y - x) < 1.0E-5f;
    }

    public static boolean func_219806_b(double x, double y) {
        return Math.abs(y - x) < (double)1.0E-5f;
    }

    public static int func_180184_b(int p_180184_0_, int p_180184_1_) {
        return Math.floorMod(p_180184_0_, p_180184_1_);
    }

    public static float func_188207_b(float numerator, float denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static double func_191273_b(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static int func_188209_b(int angle) {
        int i = angle % 360;
        if (i >= 180) {
            i -= 360;
        }
        if (i < -180) {
            i += 360;
        }
        return i;
    }

    public static float func_76142_g(float value) {
        float f = value % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static double func_76138_g(double value) {
        double d0 = value % 360.0;
        if (d0 >= 180.0) {
            d0 -= 360.0;
        }
        if (d0 < -180.0) {
            d0 += 360.0;
        }
        return d0;
    }

    public static float func_203302_c(float p_203302_0_, float p_203302_1_) {
        return MathHelper.func_76142_g((float)(p_203302_1_ - p_203302_0_));
    }

    public static float func_203301_d(float p_203301_0_, float p_203301_1_) {
        return MathHelper.func_76135_e((float)MathHelper.func_203302_c((float)p_203301_0_, (float)p_203301_1_));
    }

    public static float func_219800_b(float p_219800_0_, float p_219800_1_, float p_219800_2_) {
        float f = MathHelper.func_203302_c((float)p_219800_0_, (float)p_219800_1_);
        float f1 = MathHelper.func_76131_a((float)f, (float)(-p_219800_2_), (float)p_219800_2_);
        return p_219800_1_ - f1;
    }

    public static float func_203300_b(float p_203300_0_, float p_203300_1_, float p_203300_2_) {
        p_203300_2_ = MathHelper.func_76135_e((float)p_203300_2_);
        return p_203300_0_ < p_203300_1_ ? MathHelper.func_76131_a((float)(p_203300_0_ + p_203300_2_), (float)p_203300_0_, (float)p_203300_1_) : MathHelper.func_76131_a((float)(p_203300_0_ - p_203300_2_), (float)p_203300_1_, (float)p_203300_0_);
    }

    public static float func_203303_c(float p_203303_0_, float p_203303_1_, float p_203303_2_) {
        float f = MathHelper.func_203302_c((float)p_203303_0_, (float)p_203303_1_);
        return MathHelper.func_203300_b((float)p_203303_0_, (float)(p_203303_0_ + f), (float)p_203303_2_);
    }

    public static int func_82715_a(String value, int defaultValue) {
        return NumberUtils.toInt((String)value, (int)defaultValue);
    }

    public static int func_82714_a(String value, int defaultValue, int max) {
        return Math.max(max, MathHelper.func_82715_a((String)value, (int)defaultValue));
    }

    public static double func_207805_a(String value, double defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (Throwable var4) {
            return defaultValue;
        }
    }

    public static double func_207804_a(String value, double defaultValue, double max) {
        return Math.max(max, MathHelper.func_207805_a((String)value, (double)defaultValue));
    }

    public static int func_151236_b(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    private static boolean func_151235_d(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int func_151241_e(int value) {
        value = MathHelper.func_151235_d((int)value) ? value : MathHelper.func_151236_b((int)value);
        return field_151242_b[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int func_151239_c(int value) {
        return MathHelper.func_151241_e((int)value) - (MathHelper.func_151235_d((int)value) ? 0 : 1);
    }

    public static int func_154354_b(int number, int interval) {
        int i;
        if (interval == 0) {
            return 0;
        }
        if (number == 0) {
            return interval;
        }
        if (number < 0) {
            interval *= -1;
        }
        return (i = number % interval) == 0 ? number : number + interval - i;
    }

    public static int func_180183_b(float rIn, float gIn, float bIn) {
        return MathHelper.func_180181_b((int)MathHelper.func_76141_d((float)(rIn * 255.0f)), (int)MathHelper.func_76141_d((float)(gIn * 255.0f)), (int)MathHelper.func_76141_d((float)(bIn * 255.0f)));
    }

    public static int func_180181_b(int rIn, int gIn, int bIn) {
        int lvt_3_1_ = (rIn << 8) + gIn;
        lvt_3_1_ = (lvt_3_1_ << 8) + bIn;
        return lvt_3_1_;
    }

    public static int func_180188_d(int p_180188_0_, int p_180188_1_) {
        int i = (p_180188_0_ & 0xFF0000) >> 16;
        int j = (p_180188_1_ & 0xFF0000) >> 16;
        int k = (p_180188_0_ & 0xFF00) >> 8;
        int l2 = (p_180188_1_ & 0xFF00) >> 8;
        int i1 = (p_180188_0_ & 0xFF) >> 0;
        int j1 = (p_180188_1_ & 0xFF) >> 0;
        int k1 = (int)((float)i * (float)j / 255.0f);
        int l1 = (int)((float)k * (float)l2 / 255.0f);
        int i2 = (int)((float)i1 * (float)j1 / 255.0f);
        return p_180188_0_ & 0xFF000000 | k1 << 16 | l1 << 8 | i2;
    }

    public static double func_181162_h(double number) {
        return number - (double)MathHelper.func_76124_d((double)number);
    }

    public static long func_180186_a(Vec3i pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    public static long func_180187_c(int x, int y, int z) {
        long i = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        i = i * i * 42317861L + i * 11L;
        return i >> 16;
    }

    public static UUID func_180182_a(Random rand) {
        long i = rand.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long j = rand.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(i, j);
    }

    public static UUID func_188210_a() {
        return MathHelper.func_180182_a((Random)field_188211_c);
    }

    public static double func_181160_c(double p_181160_0_, double p_181160_2_, double p_181160_4_) {
        return (p_181160_0_ - p_181160_2_) / (p_181160_4_ - p_181160_2_);
    }

    public static double func_181159_b(double p_181159_0_, double p_181159_2_) {
        boolean flag2;
        boolean flag1;
        boolean flag;
        double d0 = p_181159_2_ * p_181159_2_ + p_181159_0_ * p_181159_0_;
        if (Double.isNaN(d0)) {
            return Double.NaN;
        }
        boolean bl = flag = p_181159_0_ < 0.0;
        if (flag) {
            p_181159_0_ = -p_181159_0_;
        }
        boolean bl2 = flag1 = p_181159_2_ < 0.0;
        if (flag1) {
            p_181159_2_ = -p_181159_2_;
        }
        boolean bl3 = flag2 = p_181159_0_ > p_181159_2_;
        if (flag2) {
            double d1 = p_181159_2_;
            p_181159_2_ = p_181159_0_;
            p_181159_0_ = d1;
        }
        double d9 = MathHelper.func_181161_i((double)d0);
        p_181159_2_ *= d9;
        double d2 = field_181163_d + (p_181159_0_ *= d9);
        int i = (int)Double.doubleToRawLongBits(d2);
        double d3 = field_181164_e[i];
        double d4 = field_181165_f[i];
        double d5 = d2 - field_181163_d;
        double d6 = p_181159_0_ * d4 - p_181159_2_ * d5;
        double d7 = (6.0 + d6 * d6) * d6 * 0.16666666666666666;
        double d8 = d3 + d7;
        if (flag2) {
            d8 = 1.5707963267948966 - d8;
        }
        if (flag1) {
            d8 = Math.PI - d8;
        }
        if (flag) {
            d8 = -d8;
        }
        return d8;
    }

    public static double func_181161_i(double p_181161_0_) {
        double d0 = 0.5 * p_181161_0_;
        long i = Double.doubleToRawLongBits(p_181161_0_);
        i = 6910469410427058090L - (i >> 1);
        p_181161_0_ = Double.longBitsToDouble(i);
        p_181161_0_ *= 1.5 - d0 * p_181161_0_ * p_181161_0_;
        return p_181161_0_;
    }

    public static int func_181758_c(float hue, float saturation, float value) {
        float f6;
        float f5;
        float f4;
        int i = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)i;
        float f1 = value * (1.0f - saturation);
        float f2 = value * (1.0f - f * saturation);
        float f3 = value * (1.0f - (1.0f - f) * saturation);
        switch (i) {
            case 0: {
                f4 = value;
                f5 = f3;
                f6 = f1;
                break;
            }
            case 1: {
                f4 = f2;
                f5 = value;
                f6 = f1;
                break;
            }
            case 2: {
                f4 = f1;
                f5 = value;
                f6 = f3;
                break;
            }
            case 3: {
                f4 = f1;
                f5 = f2;
                f6 = value;
                break;
            }
            case 4: {
                f4 = f3;
                f5 = f1;
                f6 = value;
                break;
            }
            case 5: {
                f4 = value;
                f5 = f1;
                f6 = f2;
                break;
            }
            default: {
                throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
            }
        }
        int j = MathHelper.func_76125_a((int)((int)(f4 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f5 * 255.0f)), (int)0, (int)255);
        int l2 = MathHelper.func_76125_a((int)((int)(f6 * 255.0f)), (int)0, (int)255);
        return j << 16 | k << 8 | l2;
    }

    public static int func_188208_f(int p_188208_0_) {
        p_188208_0_ ^= p_188208_0_ >>> 16;
        p_188208_0_ *= -2048144789;
        p_188208_0_ ^= p_188208_0_ >>> 13;
        p_188208_0_ *= -1028477387;
        p_188208_0_ ^= p_188208_0_ >>> 16;
        return p_188208_0_;
    }

    public static int func_199093_a(int min, int max, IntPredicate isTargetBeforeOrAt) {
        int i = max - min;
        while (i > 0) {
            int j = i / 2;
            int k = min + j;
            if (isTargetBeforeOrAt.test(k)) {
                i = j;
                continue;
            }
            min = k + 1;
            i -= j + 1;
        }
        return min;
    }

    public static float func_219799_g(float weight, float x1, float x2) {
        return x1 + weight * (x2 - x1);
    }

    public static double func_219803_d(double weight, double d1, double d2) {
        return d1 + weight * (d2 - d1);
    }

    public static double func_219804_a(double p_219804_0_, double p_219804_2_, double p_219804_4_, double p_219804_6_, double p_219804_8_, double p_219804_10_) {
        return MathHelper.func_219803_d((double)p_219804_2_, (double)MathHelper.func_219803_d((double)p_219804_0_, (double)p_219804_4_, (double)p_219804_6_), (double)MathHelper.func_219803_d((double)p_219804_0_, (double)p_219804_8_, (double)p_219804_10_));
    }

    public static double func_219807_a(double p_219807_0_, double p_219807_2_, double p_219807_4_, double p_219807_6_, double p_219807_8_, double p_219807_10_, double p_219807_12_, double p_219807_14_, double p_219807_16_, double p_219807_18_, double p_219807_20_) {
        return MathHelper.func_219803_d((double)p_219807_4_, (double)MathHelper.func_219804_a((double)p_219807_0_, (double)p_219807_2_, (double)p_219807_6_, (double)p_219807_8_, (double)p_219807_10_, (double)p_219807_12_), (double)MathHelper.func_219804_a((double)p_219807_0_, (double)p_219807_2_, (double)p_219807_14_, (double)p_219807_16_, (double)p_219807_18_, (double)p_219807_20_));
    }

    public static double func_219801_j(double p_219801_0_) {
        return p_219801_0_ * p_219801_0_ * p_219801_0_ * (p_219801_0_ * (p_219801_0_ * 6.0 - 15.0) + 10.0);
    }

    public static int func_219802_k(double x) {
        if (x == 0.0) {
            return 0;
        }
        return x > 0.0 ? 1 : -1;
    }

    public static float func_219805_h(float p_219805_0_, float p_219805_1_, float p_219805_2_) {
        return p_219805_1_ + p_219805_0_ * MathHelper.func_76142_g((float)(p_219805_2_ - p_219805_1_));
    }

    static {
        for (int i = 0; i < 257; ++i) {
            double d0 = (double)i / 256.0;
            double d1 = Math.asin(d0);
            MathHelper.field_181165_f[i] = Math.cos(d1);
            MathHelper.field_181164_e[i] = d1;
        }
        for (int s = 0; s < SIN_TABLE_FAST.length; ++s) {
            MathHelper.SIN_TABLE_FAST[s] = MathUtils.roundToFloat(Math.sin((double)s * Math.PI * 2.0 / 4096.0));
        }
    }
}

