/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.BlockStatePaletteRegistry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.optifine.ChunkDataOF;
import net.optifine.ChunkSectionDataOF;
import net.optifine.reflect.Reflector;

public class ChunkSection {
    private static final IBlockStatePalette<BlockState> field_205512_a = new BlockStatePaletteRegistry(Block.field_176229_d, (Object)Blocks.field_150350_a.func_176223_P());
    private final int field_76684_a;
    private short field_76682_b;
    private short field_76683_c;
    private short field_206918_e;
    private final BlockStateContainer<BlockState> field_177488_d;
    public static final ThreadLocal<ChunkDataOF> THREAD_CHUNK_DATA_OF = new ThreadLocal();

    public ChunkSection(int p_i2422_1_) {
        this(p_i2422_1_, 0, 0, 0);
    }

    public ChunkSection(int p_i2423_1_, short p_i2423_2_, short p_i2423_3_, short p_i2423_4_) {
        this.field_76684_a = p_i2423_1_;
        this.field_76682_b = p_i2423_2_;
        this.field_76683_c = p_i2423_3_;
        this.field_206918_e = p_i2423_4_;
        this.field_177488_d = new BlockStateContainer(field_205512_a, Block.field_176229_d, NBTUtil::func_190008_d, NBTUtil::func_190009_a, (Object)Blocks.field_150350_a.func_176223_P());
    }

    public BlockState func_177485_a(int x, int y, int z) {
        return (BlockState)this.field_177488_d.func_186016_a(x, y, z);
    }

    public IFluidState func_206914_b(int x, int y, int z) {
        return ((BlockState)this.field_177488_d.func_186016_a(x, y, z)).func_204520_s();
    }

    public void func_222635_a() {
        this.field_177488_d.func_210459_b();
    }

    public void func_222637_b() {
        this.field_177488_d.func_210460_c();
    }

    public BlockState func_222629_a(int x, int y, int z, BlockState blockState) {
        return this.func_177484_a(x, y, z, blockState, true);
    }

    public BlockState func_177484_a(int x, int y, int z, BlockState state, boolean locked) {
        if (Reflector.IExtendedBlockState.isInstance(state)) {
            state = (BlockState)Reflector.call(state, Reflector.IExtendedBlockState_getClean, new Object[0]);
        }
        BlockState blockstate = locked ? (BlockState)this.field_177488_d.func_222641_a(x, y, z, (Object)state) : (BlockState)this.field_177488_d.func_222639_b(x, y, z, (Object)state);
        IFluidState ifluidstate = blockstate.func_204520_s();
        IFluidState ifluidstate1 = state.func_204520_s();
        if (!blockstate.func_196958_f()) {
            this.field_76682_b = (short)(this.field_76682_b - 1);
            if (blockstate.func_204519_t()) {
                this.field_76683_c = (short)(this.field_76683_c - 1);
            }
        }
        if (!ifluidstate.func_206888_e()) {
            this.field_206918_e = (short)(this.field_206918_e - 1);
        }
        if (!state.func_196958_f()) {
            this.field_76682_b = (short)(this.field_76682_b + 1);
            if (state.func_204519_t()) {
                this.field_76683_c = (short)(this.field_76683_c + 1);
            }
        }
        if (!ifluidstate1.func_206888_e()) {
            this.field_206918_e = (short)(this.field_206918_e + 1);
        }
        return blockstate;
    }

    public boolean func_76663_a() {
        return this.field_76682_b == 0;
    }

    public static boolean func_222628_a(@Nullable ChunkSection p_222628_0_) {
        return p_222628_0_ == Chunk.field_186036_a || p_222628_0_.func_76663_a();
    }

    public boolean func_206915_b() {
        return this.func_76675_b() || this.func_206917_d();
    }

    public boolean func_76675_b() {
        return this.field_76683_c > 0;
    }

    public boolean func_206917_d() {
        return this.field_206918_e > 0;
    }

    public int func_222632_g() {
        return this.field_76684_a;
    }

    public void func_76672_e() {
        ChunkSectionDataOF csd;
        int index;
        ChunkSectionDataOF[] csds;
        ChunkDataOF chunkDataOF = (ChunkDataOF)THREAD_CHUNK_DATA_OF.get();
        if (chunkDataOF != null && (csds = chunkDataOF.getChunkSectionDatas()) != null && (index = this.field_76684_a >> 4) >= 0 && index < csds.length && (csd = csds[index]) != null) {
            this.field_76682_b = csd.getBlockRefCount();
            this.field_76683_c = csd.getTickRefCount();
            this.field_206918_e = csd.getFluidRefCount();
            csds[index] = null;
            return;
        }
        short localBlockRefCount = 0;
        short localTickRefCount = 0;
        short localFluidRefCount = 0;
        for (int i = 0; i < 4096; ++i) {
            BlockState blockstate = (BlockState)this.field_177488_d.func_186015_a(i);
            IFluidState ifluidstate = blockstate.func_204520_s();
            if (!blockstate.func_196958_f()) {
                localBlockRefCount = (short)(localBlockRefCount + 1);
                if (blockstate.func_204519_t()) {
                    localTickRefCount = (short)(localTickRefCount + 1);
                }
            }
            if (ifluidstate.func_206888_e()) continue;
            localBlockRefCount = (short)(localBlockRefCount + 1);
            if (!ifluidstate.func_206890_h()) continue;
            localFluidRefCount = (short)(localFluidRefCount + 1);
        }
        this.field_76682_b = localBlockRefCount;
        this.field_76683_c = localTickRefCount;
        this.field_206918_e = localFluidRefCount;
    }

    public BlockStateContainer<BlockState> func_186049_g() {
        return this.field_177488_d;
    }

    public void func_222634_a(PacketBuffer packetBufferIn) {
        this.field_76682_b = packetBufferIn.readShort();
        this.field_177488_d.func_186010_a(packetBufferIn);
    }

    public void func_222630_b(PacketBuffer packetBufferIn) {
        packetBufferIn.writeShort((int)this.field_76682_b);
        this.field_177488_d.func_186009_b(packetBufferIn);
    }

    public int func_222633_j() {
        return 2 + this.field_177488_d.func_186018_a();
    }

    public boolean func_222636_a(BlockState p_222636_1_) {
        return this.field_177488_d.func_222640_a((Object)p_222636_1_);
    }

    public short getBlockRefCount() {
        return this.field_76682_b;
    }

    public short getTickRefCount() {
        return this.field_76683_c;
    }

    public short getFluidRefCount() {
        return this.field_206918_e;
    }
}

