/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static duj spriteGrass = null;
    private static duj spriteGrassSide = null;
    private static duj spriteGrassPath = null;
    private static duj spriteGrassPathSide = null;
    private static duj spriteMycelium = null;
    private static duj spritePodzol = null;
    private static duj spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static dvx modelCubeGrass = null;
    private static dvx modelGrassPath = null;
    private static dvx modelCubeGrassPath = null;
    private static dvx modelCubeMycelium = null;
    private static dvx modelCubePodzol = null;
    private static dvx modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "block/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "block/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(dui textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            dvx modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(dui textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new qs(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new qs(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.registerSprite(new qs(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.registerSprite(new qs(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new qs(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new qs(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.registerSprite(new qs(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            qs locFile = new qs(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e2) {
            Config.warn("Error reading: " + name + ", " + e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    private static duj registerSprite(Properties props, String key, String textureDefault, dui textureMap) {
        qs locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new qs("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        qs locSprite = new qs(texture);
        duj sprite = textureMap.registerSprite(locSprite);
        return sprite;
    }

    public static List getFaceQuads(bgq blockAccess, bvk blockState, ev blockPos, fa facing, List quads) {
        if (facing == fa.b || facing == fa.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        bmm block = blockState.d();
        if (block instanceof bpz) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bow) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bmn.l) {
            return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bmn.j) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bov) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(bgq blockAccess, bvk blockState, ev blockPos, fa facing, List quads) {
        boolean snowy;
        bmm blockUp = blockAccess.e_(blockPos.b()).d();
        boolean bl = snowy = blockUp == bmn.cC || blockUp == bmn.cA;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmn.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmn.dL) {
                return modelCubeMycelium.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(bgq blockAccess, bvk blockState, ev blockPos, fa facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmn.iw) {
                return modelGrassPath.a(blockState, facing, RANDOM);
            }
        } else {
            return modelGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsPodzol(bgq blockAccess, bvk blockState, ev blockPos, fa facing, List quads) {
        boolean snowy;
        bmm blockTop = BetterGrass.getBlockAt(blockPos, fa.b, blockAccess);
        boolean bl = snowy = blockTop == bmn.cC || blockTop == bmn.cA;
        if (Config.isBetterGrassFancy()) {
            ev posSide;
            bvk stateSide;
            if (snowy) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmn.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (stateSide = blockAccess.e_(posSide = blockPos.c().a(facing))).d() == bmn.l) {
                return modelCubePodzol.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterPodzolSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(bgq blockAccess, bvk blockState, ev blockPos, fa facing, List quads) {
        bmm blockTop = BetterGrass.getBlockAt(blockPos, fa.b, blockAccess);
        if (blockTop == bmn.iw && betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmn.iw) {
            return modelCubeGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrass(bgq blockAccess, bvk blockState, ev blockPos, fa facing, List quads) {
        boolean snowy;
        bmm blockUp = blockAccess.e_(blockPos.b()).d();
        boolean bl = snowy = blockUp == bmn.cC || blockUp == bmn.cA;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmn.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmn.i) {
                return modelCubeGrass.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static bmm getBlockAt(ev blockPos, fa facing, bgq blockAccess) {
        ev pos = blockPos.a(facing);
        bmm block = blockAccess.e_(pos).d();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

