/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

public class Json {
    public static float getFloat(JsonObject obj, String field, float def2) {
        JsonElement elem = obj.get(field);
        if (elem == null) {
            return def2;
        }
        return elem.getAsFloat();
    }

    public static boolean getBoolean(JsonObject obj, String field, boolean def2) {
        JsonElement elem = obj.get(field);
        if (elem == null) {
            return def2;
        }
        return elem.getAsBoolean();
    }

    public static String getString(JsonObject jsonObj, String field) {
        return Json.getString(jsonObj, field, null);
    }

    public static String getString(JsonObject jsonObj, String field, String def2) {
        JsonElement jsonElement = jsonObj.get(field);
        if (jsonElement == null) {
            return def2;
        }
        return jsonElement.getAsString();
    }

    public static float[] parseFloatArray(JsonElement jsonElement, int len) {
        return Json.parseFloatArray(jsonElement, len, null);
    }

    public static float[] parseFloatArray(JsonElement jsonElement, int len, float[] def2) {
        if (jsonElement == null) {
            return def2;
        }
        JsonArray arr2 = jsonElement.getAsJsonArray();
        if (arr2.size() != len) {
            throw new JsonParseException("Wrong array length: " + arr2.size() + ", should be: " + len + ", array: " + arr2);
        }
        float[] floatArr = new float[arr2.size()];
        for (int i = 0; i < floatArr.length; ++i) {
            floatArr[i] = arr2.get(i).getAsFloat();
        }
        return floatArr;
    }

    public static int[] parseIntArray(JsonElement jsonElement, int len) {
        return Json.parseIntArray(jsonElement, len, null);
    }

    public static int[] parseIntArray(JsonElement jsonElement, int len, int[] def2) {
        if (jsonElement == null) {
            return def2;
        }
        JsonArray arr2 = jsonElement.getAsJsonArray();
        if (arr2.size() != len) {
            throw new JsonParseException("Wrong array length: " + arr2.size() + ", should be: " + len + ", array: " + arr2);
        }
        int[] intArr = new int[arr2.size()];
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = arr2.get(i).getAsInt();
        }
        return intArr;
    }
}

