/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.optifine.BetterGrass;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomItems;
import net.optifine.CustomLoadingScreens;
import net.optifine.CustomPanorama;
import net.optifine.CustomSky;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.SmartLeaves;
import net.optifine.TextureAnimations;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.Shaders;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static final String texGrassTop = "grass_block_top";
    private static final String texGrassSide = "grass_block_side";
    private static final String texGrassSideOverlay = "grass_block_side_overlay";
    private static final String texSnow = "snow";
    private static final String texGrassSideSnowed = "grass_block_snow";
    private static final String texMyceliumSide = "mycelium_side";
    private static final String texMyceliumTop = "mycelium_top";
    private static final String texWaterStill = "water_still";
    private static final String texWaterFlow = "water_flow";
    private static final String texLavaStill = "lava_still";
    private static final String texLavaFlow = "lava_flow";
    private static final String texFireLayer0 = "fire_0";
    private static final String texFireLayer1 = "fire_1";
    private static final String texPortal = "nether_portal";
    private static final String texGlass = "glass";
    private static final String texGlassPaneTop = "glass_pane_top";
    public static dxb iconGrassTop;
    public static dxb iconGrassSide;
    public static dxb iconGrassSideOverlay;
    public static dxb iconSnow;
    public static dxb iconGrassSideSnowed;
    public static dxb iconMyceliumSide;
    public static dxb iconMyceliumTop;
    public static dxb iconWaterStill;
    public static dxb iconWaterFlow;
    public static dxb iconLavaStill;
    public static dxb iconLavaFlow;
    public static dxb iconFireLayer0;
    public static dxb iconFireLayer1;
    public static dxb iconPortal;
    public static dxb iconGlass;
    public static dxb iconGlassPaneTop;
    public static final String SPRITE_PREFIX_BLOCKS = "minecraft:block/";
    public static final String SPRITE_PREFIX_ITEMS = "minecraft:item/";
    private static IntBuffer staticBuffer;
    private static int glMaximumTextureSize;

    public static void update() {
        dxa mapBlocks = TextureUtils.getTextureMapBlocks();
        if (mapBlocks == null) {
            return;
        }
        String prefix = SPRITE_PREFIX_BLOCKS;
        iconGrassTop = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassTop);
        iconGrassSide = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassSide);
        iconGrassSideOverlay = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassSideOverlay);
        iconSnow = TextureUtils.getSpriteCheck(mapBlocks, prefix + texSnow);
        iconGrassSideSnowed = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassSideSnowed);
        iconMyceliumSide = TextureUtils.getSpriteCheck(mapBlocks, prefix + texMyceliumSide);
        iconMyceliumTop = TextureUtils.getSpriteCheck(mapBlocks, prefix + texMyceliumTop);
        iconWaterStill = TextureUtils.getSpriteCheck(mapBlocks, prefix + texWaterStill);
        iconWaterFlow = TextureUtils.getSpriteCheck(mapBlocks, prefix + texWaterFlow);
        iconLavaStill = TextureUtils.getSpriteCheck(mapBlocks, prefix + texLavaStill);
        iconLavaFlow = TextureUtils.getSpriteCheck(mapBlocks, prefix + texLavaFlow);
        iconFireLayer0 = TextureUtils.getSpriteCheck(mapBlocks, prefix + texFireLayer0);
        iconFireLayer1 = TextureUtils.getSpriteCheck(mapBlocks, prefix + texFireLayer1);
        iconPortal = TextureUtils.getSpriteCheck(mapBlocks, prefix + texPortal);
        iconGlass = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGlass);
        iconGlassPaneTop = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGlassPaneTop);
        String prefixItems = SPRITE_PREFIX_ITEMS;
    }

    public static dxb getSpriteCheck(dxa textureMap, String name) {
        dxb sprite = textureMap.a(name);
        if (sprite == null || sprite instanceof dwv) {
            Config.warn("Sprite not found: " + name);
        }
        return sprite;
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static int ceilPowerOfTwo(int val) {
        int i;
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int po2 = 0;
        while (i < val) {
            i *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i = 0; i < power; ++i) {
            val *= 2;
        }
        return val;
    }

    public static dxd getTexture(qv loc) {
        dxd tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new dwx(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(xi rm) {
        if (TextureUtils.getTextureMapBlocks() == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        BetterGrass.update();
        BetterSnow.update();
        TextureAnimations.update();
        CustomColors.update();
        CustomSky.update();
        RandomEntities.update();
        CustomItems.updateModels();
        CustomEntityModels.update();
        Shaders.resourcesReloaded();
        Lang.resourcesReloaded();
        Config.updateTexturePackClouds();
        SmartLeaves.updateLeavesModels();
        CustomPanorama.update();
        CustomGuis.update();
        dvt.update();
        CustomLoadingScreens.update();
        CustomBlockLayers.update();
        Config.getTextureManager().e();
        Config.dbg("Disable Forge light pipeline");
        ReflectorForge.setForgeLightPipelineEnabled(false);
    }

    public static dxa getTextureMapBlocks() {
        return cyc.u().L();
    }

    public static void registerResourceListener() {
        xi rm = Config.getResourceManager();
        if (rm instanceof xg) {
            xg rrm = (xg)rm;
            xl rl = new xl(){

                protected Object b(xi p_212854_1_, agn p_212854_2_) {
                    return null;
                }

                protected void a(Object p_212853_1_, xi p_212853_2_, agn p_212853_3_) {
                }
            };
            rrm.a((xd)rl);
            xj rmrl = new xj(){

                public void a(xi resourceManager) {
                    TextureUtils.resourcesReloaded(resourceManager);
                }
            };
            rrm.a((xd)rmrl);
        }
    }

    public static void registerTickableTextures() {
        dxf tto = new dxf(){

            public void e() {
                TextureAnimations.updateAnimations();
            }

            public void a(xi var1) throws IOException {
            }

            public int c() {
                return 0;
            }

            public void b(boolean p_174936_1, boolean p_174936_2) {
            }

            public void b() {
            }

            public MultiTexID getMultiTexID() {
                return null;
            }
        };
        qv ttol = new qv("optifine/tickable_textures");
        Config.getTextureManager().a(ttol, tto);
    }

    public static qv fixResourceLocation(qv loc, String basePath) {
        if (!loc.b().equals("minecraft")) {
            return loc;
        }
        String path = loc.a();
        String pathFixed = TextureUtils.fixResourcePath(path, basePath);
        if (pathFixed != path) {
            loc = new qv(loc.b(), pathFixed);
        }
        return loc;
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        if (path.startsWith("/~")) {
            path = path.substring(1);
        }
        String strOptifine = "optifine/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strOptifine + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strOptifine + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void applyAnisotropicLevel() {
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    public static void bindTexture(int glTexId) {
        GlStateManager.bindTexture((int)glTexId);
    }

    public static boolean isPowerOfTwo(int x) {
        int x2 = zy.c((int)x);
        return x2 == x;
    }

    public static cuj scaleImage(cuj ni, int w2) {
        BufferedImage bi = TextureUtils.toBufferedImage(ni);
        BufferedImage bi2 = TextureUtils.scaleImage(bi, w2);
        cuj ni2 = TextureUtils.toNativeImage(bi2);
        return ni2;
    }

    public static BufferedImage toBufferedImage(cuj ni) {
        int width = ni.a();
        int height = ni.b();
        int[] data = new int[width * height];
        ni.getBufferRGBA().get(data);
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, width, height, data, 0, width);
        return bi;
    }

    private static cuj toNativeImage(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[] data = new int[width * height];
        bi.getRGB(0, 0, width, height, data, 0, width);
        cuj ni = new cuj(width, height, false);
        ni.getBufferRGBA().put(data);
        return ni;
    }

    public static BufferedImage scaleImage(BufferedImage bi, int w2) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < w || w2 % w != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    public static int scaleToGrid(int size, int sizeGrid) {
        int sizeNew;
        if (size == sizeGrid) {
            return size;
        }
        for (sizeNew = size / sizeGrid * sizeGrid; sizeNew < size; sizeNew += sizeGrid) {
        }
        return sizeNew;
    }

    public static int scaleToMin(int size, int sizeMin) {
        int sizeNew;
        if (size >= sizeMin) {
            return size;
        }
        for (sizeNew = sizeMin / size * size; sizeNew < sizeMin; sizeNew += size) {
        }
        return sizeNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(InputStream in, String suffix) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        while (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(in);
                reader.setInput(iis);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e2) {}
            continue;
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    public static void dbgMipmaps(dxb textureatlassprite) {
        cuj[] mipmapImages = textureatlassprite.getMipmapImages();
        for (int l2 = 0; l2 < mipmapImages.length; ++l2) {
            cuj image = mipmapImages[l2];
            if (image == null) {
                Config.dbg("" + l2 + ": " + image);
                continue;
            }
            Config.dbg("" + l2 + ": " + image.a() * image.b());
        }
    }

    public static void saveGlTexture(String name, int textureId, int mipmapLevels, int width, int height) {
        File filePng;
        TextureUtils.bindTexture(textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        File fileBase = new File(name);
        File dir = fileBase.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        for (int i = 0; i < 16; ++i) {
            filePng = new File(name + "_" + i + ".png");
            filePng.delete();
        }
        for (int level = 0; level <= mipmapLevels; ++level) {
            filePng = new File(name + "_" + level + ".png");
            int widthLevel = width >> level;
            int heightLevel = height >> level;
            int sizeLevel = widthLevel * heightLevel;
            IntBuffer buf2 = BufferUtils.createIntBuffer((int)sizeLevel);
            int[] data = new int[sizeLevel];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buf2);
            buf2.get(data);
            BufferedImage image = new BufferedImage(widthLevel, heightLevel, 2);
            image.setRGB(0, 0, widthLevel, heightLevel, data, 0, widthLevel);
            try {
                ImageIO.write((RenderedImage)image, "png", filePng);
                Config.dbg("Exported: " + filePng);
                continue;
            }
            catch (Exception e2) {
                Config.warn("Error writing: " + filePng);
                Config.warn("" + e2.getClass().getName() + ": " + e2.getMessage());
            }
        }
    }

    public static int getGLMaximumTextureSize() {
        if (glMaximumTextureSize < 0) {
            glMaximumTextureSize = TextureUtils.detectGLMaximumTextureSize();
        }
        return glMaximumTextureSize;
    }

    private static int detectGLMaximumTextureSize() {
        for (int i = 65536; i > 0; i >>= 1) {
            GlStateManager.texImage2D((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, (IntBuffer)null);
            int err = GL11.glGetError();
            int width = GlStateManager.getTexLevelParameter((int)32868, (int)0, (int)4096);
            if (width == 0) continue;
            return i;
        }
        return 0;
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        if (imageStream == null) {
            return null;
        }
        try {
            BufferedImage bufferedimage;
            BufferedImage bufferedImage = bufferedimage = ImageIO.read(imageStream);
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
    }

    public static int toAbgr(int argb) {
        int a2 = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b2 = argb >> 0 & 0xFF;
        int abgr = a2 << 24 | b2 << 16 | g << 8 | r;
        return abgr;
    }

    public static void resetDataUnpacking() {
        GlStateManager.pixelStore((int)3314, (int)0);
        GlStateManager.pixelStore((int)3316, (int)0);
        GlStateManager.pixelStore((int)3315, (int)0);
        GlStateManager.pixelStore((int)3317, (int)4);
    }

    static {
        staticBuffer = Config.createDirectIntBuffer(256);
        glMaximumTextureSize = -1;
    }
}

