/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.util.PropertiesOrdered;

public class ConfigUtils {
    public static String readString(String fileName, String property) {
        Properties props = ConfigUtils.readProperties(fileName);
        if (props == null) {
            return null;
        }
        String val = props.getProperty(property);
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public static Properties readProperties(String fileName) {
        try {
            sm loc = new sm(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            return props;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (IOException e3) {
            Config.warn("Error parsing: " + fileName);
            Config.warn(e3.getClass().getName() + ": " + e3.getMessage());
            return null;
        }
    }
}

