/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");
    private static final Pattern PATTERN_NBT_TEXT = Pattern.compile(".*\"text\":\"([^\"]+)\".*");

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize(tag, ".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(jt nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(jt nbt) {
        if (nbt == null) {
            return false;
        }
        jt tagBase = nbt;
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String tag = this.parents[i2];
            if ((tagBase = NbtTagValue.getChildTag((kj)tagBase, tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((kj)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((kj)tagBase, this.name)) == null) {
            return false;
        }
        return this.matchesBase((kj)tagBase);
    }

    private boolean matchesAnyChild(kj tagBase) {
        if (tagBase instanceof jt) {
            jt tagCompound = (jt)tagBase;
            Set nbtKeySet = tagCompound.d();
            for (String key : nbtKeySet) {
                kj nbtBase = tagCompound.d(key);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof jz) {
            jz tagList = (jz)tagBase;
            int count = tagList.size();
            for (int i2 = 0; i2 < count; ++i2) {
                kj nbtBase = tagList.k(i2);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static kj getChildTag(kj tagBase, String tag) {
        if (tagBase instanceof jt) {
            jt tagCompound = (jt)tagBase;
            return tagCompound.d(tag);
        }
        if (tagBase instanceof jz) {
            jz tagList = (jz)tagBase;
            if (tag.equals("count")) {
                return jy.a((int)tagList.size());
            }
            int index = Config.parseInt(tag, -1);
            if (index < 0 || index >= tagList.size()) {
                return null;
            }
            return tagList.k(index);
        }
        return null;
    }

    public boolean matchesBase(kj nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String nbtValue = NbtTagValue.getNbtString(nbtBase, this.valueFormat);
        return this.matchesValue(nbtValue);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(kj nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof ki) {
            Matcher matcher;
            ki nbtString = (ki)nbtBase;
            String text = nbtString.c_();
            if (text.startsWith("{") && (matcher = PATTERN_NBT_TEXT.matcher(text)).matches()) {
                return matcher.group(1);
            }
            return text;
        }
        if (nbtBase instanceof jy) {
            jy i2 = (jy)nbtBase;
            if (format == 1) {
                return PREFIX_HEX_COLOR + StrUtils.fillLeft(Integer.toHexString(i2.f()), 6, '0');
            }
            return Integer.toString(i2.f());
        }
        if (nbtBase instanceof jr) {
            jr b2 = (jr)nbtBase;
            return Byte.toString(b2.h());
        }
        if (nbtBase instanceof kh) {
            kh s = (kh)nbtBase;
            return Short.toString(s.g());
        }
        if (nbtBase instanceof kb) {
            kb l = (kb)nbtBase;
            return Long.toString(l.e());
        }
        if (nbtBase instanceof jw) {
            jw f2 = (jw)nbtBase;
            return Float.toString(f2.j());
        }
        if (nbtBase instanceof ju) {
            ju d2 = (ju)nbtBase;
            return Double.toString(d2.i());
        }
        return nbtBase.toString();
    }

    public String toString() {
        StringBuffer sb2 = new StringBuffer();
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String parent = this.parents[i2];
            if (i2 > 0) {
                sb2.append(".");
            }
            sb2.append(parent);
        }
        if (sb2.length() > 0) {
            sb2.append(".");
        }
        sb2.append(this.name);
        sb2.append(" = ");
        sb2.append(this.value);
        return sb2.toString();
    }
}

