/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import com.mojang.authlib.exceptions.InvalidCredentialsException;
import java.math.BigInteger;
import java.net.URI;
import java.util.Random;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;

public class GuiScreenCapeOF
extends GuiScreenOF {
    private final dgb parentScreen;
    private String message;
    private long messageHideTimeMs;
    private String linkUrl;
    private GuiButtonOF buttonCopyLink;

    public GuiScreenCapeOF(dgb parentScreenIn) {
        super((lf)new lo(ebd.a((String)"of.options.capeOF.title", (Object[])new Object[0])));
        this.parentScreen = parentScreenIn;
    }

    protected void init() {
        int i2 = 0;
        this.addButton((dct)new GuiButtonOF(210, this.width / 2 - 155, this.height / 6 + 24 * ((i2 += 2) >> 1), 150, 20, ebd.a((String)"of.options.capeOF.openEditor", (Object[])new Object[0])));
        this.addButton((dct)new GuiButtonOF(220, this.width / 2 - 155 + 160, this.height / 6 + 24 * (i2 >> 1), 150, 20, ebd.a((String)"of.options.capeOF.reloadCape", (Object[])new Object[0])));
        this.buttonCopyLink = new GuiButtonOF(230, this.width / 2 - 100, this.height / 6 + 24 * ((i2 += 6) >> 1), 200, 20, ebd.a((String)"of.options.capeOF.copyEditorLink", (Object[])new Object[0]));
        this.buttonCopyLink.visible = this.linkUrl != null;
        this.addButton((dct)this.buttonCopyLink);
        this.addButton((dct)new GuiButtonOF(200, this.width / 2 - 100, this.height / 6 + 24 * ((i2 += 4) >> 1), ebd.a((String)"gui.done", (Object[])new Object[0])));
    }

    @Override
    protected void actionPerformed(dct guiElement) {
        if (!(guiElement instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF button = (GuiButtonOF)guiElement;
        if (button.active) {
            if (button.id == 200) {
                this.minecraft.a(this.parentScreen);
            }
            if (button.id == 210) {
                try {
                    String userName = this.minecraft.E().e().getName();
                    String userId = this.minecraft.E().e().getId().toString().replace("-", "");
                    String accessToken = this.minecraft.E().d();
                    Random r1 = new Random();
                    Random r2 = new Random(System.identityHashCode(new Object()));
                    BigInteger random1Bi = new BigInteger(128, r1);
                    BigInteger random2Bi = new BigInteger(128, r2);
                    BigInteger serverBi = random1Bi.xor(random2Bi);
                    String serverId = serverBi.toString(16);
                    this.minecraft.R().joinServer(this.minecraft.E().e(), accessToken, serverId);
                    String urlStr = "https://optifine.net/capeChange?u=" + userId + "&n=" + userName + "&s=" + serverId;
                    boolean opened = Config.openWebLink(new URI(urlStr));
                    if (opened) {
                        this.showMessage(Lang.get("of.message.capeOF.openEditor"), 10000L);
                    } else {
                        this.showMessage(Lang.get("of.message.capeOF.openEditorError"), 10000L);
                        this.setLinkUrl(urlStr);
                    }
                }
                catch (InvalidCredentialsException e2) {
                    Config.showGuiMessage(ebd.a((String)"of.message.capeOF.error1", (Object[])new Object[0]), ebd.a((String)"of.message.capeOF.error2", (Object[])new Object[]{e2.getMessage()}));
                    Config.warn("Mojang authentication failed");
                    Config.warn(((Object)((Object)e2)).getClass().getName() + ": " + e2.getMessage());
                }
                catch (Exception e3) {
                    Config.warn("Error opening OptiFine cape link");
                    Config.warn(e3.getClass().getName() + ": " + e3.getMessage());
                }
            }
            if (button.id == 220) {
                this.showMessage(Lang.get("of.message.capeOF.reloadCape"), 15000L);
                if (this.minecraft.r != null) {
                    long delayMs = 15000L;
                    long reloadTimeMs = System.currentTimeMillis() + delayMs;
                    this.minecraft.r.setReloadCapeTimeMs(reloadTimeMs);
                }
            }
            if (button.id == 230 && this.linkUrl != null) {
                this.minecraft.l.a(this.linkUrl);
            }
        }
    }

    private void showMessage(String msg, long timeMs) {
        this.message = msg;
        this.messageHideTimeMs = System.currentTimeMillis() + timeMs;
        this.setLinkUrl(null);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.fontRenderer, this.title.e(), this.width / 2, 20, 0xFFFFFF);
        if (this.message != null) {
            this.drawCenteredString(this.fontRenderer, this.message, this.width / 2, this.height / 6 + 60, 0xFFFFFF);
            if (System.currentTimeMillis() > this.messageHideTimeMs) {
                this.message = null;
                this.setLinkUrl(null);
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
        this.buttonCopyLink.visible = linkUrl != null;
    }
}

