/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private aom entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<fu> setLitChunkPos = new HashSet<fu>();
    private fu.a blockPosMutable = new fu.a();

    public DynamicLight(aom entity) {
        this.entity = entity;
        this.offsetY = entity.cd();
    }

    public void update(ebx renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.cC() - 0.5;
        double posY = this.entity.cD() - 0.5 + this.offsetY;
        double posZ = this.entity.cG() - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<fu> setNewPos = new HashSet<fu>();
        if (lightLevel > 0) {
            fz dirX = (aec.c((double)posX) & 0xF) >= 8 ? fz.f : fz.e;
            fz dirY = (aec.c((double)posY) & 0xF) >= 8 ? fz.b : fz.a;
            fz dirZ = (aec.c((double)posZ) & 0xF) >= 8 ? fz.d : fz.c;
            fu chunkPos = new fu(posX, posY, posZ);
            een.c chunk = renderGlobal.getRenderChunk(chunkPos);
            fu chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            een.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            fu chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            een.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            fu chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            een.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            fu chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            een.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            fu chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            een.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            fu chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            een.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            fu chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            een.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private fu getChunkPos(een.c renderChunk, fu pos, fz facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(een.c renderChunk, Set<fu> setPrevPos, Set<fu> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        een.b compiledChunk = renderChunk.c();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        fu pos = renderChunk.e().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(ebx renderGlobal) {
        for (fu posOld : this.setLitChunkPos) {
            een.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public aom getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

