/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.Config;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityTypeNameLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<String, Integer> mapEntityLightLevels = new HashMap<String, Integer>();
    private static Map<bke, Integer> mapItemLightLevels = new HashMap<bke, Integer>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final tq<bki> PARAMETER_ITEM_STACK = (tq)Reflector.EntityItem_ITEM.getValue();
    private static boolean initialized;

    public static void entityAdded(aom entityIn, ebx renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(aom entityIn, ebx renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.V());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(ebx renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i = 0; i < modIds.length; ++i) {
            String modId = modIds[i];
            try {
                uh loc = new uh(modId, "optifine/dynamic_lights.properties");
                InputStream in = Config.getResourceStream(loc);
                DynamicLights.loadModConfiguration(in, loc.toString(), modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg("DynamicLights entities: " + mapEntityLightLevels.size());
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg("DynamicLights items: " + mapItemLightLevels.size());
        }
    }

    private static void loadModConfiguration(InputStream in, String path, String modId) {
        if (in == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("DynamicLights: Parsing " + path);
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels(props.getProperty("entities"), mapEntityLightLevels, new EntityTypeNameLocator(), cp, path, modId);
            DynamicLights.loadModLightLevels(props.getProperty("items"), mapItemLightLevels, new ItemLocator(), cp, path, modId);
        }
        catch (IOException e2) {
            Config.warn("DynamicLights: Error reading " + path);
        }
    }

    private static <T> void loadModLightLevels(String prop, Map<T, Integer> mapLightLevels, IObjectLocator<T> ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize(prop, " ");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String[] tokens = Config.tokenize(part, ":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            uh loc = new uh(nameFull);
            T obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(ebx renderGlobal) {
        dym world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        Iterable entities = world.b();
        for (aom entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = entity.V();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.V();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(fu pos, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPos, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(aom entity, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel(entity.cA());
        if (entity == Config.getMinecraft().s) {
            double lightOwn = DynamicLights.getLightLevel(entity);
            lightPos = Math.max(lightPos, lightOwn);
        }
        combinedLight = DynamicLights.getCombinedLight(lightPos, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(fu pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            int dynamicLightsSize = dynamicLights.size();
            for (int i = 0; i < dynamicLightsSize; ++i) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = dynamicLights.get(i);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.u() - px;
                double distSq = dx * dx + (dy = (double)pos.v() - py) * dy + (dz = (double)pos.w() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(bki itemStack) {
        Integer level;
        bim itemBlock;
        bvr block;
        if (itemStack == null) {
            return 0;
        }
        bke item = itemStack.b();
        if (item instanceof bim && (block = (itemBlock = (bim)item).e()) != null) {
            return block.n().f();
        }
        if (item == bkk.lM) {
            return bvs.B.n().f();
        }
        if (item == bkk.nr || item == bkk.nz) {
            return 10;
        }
        if (item == bkk.mk) {
            return 8;
        }
        if (item == bkk.pv) {
            return 8;
        }
        if (item == bkk.nA) {
            return 8;
        }
        if (item == bkk.pl) {
            return bvs.es.n().f() / 2;
        }
        if (!mapItemLightLevels.isEmpty() && (level = mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(aom entity) {
        bbn entityCreeper;
        String typeName;
        Integer level;
        bec player;
        if (entity == Config.getMinecraft().Z() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof bec && (player = (bec)entity).a_()) {
            return 0;
        }
        if (entity.bm()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = mapEntityLightLevels.get(typeName = EntityTypeNameLocator.getEntityTypeName(entity))) != null) {
            return level;
        }
        if (entity instanceof beh) {
            return 15;
        }
        if (entity instanceof bbh) {
            return 15;
        }
        if (entity instanceof bbl) {
            bbl entityBlaze = (bbl)entity;
            if (entityBlaze.bm()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof bca) {
            bca emc = (bca)entity;
            if ((double)emc.c > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof bbn && (double)(entityCreeper = (bbn)entity).u(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof aoy) {
            player = (aoy)entity;
            bki stackMain = player.dC();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            bki stackOff = player.dD();
            int levelOff = DynamicLights.getLightLevel(stackOff);
            bki stackHead = player.b(aor.f);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof bbg) {
            bbg entityItem = (bbg)entity;
            bki itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(ebx renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static bki getItemStack(bbg entityItem) {
        bki itemstack = (bki)entityItem.Y().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

