/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap<String, RandomEntityProperties>();
    private static boolean active = false;
    private static ebx renderGlobal;
    private static RandomEntity randomEntity;
    private static edw tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(aom entity, bqb world) {
        if (world == null) {
            return;
        }
        tt edm = entity.Y();
        edm.spawnPosition = entity.cA();
        edm.spawnBiome = world.v(edm.spawnPosition);
        if (entity instanceof aze) {
            aze esr = (aze)entity;
            RandomEntities.checkEntityShoulder(esr, false);
        }
    }

    public static void entityUnloaded(aom entity, bqb world) {
        if (entity instanceof aze) {
            aze esr = (aze)entity;
            RandomEntities.checkEntityShoulder(esr, true);
        }
    }

    private static void checkEntityShoulder(aze entity, boolean attach) {
        aoy owner = entity.eO();
        if (owner == null) {
            owner = Config.getMinecraft().s;
        }
        if (!(owner instanceof ebc)) {
            return;
        }
        ebc player = (ebc)owner;
        UUID entityUuid = entity.bR();
        if (attach) {
            le nbtRight;
            le nbtLeft = player.eP();
            if (nbtLeft != null && nbtLeft.e("UUID") && Config.equals(nbtLeft.a("UUID"), entityUuid)) {
                player.entityShoulderLeft = entity;
            }
            if ((nbtRight = player.eQ()) != null && nbtRight.e("UUID") && Config.equals(nbtRight.a("UUID"), entityUuid)) {
                player.entityShoulderRight = entity;
            }
        } else {
            tt edm = entity.Y();
            if (player.entityShoulderLeft != null && Config.equals(player.entityShoulderLeft.bR(), entityUuid)) {
                tt edmShoulderLeft = player.entityShoulderLeft.Y();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals(player.entityShoulderRight.bR(), entityUuid)) {
                tt edmShoulderRight = player.entityShoulderRight.Y();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(bqb oldWorld, bqb newWorld) {
        if (newWorld instanceof dym) {
            dym newWorldClient = (dym)newWorld;
            Iterable entities = newWorldClient.b();
            for (aom entity : entities) {
                RandomEntities.entityLoaded(entity, newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static uh getTextureLocation(uh loc) {
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity re = RandomEntities.getRandomEntityRendered();
            if (re == null) {
                uh uh2 = loc;
                return uh2;
            }
            String name = loc.a();
            if (name.startsWith(PREFIX_DYNAMIC_TEXTURE_HORSE)) {
                name = RandomEntities.getHorseTexturePath(name, PREFIX_DYNAMIC_TEXTURE_HORSE.length());
            }
            if (!name.startsWith(PREFIX_TEXTURES_ENTITY) && !name.startsWith(PREFIX_TEXTURES_PAINTING)) {
                uh uh3 = loc;
                return uh3;
            }
            RandomEntityProperties props = mapProperties.get(name);
            if (props == null) {
                uh uh4 = loc;
                return uh4;
            }
            uh uh5 = props.getTextureLocation(loc, re);
            return uh5;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i = 0; i < HORSE_TEXTURES_ABBR.length; ++i) {
            String abbr = HORSE_TEXTURES_ABBR[i];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i];
        }
        return path;
    }

    private static IRandomEntity getRandomEntityRendered() {
        cdl te;
        if (RandomEntities.renderGlobal.renderedEntity != null) {
            randomEntity.setEntity(RandomEntities.renderGlobal.renderedEntity);
            return randomEntity;
        }
        if (RandomEntities.tileEntityRendererDispatcher.tileEntityRendered != null && (te = RandomEntities.tileEntityRendererDispatcher.tileEntityRendered).v() != null) {
            randomTileEntity.setTileEntity(te);
            return randomTileEntity;
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(uh loc, boolean optifine) {
        RandomEntityProperties props;
        String path = loc.a();
        uh locProps = RandomEntities.getLocationProperties(loc, optifine);
        if (locProps != null && (props = RandomEntities.parseProperties(locProps, loc)) != null) {
            return props;
        }
        uh[] variants = RandomEntities.getLocationsVariants(loc, optifine);
        if (variants == null) {
            return null;
        }
        return new RandomEntityProperties(path, variants);
    }

    private static RandomEntityProperties parseProperties(uh propLoc, uh resLoc) {
        try {
            String path = propLoc.a();
            RandomEntities.dbg(resLoc.a() + ", properties: " + path);
            InputStream in = Config.getResourceStream(propLoc);
            if (in == null) {
                RandomEntities.warn("Properties not found: " + path);
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            RandomEntityProperties rmp = new RandomEntityProperties(props, path, resLoc);
            if (!rmp.isValid(path)) {
                return null;
            }
            return rmp;
        }
        catch (FileNotFoundException e2) {
            RandomEntities.warn("File not found: " + resLoc.a());
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    private static uh getLocationProperties(uh loc, boolean optifine) {
        String path;
        String pathBase;
        String pathProps;
        uh locMcp = RandomEntities.getLocationRandom(loc, optifine);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        uh locProps = new uh(domain, pathProps = (pathBase = StrUtils.removeSuffix(path = locMcp.a(), SUFFIX_PNG)) + SUFFIX_PROPERTIES);
        if (Config.hasResource(locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath(pathBase);
        if (pathParent == null) {
            return null;
        }
        uh locParentProps = new uh(domain, pathParent + SUFFIX_PROPERTIES);
        if (Config.hasResource(locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static uh getLocationRandom(uh loc, boolean optifine) {
        String domain = loc.b();
        String path = loc.a();
        String prefixTextures = PREFIX_TEXTURES;
        String prefixRandom = PREFIX_OPTIFINE_RANDOM;
        if (optifine) {
            prefixTextures = PREFIX_TEXTURES_ENTITY;
            prefixRandom = PREFIX_OPTIFINE_MOB;
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix(path, prefixTextures, prefixRandom);
        return new uh(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith(PREFIX_OPTIFINE_RANDOM)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_RANDOM, PREFIX_TEXTURES);
        }
        if (pathRandom.startsWith(PREFIX_OPTIFINE_MOB)) {
            return StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_MOB, PREFIX_TEXTURES_ENTITY);
        }
        return null;
    }

    protected static uh getLocationIndexed(uh loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String pathNew = prefix + index + suffix;
        uh locNew = new uh(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i = 0; i < DEPENDANT_SUFFIXES.length; ++i) {
            String suffix = DEPENDANT_SUFFIXES[i];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix(path, suffix);
            return pathParent;
        }
        return null;
    }

    private static uh[] getLocationsVariants(uh loc, boolean optifine) {
        ArrayList<uh> list = new ArrayList<uh>();
        list.add(loc);
        uh locRandom = RandomEntities.getLocationRandom(loc, optifine);
        if (locRandom == null) {
            return null;
        }
        for (int i = 1; i < list.size() + 10; ++i) {
            int index = i + 1;
            uh locIndex = RandomEntities.getLocationIndexed(locRandom, index);
            if (!Config.hasResource(locIndex)) continue;
            list.add(locIndex);
        }
        if (list.size() <= 1) {
            return null;
        }
        uh[] locs = list.toArray(new uh[list.size()]);
        RandomEntities.dbg(loc.a() + ", variants: " + locs.length);
        return locs;
    }

    public static void update() {
        mapProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        tileEntityRendererDispatcher = edw.a;
        String[] prefixes = new String[]{PREFIX_OPTIFINE_RANDOM, PREFIX_OPTIFINE_MOB};
        String[] suffixes = new String[]{SUFFIX_PNG, SUFFIX_PROPERTIES};
        String[] pathsRandom = ResUtils.collectFiles(prefixes, suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i = 0; i < pathsRandom.length; ++i) {
            RandomEntityProperties props;
            String path = pathsRandom[i];
            path = StrUtils.removeSuffix(path, suffixes);
            path = StrUtils.trimTrailing(path, "0123456789");
            String pathBase = RandomEntities.getPathBase(path = path + SUFFIX_PNG);
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            uh locBase = new uh(pathBase);
            if (!Config.hasResource(locBase) || (props = mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties(locBase, false);
            if (props == null) {
                props = RandomEntities.makeProperties(locBase, true);
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg("RandomEntities: " + str);
    }

    public static void warn(String str) {
        Config.warn("RandomEntities: " + str);
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, azo.class, String[].class, 0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, azo.class, String[].class, 1);
    }
}

