/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.gui;

import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProviderShaderOptions;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionProfile;
import net.optifine.shaders.config.ShaderOptionScreen;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.shaders.gui.GuiSliderShaderOption;

public class GuiShaderOptions
extends GuiScreenOF {
    private dqs prevScreen;
    private dmb settings;
    private TooltipManager tooltipManager = new TooltipManager(this, new TooltipProviderShaderOptions());
    private String screenName = null;
    private String screenText = null;
    private boolean changed = false;
    public static final String OPTION_PROFILE = "<profile>";
    public static final String OPTION_EMPTY = "<empty>";
    public static final String OPTION_REST = "*";

    public GuiShaderOptions(dqs guiscreen, dmb gamesettings) {
        super((mr)new nd(emq.a((String)"of.options.shaderOptionsTitle", (Object[])new Object[0])));
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    public GuiShaderOptions(dqs guiscreen, dmb gamesettings, String screenName) {
        this(guiscreen, gamesettings);
        this.screenName = screenName;
        if (screenName != null) {
            this.screenText = Shaders.translate("screen." + screenName, screenName);
        }
    }

    public void b() {
        int baseId = 100;
        int baseX = 0;
        int baseY = 30;
        int stepY = 20;
        int btnWidth = 120;
        int btnHeight = 20;
        int columns = Shaders.getShaderPackColumns(this.screenName, 2);
        ShaderOption[] ops = Shaders.getShaderPackOptions(this.screenName);
        if (ops != null) {
            int colsMin = aec.f((double)((double)ops.length / 9.0));
            if (columns < colsMin) {
                columns = colsMin;
            }
            for (int i = 0; i < ops.length; ++i) {
                ShaderOption so = ops[i];
                if (so == null || !so.isVisible()) continue;
                int col = i % columns;
                int row = i / columns;
                int colWidth = Math.min(this.k / columns, 200);
                baseX = (this.k - colWidth * columns) / 2;
                int x = col * colWidth + 5 + baseX;
                int y = baseY + row * stepY;
                int w = colWidth - 10;
                int h2 = btnHeight;
                String text = GuiShaderOptions.getButtonText(so, w);
                GuiButtonShaderOption btn = Shaders.isShaderPackOptionSlider(so.getName()) ? new GuiSliderShaderOption(baseId + i, x, y, w, h2, so, text) : new GuiButtonShaderOption(baseId + i, x, y, w, h2, so, text);
                btn.o = so.isEnabled();
                this.a((dng)btn);
            }
        }
        this.a((dng)new GuiButtonOF(201, this.k / 2 - btnWidth - 20, this.l / 6 + 168 + 11, btnWidth, btnHeight, emq.a((String)"controls.reset", (Object[])new Object[0])));
        this.a((dng)new GuiButtonOF(200, this.k / 2 + 20, this.l / 6 + 168 + 11, btnWidth, btnHeight, emq.a((String)"gui.done", (Object[])new Object[0])));
    }

    public static String getButtonText(ShaderOption so, int btnWidth) {
        String labelName = so.getNameText();
        if (so instanceof ShaderOptionScreen) {
            ShaderOptionScreen soScr = (ShaderOptionScreen)so;
            return labelName + "...";
        }
        dmt fr = Config.getMinecraft().g;
        int lenSuffix = fr.b(": " + Lang.getOff()) + 5;
        while (fr.b(labelName) + lenSuffix >= btnWidth && labelName.length() > 0) {
            labelName = labelName.substring(0, labelName.length() - 1);
        }
        String col = so.isChanged() ? so.getValueColor(so.getValue()) : "";
        String labelValue = so.getValueText(so.getValue());
        return labelName + ": " + col + labelValue;
    }

    @Override
    protected void actionPerformed(dng guiElement) {
        if (!(guiElement instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF guibutton = (GuiButtonOF)guiElement;
        if (!guibutton.o) {
            return;
        }
        if (guibutton.id < 200 && guibutton instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guibutton;
            ShaderOption so = btnSo.getShaderOption();
            if (so instanceof ShaderOptionScreen) {
                String screenName = so.getName();
                GuiShaderOptions scr = new GuiShaderOptions(this, this.settings, screenName);
                this.i.a((dqs)scr);
                return;
            }
            if (GuiShaderOptions.s()) {
                so.resetValue();
            } else if (btnSo.isSwitchable()) {
                so.nextValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
        if (guibutton.id == 201) {
            ShaderOption[] opts = Shaders.getChangedOptions(Shaders.getShaderPackOptions());
            for (int i = 0; i < opts.length; ++i) {
                ShaderOption opt = opts[i];
                opt.resetValue();
                this.changed = true;
            }
            this.updateAllButtons();
        }
        if (guibutton.id == 200) {
            if (this.changed) {
                Shaders.saveShaderPackOptions();
                this.changed = false;
                Shaders.uninit();
            }
            this.i.a(this.prevScreen);
        }
    }

    public void e() {
        if (this.changed) {
            Shaders.saveShaderPackOptions();
            this.changed = false;
            Shaders.uninit();
        }
        super.e();
    }

    @Override
    protected void actionPerformedRightClick(dng guiElement) {
        if (guiElement instanceof GuiButtonShaderOption) {
            GuiButtonShaderOption btnSo = (GuiButtonShaderOption)guiElement;
            ShaderOption so = btnSo.getShaderOption();
            if (GuiShaderOptions.s()) {
                so.resetValue();
            } else if (btnSo.isSwitchable()) {
                so.prevValue();
            }
            this.updateAllButtons();
            this.changed = true;
        }
    }

    private void updateAllButtons() {
        for (dni btn : this.buttonList) {
            if (!(btn instanceof GuiButtonShaderOption)) continue;
            GuiButtonShaderOption gbso = (GuiButtonShaderOption)btn;
            ShaderOption opt = gbso.getShaderOption();
            if (opt instanceof ShaderOptionProfile) {
                ShaderOptionProfile optProf = (ShaderOptionProfile)opt;
                optProf.updateProfile();
            }
            gbso.setMessage(GuiShaderOptions.getButtonText(opt, gbso.h()));
            gbso.valueChanged();
        }
    }

    public void a(dhl matrixStackIn, int x, int y, float partialTicks) {
        this.a(matrixStackIn);
        if (this.screenText != null) {
            this.a(matrixStackIn, this.fontRenderer, this.screenText, this.k / 2, 15, 0xFFFFFF);
        } else {
            this.a(matrixStackIn, this.fontRenderer, (mu)this.d, this.k / 2, 15, 0xFFFFFF);
        }
        super.a(matrixStackIn, x, y, partialTicks);
        this.tooltipManager.drawTooltips(matrixStackIn, x, y, this.buttonList);
    }
}

