/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import net.optifine.expr.IExpressionBool;

public enum ShaderParameterBool implements IExpressionBool
{
    IS_ALIVE("is_alive"),
    IS_BURNING("is_burning"),
    IS_CHILD("is_child"),
    IS_GLOWING("is_glowing"),
    IS_HURT("is_hurt"),
    IS_IN_LAVA("is_in_lava"),
    IS_IN_WATER("is_in_water"),
    IS_INVISIBLE("is_invisible"),
    IS_ON_GROUND("is_on_ground"),
    IS_RIDDEN("is_ridden"),
    IS_RIDING("is_riding"),
    IS_SNEAKING("is_sneaking"),
    IS_SPRINTING("is_sprinting"),
    IS_WET("is_wet");

    private String name;
    private egm renderManager;
    private static final ShaderParameterBool[] VALUES;

    private ShaderParameterBool(String name) {
        this.name = name;
        this.renderManager = dlx.B().ab();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean eval() {
        aom entityGeneral = dlx.B().Z();
        if (entityGeneral instanceof aoy) {
            aoy entity = (aoy)entityGeneral;
            switch (this) {
                case IS_ALIVE: {
                    return entity.aU();
                }
                case IS_BURNING: {
                    return entity.bm();
                }
                case IS_CHILD: {
                    return entity.x_();
                }
                case IS_GLOWING: {
                    return entity.bA();
                }
                case IS_HURT: {
                    return entity.au > 0;
                }
                case IS_IN_LAVA: {
                    return entity.aN();
                }
                case IS_IN_WATER: {
                    return entity.aA();
                }
                case IS_INVISIBLE: {
                    return entity.bB();
                }
                case IS_ON_GROUND: {
                    return entity.aj();
                }
                case IS_RIDDEN: {
                    return entity.bo();
                }
                case IS_RIDING: {
                    return entity.bn();
                }
                case IS_SNEAKING: {
                    return entity.bv();
                }
                case IS_SPRINTING: {
                    return entity.bw();
                }
                case IS_WET: {
                    return entity.aB();
                }
            }
        }
        return false;
    }

    public static ShaderParameterBool parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i = 0; i < VALUES.length; ++i) {
            ShaderParameterBool type = VALUES[i];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = ShaderParameterBool.values();
    }
}

