/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.nio.ByteBuffer;

public class BufferUtils {
    public static String getBufferHex(dfe bb) {
        int drawMode = bb.getDrawMode();
        String primitiveName = "";
        int vertexPerPrimitive = -1;
        if (drawMode == 7) {
            primitiveName = "quad";
            vertexPerPrimitive = 4;
        } else if (drawMode == 4) {
            primitiveName = "triangle";
            vertexPerPrimitive = 3;
        } else {
            return "Invalid draw mode: " + drawMode;
        }
        StringBuffer sb = new StringBuffer();
        int vertexCount = bb.getVertexCount();
        for (int v2 = 0; v2 < vertexCount; ++v2) {
            if (v2 % vertexPerPrimitive == 0) {
                sb.append(primitiveName + " " + v2 / vertexPerPrimitive + "\n");
            }
            String vs = BufferUtils.getVertexHex(v2, bb);
            sb.append(vs);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String getVertexHex(int vertex, dfe bb) {
        StringBuffer sb = new StringBuffer();
        ByteBuffer buf = bb.getByteBuffer();
        dfo vf = bb.getVertexFormat();
        int pos = bb.getStartPosition() + vertex * vf.b();
        for (dfp vfe : vf.c()) {
            if (vfe.getElementCount() > 0) {
                sb.append("(");
            }
            for (int i = 0; i < vfe.getElementCount(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                switch (vfe.a()) {
                    case a: {
                        sb.append(buf.getFloat(pos));
                        break;
                    }
                    case b: 
                    case c: {
                        sb.append(buf.get(pos));
                        break;
                    }
                    case d: 
                    case e: {
                        sb.append(buf.getShort(pos));
                        break;
                    }
                    case f: 
                    case g: {
                        sb.append(buf.getShort(pos));
                        break;
                    }
                    default: {
                        sb.append("??");
                    }
                }
                pos += vfe.a().a();
            }
            if (vfe.getElementCount() <= 0) continue;
            sb.append(")");
        }
        return sb.toString();
    }
}

