/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<aqb, cch> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(aqb entityType, String name, float shadowSize) {
        this(Either.makeLeft(entityType), name, shadowSize, null);
    }

    public ModelAdapter(aqb entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft(entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(cch tileEntityType, String name, float shadowSize) {
        this(Either.makeRight(tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(Either<aqb, cch> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<aqb, cch> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract dun makeModel();

    public abstract dwf getModelRenderer(dun var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(dun var1, float var2);

    public dwf[] getModelRenderers(dun model) {
        String[] names = this.getModelRendererNames();
        ArrayList<dwf> list = new ArrayList<dwf>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            dwf mr2 = this.getModelRenderer(model, name);
            if (mr2 == null) continue;
            list.add(mr2);
        }
        dwf[] mrs = list.toArray(new dwf[list.size()]);
        return mrs;
    }
}

