/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Random;

public class TestMath {
    static Random random = new Random();

    public static void main(String[] args) {
        int count = 1000000;
        TestMath.dbg("Test math: " + count);
        for (int i = 0; i < 1000000; ++i) {
            TestMath.testMatrix4f_mulTranslate();
            TestMath.testMatrix4f_mulScale();
            TestMath.testMatrix4f_mulQuaternion();
            TestMath.testMatrix3f_mulQuaternion();
            TestMath.testVector4f_transform();
            TestMath.testVector3f_transform();
        }
        TestMath.dbg("Done");
    }

    private static void testMatrix4f_mulTranslate() {
        b m2 = new b();
        m2.setRandom(random);
        b m22 = m2.d();
        float x2 = random.nextFloat();
        float y = random.nextFloat();
        float z = random.nextFloat();
        m2.a(b.b((float)x2, (float)y, (float)z));
        m22.mulTranslate(x2, y, z);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testMatrix4f_mulScale() {
        b m2 = new b();
        m2.setRandom(random);
        b m22 = m2.d();
        float x2 = random.nextFloat();
        float y = random.nextFloat();
        float z = random.nextFloat();
        m2.a(b.a((float)x2, (float)y, (float)z));
        m22.mulScale(x2, y, z);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testMatrix4f_mulQuaternion() {
        b m2 = new b();
        m2.setRandom(random);
        b m22 = m2.d();
        d q2 = new d(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.a(new b(q2));
        m22.a(q2);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testMatrix3f_mulQuaternion() {
        a m2 = new a();
        m2.setRandom(random);
        a m22 = m2.d();
        d q2 = new d(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.b(new a(q2));
        m22.a(q2);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(m2.toString());
            TestMath.dbg(m22.toString());
        }
    }

    private static void testVector3f_transform() {
        g v2 = new g(random.nextFloat(), random.nextFloat(), random.nextFloat());
        g v22 = v2.e();
        a m2 = new a();
        m2.setRandom(random);
        v2.a(m2);
        float x2 = m2.getTransformX(v22.a(), v22.b(), v22.c());
        float y = m2.getTransformY(v22.a(), v22.b(), v22.c());
        float z = m2.getTransformZ(v22.a(), v22.b(), v22.c());
        v22 = new g(x2, y, z);
        if (!v22.equals((Object)v2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(v2.toString());
            TestMath.dbg(v22.toString());
        }
    }

    private static void testVector4f_transform() {
        h v2 = new h(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        h v22 = new h(v2.a(), v2.b(), v2.c(), v2.d());
        b m2 = new b();
        m2.setRandom(random);
        v2.a(m2);
        float x2 = m2.getTransformX(v22.a(), v22.b(), v22.c(), v22.d());
        float y = m2.getTransformY(v22.a(), v22.b(), v22.c(), v22.d());
        float z = m2.getTransformZ(v22.a(), v22.b(), v22.c(), v22.d());
        float w = m2.getTransformW(v22.a(), v22.b(), v22.c(), v22.d());
        v22 = new h(x2, y, z, w);
        if (!v22.equals((Object)v2)) {
            TestMath.dbg("*** DIFFERENT ***");
            TestMath.dbg(v2.toString());
            TestMath.dbg(v22.toString());
        }
    }

    private static void dbg(String str) {
        System.out.println(str);
    }
}

