/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import net.optifine.expr.IExpressionBool;

public enum ShaderParameterBool implements IExpressionBool
{
    IS_ALIVE("is_alive"),
    IS_BURNING("is_burning"),
    IS_CHILD("is_child"),
    IS_GLOWING("is_glowing"),
    IS_HURT("is_hurt"),
    IS_IN_LAVA("is_in_lava"),
    IS_IN_WATER("is_in_water"),
    IS_INVISIBLE("is_invisible"),
    IS_ON_GROUND("is_on_ground"),
    IS_RIDDEN("is_ridden"),
    IS_RIDING("is_riding"),
    IS_SNEAKING("is_sneaking"),
    IS_SPRINTING("is_sprinting"),
    IS_WET("is_wet");

    private String name;
    private eel renderManager;
    private static final ShaderParameterBool[] VALUES;

    private ShaderParameterBool(String name) {
        this.name = name;
        this.renderManager = djw.B().ab();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean eval() {
        apx entityGeneral = djw.B().Z();
        if (entityGeneral instanceof aqj) {
            aqj entity = (aqj)entityGeneral;
            switch (this) {
                case IS_ALIVE: {
                    return entity.aW();
                }
                case IS_BURNING: {
                    return entity.bp();
                }
                case IS_CHILD: {
                    return entity.w_();
                }
                case IS_GLOWING: {
                    return entity.bD();
                }
                case IS_HURT: {
                    return entity.an > 0;
                }
                case IS_IN_LAVA: {
                    return entity.aP();
                }
                case IS_IN_WATER: {
                    return entity.aD();
                }
                case IS_INVISIBLE: {
                    return entity.bE();
                }
                case IS_ON_GROUND: {
                    return entity.an();
                }
                case IS_RIDDEN: {
                    return entity.br();
                }
                case IS_RIDING: {
                    return entity.bq();
                }
                case IS_SNEAKING: {
                    return entity.by();
                }
                case IS_SPRINTING: {
                    return entity.bz();
                }
                case IS_WET: {
                    return entity.aE();
                }
            }
        }
        return false;
    }

    public static ShaderParameterBool parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i = 0; i < VALUES.length; ++i) {
            ShaderParameterBool type = VALUES[i];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = ShaderParameterBool.values();
    }
}

