/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.config.VillagerProfession;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<kl, kl> textureLocations = null;
    private NbtTagValue nbtName = null;
    private aig[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private VillagerProfession[] professions = null;
    private EnumVariant[] variants = null;
    private act[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final act[] COLORS_INVALID = new act[0];
    private static final kl ANVIL_GUI_TEXTURE = new kl("textures/gui/container/anvil.png");
    private static final kl BEACON_GUI_TEXTURE = new kl("textures/gui/container/beacon.png");
    private static final kl BREWING_STAND_GUI_TEXTURE = new kl("textures/gui/container/brewing_stand.png");
    private static final kl CHEST_GUI_TEXTURE = new kl("textures/gui/container/generic_54.png");
    private static final kl CRAFTING_TABLE_GUI_TEXTURE = new kl("textures/gui/container/crafting_table.png");
    private static final kl HORSE_GUI_TEXTURE = new kl("textures/gui/container/horse.png");
    private static final kl DISPENSER_GUI_TEXTURE = new kl("textures/gui/container/dispenser.png");
    private static final kl ENCHANTMENT_TABLE_GUI_TEXTURE = new kl("textures/gui/container/enchanting_table.png");
    private static final kl FURNACE_GUI_TEXTURE = new kl("textures/gui/container/furnace.png");
    private static final kl HOPPER_GUI_TEXTURE = new kl("textures/gui/container/hopper.png");
    private static final kl INVENTORY_GUI_TEXTURE = new kl("textures/gui/container/inventory.png");
    private static final kl SHULKER_BOX_GUI_TEXTURE = new kl("textures/gui/container/shulker_box.png");
    private static final kl VILLAGER_GUI_TEXTURE = new kl("textures/gui/container/villager.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static act[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        act[] cols = new act[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            act col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static act parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        act[] colors = act.values();
        for (int i = 0; i < colors.length; ++i) {
            act enumDyeColor = colors[i];
            if (enumDyeColor.m().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.d().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static kl parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new kl(basePath + "/" + tex);
    }

    private static Map<kl, kl> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<kl, kl> map = new HashMap<kl, kl>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            kl locKey = CustomGuiProperties.getGuiTextureLocation(container);
            kl locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            kl locKey = new kl(path);
            kl locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static kl getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec2, cl pos, ahx blockAccess) {
        aig biome;
        if (this.container != ec2) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.b(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.q());
    }

    public boolean matchesPos(EnumContainer ec2, cl pos, ahx blockAccess, bez screen) {
        String name;
        if (!this.matchesGeneral(ec2, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec2) {
            case BEACON: {
                return this.matchesBeacon(pos, blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, blockAccess);
            }
        }
        return true;
    }

    public static String getName(bez screen) {
        qt nameable = CustomGuiProperties.getWorldNameable(screen);
        if (nameable == null) {
            return null;
        }
        return nameable.i_().c();
    }

    private static qt getWorldNameable(bez screen) {
        if (screen instanceof bft) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBeacon_tileBeacon);
        }
        if (screen instanceof bfv) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBrewingStand_tileBrewingStand);
        }
        if (screen instanceof bfx) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiChest_lowerChestInventory);
        }
        if (screen instanceof bgb) {
            return ((bgb)screen).u;
        }
        if (screen instanceof bge) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiEnchantment_nameable);
        }
        if (screen instanceof bgf) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiFurnace_tileFurnace);
        }
        if (screen instanceof bgg) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiHopper_hopperInventory);
        }
        return null;
    }

    private static qt getWorldNameable(bez screen, ReflectorField fieldInventory) {
        Object obj = Reflector.getFieldValue(screen, fieldInventory);
        if (!(obj instanceof qt)) {
            return null;
        }
        return (qt)obj;
    }

    private boolean matchesBeacon(cl pos, ahx blockAccess) {
        apv te = blockAccess.r(pos);
        if (!(te instanceof apu)) {
            return false;
        }
        apu teb = (apu)te;
        if (this.levels != null) {
            dq nbt = new dq();
            teb.b(nbt);
            int l = nbt.h("Levels");
            if (!this.levels.isInRange(l)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(cl pos, ahx blockAccess) {
        apv te = blockAccess.r(pos);
        if (te instanceof apx) {
            apx tec = (apx)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof aqe) {
            aqe teec = (aqe)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(apx tec, cl pos, ahx blockAccess) {
        boolean isLarge = tec.h != null || tec.g != null || tec.f != null || tec.i != null;
        boolean isTrapped = tec.o() == ake.a.b;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(aqe teec, cl pos, ahx blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(cl pos, ahx blockAccess) {
        EnumVariant var;
        apv te = blockAccess.r(pos);
        if (!(te instanceof aqb)) {
            return false;
        }
        aqb ted = (aqb)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(aqb ted) {
        if (ted instanceof aqc) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    public boolean matchesEntity(EnumContainer ec2, rr entity, ahx blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec2, entity.c(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.h_())) {
            return false;
        }
        switch (ec2) {
            case VILLAGER: {
                return this.matchesVillager(entity, blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(rr entity, ahx blockAccess) {
        if (!(entity instanceof ze)) {
            return false;
        }
        ze entityVillager = (ze)entity;
        if (this.professions != null) {
            int profInt = entityVillager.da();
            int careerInt = Reflector.getFieldValueInt(entityVillager, Reflector.EntityVillager_careerId, -1);
            if (careerInt < 0) {
                return false;
            }
            boolean matchProfession = false;
            for (int i = 0; i < this.professions.length; ++i) {
                VillagerProfession prof = this.professions[i];
                if (!prof.matches(profInt, careerInt)) continue;
                matchProfession = true;
                break;
            }
            if (!matchProfession) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesHorse(rr entity, ahx blockAccess) {
        EnumVariant var;
        if (!(entity instanceof wk)) {
            return false;
        }
        wk ah = (wk)entity;
        return this.variants == null || Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants);
    }

    private EnumVariant getHorseVariant(wk entity) {
        wm type = entity.da();
        switch (type) {
            case a: {
                return EnumVariant.HORSE;
            }
            case b: {
                return EnumVariant.DONKEY;
            }
            case c: {
                return EnumVariant.MULE;
            }
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public kl getTextureLocation(kl loc) {
        kl locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

        public static final EnumContainer[] VALUES;

        static {
            VALUES = EnumContainer.values();
        }
    }
}

