/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.optifine.model.ModelUtils;
import org.lwjgl.util.vector.Vector3f;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;

    public static bxl makeModelCube(String spriteName, int tintIndex) {
        bve sprite = Config.getMinecraft().R().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static bxl makeModelCube(bve sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        cs[] facings = cs.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            cs facing = facings[i];
            ArrayList<boc> quads = new ArrayList<boc>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        bon itemOverrideList = new bon(new ArrayList());
        bxs bakedModel = new bxs(generalQuads, faceQuads, true, true, sprite, bop.a, itemOverrideList);
        return bakedModel;
    }

    public static bxl joinModelsCube(bxl modelBase, bxl modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, 0L));
        generalQuads.addAll(modelAdd.a(null, null, 0L));
        cs[] facings = cs.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            cs facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, 0L));
            quads.addAll(modelAdd.a(null, facing, 0L));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.c();
        bve sprite = modelBase.d();
        bop transforms = modelBase.e();
        bon itemOverrideList = modelBase.f();
        bxs bakedModel = new bxs(generalQuads, faceQuads, ao, builtIn, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static boc makeBakedQuad(cs facing, bve sprite, int tintIndex) {
        Vector3f posFrom = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f posTo = new Vector3f(16.0f, 16.0f, 16.0f);
        bog uv = new bog(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        boe face = new boe(facing, tintIndex, "#" + facing.m(), uv);
        bxm modelRotation = bxm.a;
        bof partRotation = null;
        boolean uvLocked = false;
        boolean shade = true;
        bok faceBakery = new bok();
        boc quad = faceBakery.a(posFrom, posTo, face, sprite, facing, modelRotation, partRotation, uvLocked, shade);
        return quad;
    }

    public static bxl makeModel(String modelName, String spriteOldName, String spriteNewName) {
        bvd textureMap = Config.getMinecraft().R();
        bve spriteOld = textureMap.getSpriteSafe(spriteOldName);
        bve spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static bxl makeModel(String modelName, bve spriteOld, bve spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        bxp modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        bxq mrl = new bxq(modelName, "normal");
        bxl model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        bxl modelNew = ModelUtils.duplicateModel(model);
        cs[] faces = cs.n;
        for (int i = 0; i < faces.length; ++i) {
            cs face = faces[i];
            List quads = modelNew.a(null, face, 0L);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, 0L);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<boc> quads, bve spriteOld, bve spriteNew) {
        ArrayList<boc> quadsNew = new ArrayList<boc>();
        for (boc quad : quads) {
            if (quad.a() == spriteOld) {
                quad = new boj(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.setX(BlockModelUtils.snapVertexCoord(pos.getX()));
        pos.setY(BlockModelUtils.snapVertexCoord(pos.getY()));
        pos.setZ(BlockModelUtils.snapVertexCoord(pos.getZ()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static bbf getOffsetBoundingBox(bbf aabb, ajt.a offsetType, cl pos) {
        int x = pos.p();
        int z = pos.r();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx2 = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == ajt.a.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.c(dx2, dy, dz);
    }
}

