/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import net.optifine.BlockPosM;
import net.optifine.shaders.IteratorAxis;

public class Iterator3d
implements Iterator<cl> {
    private IteratorAxis iteratorAxis;
    private BlockPosM blockPos = new BlockPosM(0, 0, 0);
    private int axis = 0;
    private int kX;
    private int kY;
    private int kZ;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;

    public Iterator3d(cl posStart, cl posEnd, int width, int height) {
        boolean revX = posStart.p() > posEnd.p();
        boolean revY = posStart.q() > posEnd.q();
        boolean revZ = posStart.r() > posEnd.r();
        posStart = this.reverseCoord(posStart, revX, revY, revZ);
        posEnd = this.reverseCoord(posEnd, revX, revY, revZ);
        this.kX = revX ? -1 : 1;
        this.kY = revY ? -1 : 1;
        this.kZ = revZ ? -1 : 1;
        bbh vec = new bbh((double)(posEnd.p() - posStart.p()), (double)(posEnd.q() - posStart.q()), (double)(posEnd.r() - posStart.r()));
        bbh vecN = vec.a();
        bbh vecX = new bbh(1.0, 0.0, 0.0);
        double dotX = vecN.b(vecX);
        double dotXabs = Math.abs(dotX);
        bbh vecY = new bbh(0.0, 1.0, 0.0);
        double dotY = vecN.b(vecY);
        double dotYabs = Math.abs(dotY);
        bbh vecZ = new bbh(0.0, 0.0, 1.0);
        double dotZ = vecN.b(vecZ);
        double dotZabs = Math.abs(dotZ);
        if (dotZabs >= dotYabs && dotZabs >= dotXabs) {
            this.axis = 2;
            cl pos1 = new cl(posStart.r(), posStart.q() - width, posStart.p() - height);
            cl pos2 = new cl(posEnd.r(), posStart.q() + width + 1, posStart.p() + height + 1);
            int countX = posEnd.r() - posStart.r();
            double deltaY = (double)(posEnd.q() - posStart.q()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else if (dotYabs >= dotXabs && dotYabs >= dotZabs) {
            this.axis = 1;
            cl pos1 = new cl(posStart.q(), posStart.p() - width, posStart.r() - height);
            cl pos2 = new cl(posEnd.q(), posStart.p() + width + 1, posStart.r() + height + 1);
            int countX = posEnd.q() - posStart.q();
            double deltaY = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.r() - posStart.r()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else {
            this.axis = 0;
            cl pos1 = new cl(posStart.p(), posStart.q() - width, posStart.r() - height);
            cl pos2 = new cl(posEnd.p(), posStart.q() + width + 1, posStart.r() + height + 1);
            int countX = posEnd.p() - posStart.p();
            double deltaY = (double)(posEnd.q() - posStart.q()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.r() - posStart.r()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        }
    }

    private cl reverseCoord(cl pos, boolean revX, boolean revY, boolean revZ) {
        if (revX) {
            pos = new cl(-pos.p(), pos.q(), pos.r());
        }
        if (revY) {
            pos = new cl(pos.p(), -pos.q(), pos.r());
        }
        if (revZ) {
            pos = new cl(pos.p(), pos.q(), -pos.r());
        }
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAxis.hasNext();
    }

    @Override
    public cl next() {
        cl pos = this.iteratorAxis.next();
        switch (this.axis) {
            case 0: {
                this.blockPos.setXyz(pos.p() * this.kX, pos.q() * this.kY, pos.r() * this.kZ);
                return this.blockPos;
            }
            case 1: {
                this.blockPos.setXyz(pos.q() * this.kX, pos.p() * this.kY, pos.r() * this.kZ);
                return this.blockPos;
            }
            case 2: {
                this.blockPos.setXyz(pos.r() * this.kX, pos.q() * this.kY, pos.p() * this.kZ);
                return this.blockPos;
            }
        }
        this.blockPos.setXyz(pos.p() * this.kX, pos.q() * this.kY, pos.r() * this.kZ);
        return this.blockPos;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported");
    }

    public static void main(String[] args) {
        cl posStart = new cl(10, 20, 30);
        cl posEnd = new cl(30, 40, 20);
        Iterator3d it = new Iterator3d(posStart, posEnd, 1, 1);
        while (it.hasNext()) {
            cl blockPos = it.next();
            System.out.println("" + blockPos);
        }
    }
}

